/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.menu;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.oddlama.vane.core.Core;
import org.oddlama.vane.core.functional.Consumer1;
import org.oddlama.vane.core.functional.Consumer2;
import org.oddlama.vane.core.menu.MenuManager;
import org.oddlama.vane.core.menu.MenuWidget;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.Module;

public class Menu {
    protected final MenuManager manager;
    protected Inventory inventory = null;
    private final Set<MenuWidget> widgets = new HashSet<MenuWidget>();
    private Consumer2<Player, InventoryCloseEvent.Reason> on_close = null;
    private Consumer1<Player> on_natural_close = null;
    private Object tag = null;
    protected boolean tainted = false;

    protected Menu(Context<?> context) {
        this.manager = ((Module)context.get_module()).core.menu_manager;
    }

    public Menu(Context<?> context, Inventory inventory) {
        this.manager = ((Module)context.get_module()).core.menu_manager;
        this.inventory = inventory;
    }

    public MenuManager manager() {
        return this.manager;
    }

    public Inventory inventory() {
        return this.inventory;
    }

    public Object tag() {
        return this.tag;
    }

    public Menu tag(Object tag) {
        this.tag = tag;
        return this;
    }

    public void taint() {
        this.tainted = true;
    }

    public void add(MenuWidget widget) {
        this.widgets.add(widget);
    }

    public boolean remove(MenuWidget widget) {
        return this.widgets.remove(widget);
    }

    public void update() {
        this.update(false);
    }

    public void update(boolean force_update) {
        int updated = this.widgets.stream().mapToInt(w -> w.update(this) ? 1 : 0).sum();
        if (updated > 0 || force_update) {
            this.manager.update(this);
        }
    }

    public void open_window(Player player) {
        if (this.tainted) {
            return;
        }
        player.openInventory(this.inventory);
    }

    public final void open(Player player) {
        if (this.tainted) {
            return;
        }
        this.update(true);
        this.manager.schedule_next_tick(() -> {
            this.manager.add(player, this);
            this.open_window(player);
        });
    }

    public boolean close(Player player) {
        return this.close(player, InventoryCloseEvent.Reason.PLUGIN);
    }

    public boolean close(Player player, InventoryCloseEvent.Reason reason) {
        Inventory top_inventory = player.getOpenInventory().getTopInventory();
        if (top_inventory != this.inventory) {
            try {
                throw new RuntimeException("Invalid close from unrelated menu.");
            }
            catch (RuntimeException e) {
                ((Core)this.manager.get_module()).log.log(Level.WARNING, "Tried to close menu inventory that isn't opened by the player " + String.valueOf(player), e);
                return false;
            }
        }
        this.manager.schedule_next_tick(() -> player.closeInventory(reason));
        return true;
    }

    public Consumer2<Player, InventoryCloseEvent.Reason> get_on_close() {
        return this.on_close;
    }

    public Menu on_close(Consumer2<Player, InventoryCloseEvent.Reason> on_close) {
        this.on_close = on_close;
        return this;
    }

    public Consumer1<Player> get_on_natural_close() {
        return this.on_natural_close;
    }

    public Menu on_natural_close(Consumer1<Player> on_natural_close) {
        this.on_natural_close = on_natural_close;
        return this;
    }

    public final void closed(Player player, InventoryCloseEvent.Reason reason) {
        if (reason == InventoryCloseEvent.Reason.PLAYER && this.on_natural_close != null) {
            this.on_natural_close.apply(player);
        } else if (this.on_close != null) {
            this.on_close.apply(player, reason);
        }
        this.inventory.clear();
        this.manager.remove(player, this);
    }

    public ClickResult on_click(Player player, ItemStack item, int slot, InventoryClickEvent event) {
        return ClickResult.IGNORE;
    }

    public final void click(Player player, ItemStack item, int slot, InventoryClickEvent event) {
        if (event.getAction() == InventoryAction.UNKNOWN) {
            return;
        }
        ClickResult result = ClickResult.IGNORE;
        result = ClickResult.or(result, this.on_click(player, item, slot, event));
        for (MenuWidget widget : this.widgets) {
            result = ClickResult.or(result, widget.click(player, this, item, slot, event));
        }
        switch (result.ordinal()) {
            default: {
                break;
            }
            case 2: {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, SoundCategory.MASTER, 1.0f, 1.0f);
                break;
            }
            case 3: {
                player.playSound(player.getLocation(), Sound.BLOCK_FIRE_EXTINGUISH, SoundCategory.MASTER, 1.0f, 1.0f);
            }
        }
    }

    public static boolean is_left_or_right_click(InventoryClickEvent event) {
        ClickType type = event.getClick();
        return type == ClickType.LEFT || type == ClickType.RIGHT;
    }

    public static boolean is_left_click(InventoryClickEvent event) {
        ClickType type = event.getClick();
        return type == ClickType.LEFT;
    }

    public static enum ClickResult {
        IGNORE(0),
        INVALID_CLICK(1),
        SUCCESS(2),
        ERROR(3);

        private int priority;

        private ClickResult(int priority) {
            this.priority = priority;
        }

        public static ClickResult or(ClickResult a, ClickResult b) {
            return a.priority > b.priority ? a : b;
        }
    }
}

