/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.menu;

import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;
import org.oddlama.vane.core.functional.Consumer1;
import org.oddlama.vane.core.functional.Function1;
import org.oddlama.vane.core.functional.Function2;
import org.oddlama.vane.core.functional.Function3;
import org.oddlama.vane.core.functional.Function4;
import org.oddlama.vane.core.material.HeadMaterial;
import org.oddlama.vane.core.material.HeadMaterialLibrary;
import org.oddlama.vane.core.menu.AnvilMenu;
import org.oddlama.vane.core.menu.Filter;
import org.oddlama.vane.core.menu.GenericSelector;
import org.oddlama.vane.core.menu.HeadFilter;
import org.oddlama.vane.core.menu.Menu;
import org.oddlama.vane.core.menu.MenuItem;
import org.oddlama.vane.core.menu.MenuItemClickListener;
import org.oddlama.vane.core.menu.MenuManager;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.Module;
import org.oddlama.vane.util.ItemUtil;

public class MenuFactory {
    public static Menu anvil_string_input(Context<?> context, Player player, String title, ItemStack _input_item, String default_name, Function3<Player, Menu, String, Menu.ClickResult> on_click) {
        ItemStack input_item = _input_item.clone();
        ItemMeta meta = input_item.getItemMeta();
        meta.displayName((Component)LegacyComponentSerializer.legacySection().deserialize(default_name));
        input_item.setItemMeta(meta);
        AnvilMenu anvil = new AnvilMenu(context, player, title);
        anvil.add(new MenuItem(0, input_item));
        anvil.add(new MenuItemClickListener(2, (p, menu, item) -> (Menu.ClickResult)((Object)((Object)on_click.apply((Player)p, (Menu)menu, ItemUtil.name_of(item))))));
        return anvil;
    }

    public static Menu confirm(Context<?> context, String title, ItemStack item_confirm, Function1<Player, Menu.ClickResult> on_confirm, ItemStack item_cancel, Consumer1<Player> on_cancel) {
        int columns = 9;
        Menu confirmation_menu = new Menu(context, Bukkit.createInventory(null, (int)9, (Component)LegacyComponentSerializer.legacySection().deserialize(title)));
        int confirm_index = (int)(Math.random() * 9.0);
        for (int i = 0; i < 9; ++i) {
            if (i == confirm_index) {
                confirmation_menu.add(new MenuItem(i, item_confirm, (player, menu, self) -> {
                    menu.close((Player)player);
                    return (Menu.ClickResult)((Object)((Object)on_confirm.apply((Player)player)));
                }));
                continue;
            }
            confirmation_menu.add(new MenuItem(i, item_cancel, (player, menu, self) -> {
                menu.close((Player)player);
                on_cancel.apply((Player)player);
                return Menu.ClickResult.SUCCESS;
            }));
        }
        confirmation_menu.on_natural_close(on_cancel);
        return confirmation_menu;
    }

    public static Menu item_selector(Context<?> context, Player player, String title, @Nullable ItemStack initial_item, boolean allow_nothing, Function2<Player, ItemStack, Menu.ClickResult> on_confirm, Consumer1<Player> on_cancel) {
        return MenuFactory.item_selector(context, player, title, initial_item, allow_nothing, on_confirm, on_cancel, i -> i);
    }

    public static Menu item_selector(Context<?> context, Player player, String title, @Nullable ItemStack initial_item, boolean allow_nothing, Function2<Player, ItemStack, Menu.ClickResult> on_confirm, Consumer1<Player> on_cancel, Function1<ItemStack, ItemStack> on_select_item) {
        MenuManager menu_manager = ((Module)context.get_module()).core.menu_manager;
        final Function1<ItemStack, ItemStack> set_item_name = item -> ItemUtil.name_item(item, menu_manager.item_selector_selected.lang_name.format(new Object[0]), menu_manager.item_selector_selected.lang_lore.format(new Object[0]));
        ItemStack no_item = set_item_name.apply(new ItemStack(Material.BARRIER));
        ItemStack default_item = initial_item == null || initial_item.getType() == Material.AIR ? no_item : initial_item;
        int columns = 9;
        Menu item_selector_menu = new Menu(context, Bukkit.createInventory(null, (int)9, (Component)LegacyComponentSerializer.legacySection().deserialize(title)));
        var selected_item = new MenuItem(4, default_item, (p, menu, self, event) -> {
            if (!Menu.is_left_or_right_click(event)) {
                return Menu.ClickResult.INVALID_CLICK;
            }
            if (allow_nothing && event.getClick() == ClickType.RIGHT) {
                self.update_item((Menu)menu, no_item);
            } else {
                self.update_item((Menu)menu, default_item);
            }
            return Menu.ClickResult.SUCCESS;
        }){
            public ItemStack original_selected;
            {
                super(slot, item, on_click);
                this.original_selected = null;
            }

            @Override
            public void item(ItemStack item) {
                this.original_selected = item;
                super.item((ItemStack)set_item_name.apply(item.clone()));
            }
        };
        selected_item.item(default_item);
        item_selector_menu.add(selected_item);
        item_selector_menu.add(new MenuItemClickListener(-1, (p, menu, item) -> {
            if (item == null) {
                return Menu.ClickResult.IGNORE;
            }
            if ((item = (ItemStack)on_select_item.apply(item.clone())) == null) {
                return Menu.ClickResult.ERROR;
            }
            selected_item.item((ItemStack)item);
            menu.update();
            return Menu.ClickResult.SUCCESS;
        }));
        item_selector_menu.add(new MenuItem(2, menu_manager.item_selector_accept.item(new Object[0]), (p, menu, self) -> {
            ItemStack item;
            if (selected_item.original_selected == no_item) {
                if (!allow_nothing) return Menu.ClickResult.ERROR;
                item = null;
            } else {
                item = selected_item.original_selected;
            }
            menu.close((Player)p);
            return (Menu.ClickResult)((Object)((Object)on_confirm.apply((Player)p, item)));
        }));
        item_selector_menu.add(new MenuItem(6, menu_manager.item_selector_cancel.item(new Object[0]), (p, menu, self) -> {
            menu.close((Player)p);
            on_cancel.apply(player);
            return Menu.ClickResult.SUCCESS;
        }));
        item_selector_menu.on_natural_close(on_cancel);
        return item_selector_menu;
    }

    public static <T, F extends Filter<T>> Menu generic_selector(Context<?> context, Player player, String title, String filter_title, List<T> things, Function1<T, ItemStack> to_item, F filter, Function3<Player, Menu, T, Menu.ClickResult> on_click, Consumer1<Player> on_cancel) {
        return MenuFactory.generic_selector(context, player, title, filter_title, things, to_item, filter, (Player p, Menu menu, T t, InventoryClickEvent event) -> {
            if (!Menu.is_left_click(event)) {
                return Menu.ClickResult.INVALID_CLICK;
            }
            return (Menu.ClickResult)((Object)((Object)on_click.apply((Player)p, (Menu)menu, (Object)t)));
        }, on_cancel);
    }

    public static <T, F extends Filter<T>> Menu generic_selector(Context<?> context, Player player, String title, String filter_title, List<T> things, Function1<T, ItemStack> to_item, F filter, Function4<Player, Menu, T, InventoryClickEvent, Menu.ClickResult> on_click, Consumer1<Player> on_cancel) {
        return GenericSelector.create(context, player, title, filter_title, things, to_item, filter, on_click, on_cancel);
    }

    public static Menu head_selector(Context<?> context, Player player, Function3<Player, Menu, HeadMaterial, Menu.ClickResult> on_click, Consumer1<Player> on_cancel) {
        return MenuFactory.head_selector(context, player, (Player p, Menu menu, HeadMaterial t, InventoryClickEvent event) -> {
            if (!Menu.is_left_click(event)) {
                return Menu.ClickResult.INVALID_CLICK;
            }
            return (Menu.ClickResult)((Object)((Object)on_click.apply((Player)p, (Menu)menu, (HeadMaterial)t)));
        }, on_cancel);
    }

    public static Menu head_selector(Context<?> context, Player player, Function4<Player, Menu, HeadMaterial, InventoryClickEvent, Menu.ClickResult> on_click, Consumer1<Player> on_cancel) {
        MenuManager menu_manager = ((Module)context.get_module()).core.menu_manager;
        List all_heads = HeadMaterialLibrary.all().stream().sorted((a, b) -> a.key().toString().compareToIgnoreCase(b.key().toString())).collect(Collectors.toList());
        HeadFilter filter = new HeadFilter();
        return MenuFactory.generic_selector(context, player, menu_manager.head_selector.lang_title.str("\u00a75\u00a7l" + all_heads.size()), menu_manager.head_selector.lang_filter_title.str(new Object[0]), all_heads, (T h) -> menu_manager.head_selector.item_select_head.alternative(h.item(), "\u00a7a\u00a7l" + h.name(), "\u00a76" + h.category(), "\u00a7b" + String.valueOf(h.tags())), filter, on_click, on_cancel);
    }
}

