/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.menu;

import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.oddlama.vane.core.functional.Function3;
import org.oddlama.vane.core.functional.Function4;
import org.oddlama.vane.core.menu.Menu;
import org.oddlama.vane.core.menu.MenuWidget;

public class MenuItem
implements MenuWidget {
    private int slot;
    private Function4<Player, Menu, MenuItem, InventoryClickEvent, Menu.ClickResult> on_click;
    private ItemStack item;
    private boolean auto_update;

    public MenuItem(int slot, ItemStack item) {
        this(slot, item, (Function4<Player, Menu, MenuItem, InventoryClickEvent, Menu.ClickResult>)null);
    }

    public MenuItem(int slot, ItemStack item, Function3<Player, Menu, MenuItem, Menu.ClickResult> on_click) {
        this(slot, item, (Player player, Menu menu, MenuItem self, InventoryClickEvent event) -> {
            if (!Menu.is_left_click(event)) {
                return Menu.ClickResult.INVALID_CLICK;
            }
            return (Menu.ClickResult)((Object)((Object)on_click.apply((Player)player, (Menu)menu, (MenuItem)self)));
        });
    }

    public MenuItem(int slot, ItemStack item, Function4<Player, Menu, MenuItem, InventoryClickEvent, Menu.ClickResult> on_click) {
        this.slot = slot;
        this.on_click = on_click;
        this.auto_update = item == null;
        this.item(item);
    }

    public int slot() {
        return this.slot;
    }

    public ItemStack item(Menu menu) {
        return menu.inventory().getItem(this.slot);
    }

    public void item(ItemStack item) {
        this.item = item;
    }

    public void update_item(Menu menu, ItemStack item) {
        this.item(item);
        menu.update();
    }

    @Override
    public boolean update(Menu menu) {
        ItemStack cur;
        if (this.auto_update) {
            this.item((ItemStack)null);
        }
        if ((cur = this.item(menu)) != this.item) {
            menu.inventory().setItem(this.slot(), this.item);
            return true;
        }
        return false;
    }

    @Override
    public Menu.ClickResult click(Player player, Menu menu, ItemStack item, int slot, InventoryClickEvent event) {
        if (this.slot != slot) {
            return Menu.ClickResult.IGNORE;
        }
        if (this.on_click != null) {
            return this.on_click.apply(player, menu, this, event);
        }
        return Menu.ClickResult.IGNORE;
    }
}

