/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.menu;

import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.oddlama.vane.core.functional.Function3;
import org.oddlama.vane.core.functional.Function4;
import org.oddlama.vane.core.menu.Menu;
import org.oddlama.vane.core.menu.MenuWidget;

public class MenuItemClickListener
implements MenuWidget {
    private int slot;
    private Function4<Player, Menu, ItemStack, InventoryClickEvent, Menu.ClickResult> on_click;

    public MenuItemClickListener(int slot, Function3<Player, Menu, ItemStack, Menu.ClickResult> on_click) {
        this(slot, (Player player, Menu menu, ItemStack item, InventoryClickEvent event) -> {
            if (!Menu.is_left_click(event)) {
                return Menu.ClickResult.INVALID_CLICK;
            }
            return (Menu.ClickResult)((Object)((Object)on_click.apply((Player)player, (Menu)menu, (ItemStack)item)));
        });
    }

    public MenuItemClickListener(int slot, Function4<Player, Menu, ItemStack, InventoryClickEvent, Menu.ClickResult> on_click) {
        this.slot = slot;
        this.on_click = on_click;
    }

    public int slot() {
        return this.slot;
    }

    @Override
    public boolean update(Menu menu) {
        return false;
    }

    @Override
    public Menu.ClickResult click(Player player, Menu menu, ItemStack item, int slot, InventoryClickEvent event) {
        if (this.slot != slot) {
            return Menu.ClickResult.IGNORE;
        }
        if (this.on_click != null) {
            return this.on_click.apply(player, menu, item, event);
        }
        return Menu.ClickResult.IGNORE;
    }
}

