/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.menu;

import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.oddlama.vane.core.Core;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.config.TranslatedItemStack;
import org.oddlama.vane.core.functional.Consumer2;
import org.oddlama.vane.core.menu.HeadSelectorGroup;
import org.oddlama.vane.core.menu.Menu;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.ModuleContext;

public class MenuManager
extends Listener<Core> {
    private final HashMap<UUID, Menu> open_menus = new HashMap();
    private final HashMap<Inventory, Menu> menus = new HashMap();
    public TranslatedItemStack<?> item_selector_accept;
    public TranslatedItemStack<?> item_selector_cancel;
    public TranslatedItemStack<?> item_selector_selected;
    public TranslatedItemStack<?> generic_selector_page;
    public TranslatedItemStack<?> generic_selector_current_page;
    public TranslatedItemStack<?> generic_selector_filter;
    public TranslatedItemStack<?> generic_selector_cancel;
    public HeadSelectorGroup head_selector;

    public MenuManager(Context<Core> context) {
        super(context.namespace("menus"));
        Context<Core> ctx = this.get_context();
        this.head_selector = new HeadSelectorGroup(ctx);
        ModuleContext<Core> ctx_item_selector = ctx.namespace("item_selector", "Menu configuration for item selector menus.");
        this.item_selector_accept = new TranslatedItemStack<Core>(ctx_item_selector, "accept", Material.LIME_TERRACOTTA, 1, "Used to confirm item selection.");
        this.item_selector_cancel = new TranslatedItemStack<Core>(ctx_item_selector, "cancel", Material.RED_TERRACOTTA, 1, "Used to cancel item selection.");
        this.item_selector_selected = new TranslatedItemStack<Core>(ctx_item_selector, "selected", Material.BARRIER, 1, "Represents the selected item. Left-clicking will reset the selection to the initial value, and right-clicking will clear the selected item. The given stack is used as the 'empty', cleared item.");
        ModuleContext<Core> ctx_generic_selector = ctx.namespace("generic_selector", "Menu configuration for generic selector menus.");
        this.generic_selector_page = new TranslatedItemStack<Core>(ctx_generic_selector, "page", Material.PAPER, 1, "Used to select pages.");
        this.generic_selector_current_page = new TranslatedItemStack<Core>(ctx_generic_selector, "current_page", Material.MAP, 1, "Used to indicate current page.");
        this.generic_selector_filter = new TranslatedItemStack<Core>(ctx_generic_selector, "filter", Material.HOPPER, 1, "Used to filter items.");
        this.generic_selector_cancel = new TranslatedItemStack<Core>(ctx_generic_selector, "cancel", Material.PRISMARINE_SHARD, 1, "Used to cancel selection.");
    }

    public Menu menu_for(Player player, InventoryView view) {
        return this.menu_for(player, view.getTopInventory());
    }

    public Menu menu_for(Player player, Inventory inventory) {
        Menu menu = this.menus.get(inventory);
        Menu open = this.open_menus.get(player.getUniqueId());
        if (open != menu && menu != null) {
            ((Core)this.get_module()).log.warning("Menu inconsistency: entity " + String.valueOf(player) + " accessed a menu '" + String.valueOf(this.open_menus.get(player.getUniqueId())) + "' that isn't registered to it. The registered menu is '" + String.valueOf(menu) + "'");
            return menu;
        }
        return menu == null ? open : menu;
    }

    public void add(Player player, Menu menu) {
        this.open_menus.put(player.getUniqueId(), menu);
        this.menus.put(menu.inventory(), menu);
    }

    public void remove(Player player, Menu menu) {
        this.open_menus.remove(player.getUniqueId());
        boolean orphaned = this.open_menus.values().stream().allMatch(m -> m != menu);
        if (orphaned) {
            this.menus.remove(menu.inventory());
        }
    }

    public void for_each_open(Consumer2<Player, Menu> functor) {
        for (Player player : ((Core)this.get_module()).getServer().getOnlinePlayers()) {
            Menu open = this.open_menus.get(player.getUniqueId());
            if (open == null) continue;
            functor.apply(player, open);
        }
    }

    public void update(Menu menu) {
        ((Core)this.get_module()).getServer().getOnlinePlayers().stream().filter(p -> this.open_menus.get(p.getUniqueId()) == menu).forEach(p -> p.updateInventory());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void on_inventory_click(InventoryClickEvent event) {
        HumanEntity clicker = event.getWhoClicked();
        if (!(clicker instanceof Player)) {
            return;
        }
        Player player = (Player)clicker;
        Menu menu = this.menu_for(player, event.getView());
        if (menu != null) {
            event.setCancelled(true);
            int slot = event.getClickedInventory() == menu.inventory() ? event.getSlot() : -1;
            menu.click(player, event.getCurrentItem(), slot, event);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void on_inventory_drag(InventoryDragEvent event) {
        HumanEntity clicker = event.getWhoClicked();
        if (!(clicker instanceof Player)) {
            return;
        }
        Player player = (Player)clicker;
        Menu menu = this.menu_for(player, event.getView());
        if (menu != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on_inventory_close(InventoryCloseEvent event) {
        HumanEntity human = event.getPlayer();
        if (!(human instanceof Player)) {
            return;
        }
        Player player = (Player)human;
        Menu menu = this.menu_for(player, event.getView());
        if (menu != null) {
            menu.closed(player, event.getReason());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void on_prepare_anvil_event(PrepareAnvilEvent event) {
        Menu menu = this.menus.get(event.getView().getTopInventory());
        if (menu != null) {
            event.getView().setRepairCost(0);
        }
    }
}

