/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.misc;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.oddlama.vane.annotation.persistent.Persistent;
import org.oddlama.vane.core.Core;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.util.Resolve;

public class AuthMultiplexer
extends Listener<Core>
implements PluginMessageListener {
    public static final String CHANNEL_AUTH_MULTIPLEX = "vane_proxy:auth_multiplex";
    @Persistent
    public Map<UUID, UUID> storage_auth_multiplex = new HashMap<UUID, UUID>();
    @Persistent
    public Map<UUID, Integer> storage_auth_multiplexer_id = new HashMap<UUID, Integer>();

    public AuthMultiplexer(Context<Core> context) {
        super(context);
    }

    @Override
    protected void on_enable() {
        super.on_enable();
        ((Core)this.get_module()).getServer().getMessenger().registerIncomingPluginChannel(this.get_module(), CHANNEL_AUTH_MULTIPLEX, (PluginMessageListener)this);
    }

    @Override
    protected void on_disable() {
        super.on_disable();
        ((Core)this.get_module()).getServer().getMessenger().unregisterIncomingPluginChannel(this.get_module(), CHANNEL_AUTH_MULTIPLEX, (PluginMessageListener)this);
    }

    public synchronized String auth_multiplex_player_name(UUID uuid) {
        UUID original_player_id = this.storage_auth_multiplex.get(uuid);
        Integer multiplexer_id = this.storage_auth_multiplexer_id.get(uuid);
        if (original_player_id == null || multiplexer_id == null) {
            return null;
        }
        OfflinePlayer original_player = ((Core)this.get_module()).getServer().getOfflinePlayer(original_player_id);
        return "\u00a77[" + multiplexer_id + "]\u00a7r " + original_player.getName();
    }

    private void try_init_multiplexed_player_name(Player player) {
        Resolve.Skin skin;
        UUID id = player.getUniqueId();
        String display_name = this.auth_multiplex_player_name(id);
        if (display_name == null) {
            return;
        }
        ((Core)this.get_module()).log.info("[multiplex] Init player '" + display_name + "' for registered auth multiplexed player {" + String.valueOf(id) + ", " + player.getName() + "}");
        TextComponent display_name_component = LegacyComponentSerializer.legacySection().deserialize(display_name);
        player.displayName((Component)display_name_component);
        player.playerListName((Component)display_name_component);
        UUID original_player_id = this.storage_auth_multiplex.get(id);
        try {
            skin = Resolve.resolve_skin(original_player_id);
        }
        catch (IOException | URISyntaxException e) {
            Bukkit.getLogger().log(Level.WARNING, "Failed to resolve skin for uuid '" + String.valueOf(id) + "'", e);
            return;
        }
        PlayerProfile profile = player.getPlayerProfile();
        profile.setProperty(new ProfileProperty("textures", skin.texture, skin.signature));
        player.setPlayerProfile(profile);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=false)
    public void on_player_join(PlayerJoinEvent event) {
        this.try_init_multiplexed_player_name(event.getPlayer());
    }

    public synchronized void onPluginMessageReceived(String channel, Player player, byte[] bytes) {
        if (!channel.equals(CHANNEL_AUTH_MULTIPLEX)) {
            return;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        DataInputStream in = new DataInputStream(stream);
        try {
            int multiplexer_id = in.readInt();
            UUID old_uuid = UUID.fromString(in.readUTF());
            String old_name = in.readUTF();
            UUID new_uuid = UUID.fromString(in.readUTF());
            String new_name = in.readUTF();
            ((Core)this.get_module()).log.info("[multiplex] Registered auth multiplexed player {" + String.valueOf(new_uuid) + ", " + new_name + "} from player {" + String.valueOf(old_uuid) + ", " + old_name + "} multiplexer_id " + multiplexer_id);
            this.storage_auth_multiplex.put(new_uuid, old_uuid);
            this.storage_auth_multiplexer_id.put(new_uuid, multiplexer_id);
            this.mark_persistent_storage_dirty();
            OfflinePlayer multiplexed_player = ((Core)this.get_module()).getServer().getOfflinePlayer(new_uuid);
            if (multiplexed_player.isOnline()) {
                this.try_init_multiplexed_player_name(multiplexed_player.getPlayer());
            }
        }
        catch (IOException e) {
            ((Core)this.get_module()).log.log(Level.SEVERE, "Failed to process auth multiplex message", e);
        }
    }
}

