/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.misc;

import java.util.Map;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.oddlama.vane.core.Core;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.module.Context;

public class CommandHider
extends Listener<Core> {
    public CommandHider(Context<Core> context) {
        super(context.group("hide_commands", "Hide error messages for all commands for which a player has no permission, by displaying the default unknown command message instead."));
    }

    private boolean allow_command_event(String message, Player player) {
        Map command_map;
        Command command;
        if (!(message = message.trim()).startsWith("/")) {
            return false;
        }
        String id = message.substring(1);
        int space_index = id.indexOf(32);
        if (space_index > -1) {
            id = id.substring(0, space_index);
        }
        if ((command = (Command)(command_map = ((Core)this.get_module()).getServer().getCommandMap().getKnownCommands()).get(id)) != null) {
            return command.testPermissionSilent((CommandSender)player);
        }
        return true;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void on_player_command_preprocess(PlayerCommandPreprocessEvent event) {
        if (!this.allow_command_event(event.getMessage(), event.getPlayer())) {
            String msg = "Unknown command. Type \"/help\" for help.";
            event.getPlayer().sendMessage("Unknown command. Type \"/help\" for help.");
            event.setCancelled(true);
        }
    }
}

