/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.misc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Skull;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.oddlama.vane.annotation.config.ConfigBoolean;
import org.oddlama.vane.core.Core;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.material.HeadMaterial;
import org.oddlama.vane.core.material.HeadMaterialLibrary;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.util.BlockUtil;

public class HeadLibrary
extends Listener<Core> {
    @ConfigBoolean(def=true, desc="When a player head is broken by a player that exists in /heads, drop the correctly named item as seen in /heads. You can disable this if it interferes with similarly textured heads from other plugins.")
    public boolean config_player_head_drops;

    public HeadLibrary(Context<Core> context) {
        super(context);
        ((Core)this.get_module()).log.info("Loading head library...");
        try {
            String json;
            block14: {
                json = null;
                try (InputStream input = ((Core)this.get_module()).getResource("head_library.json");){
                    if (input == null) break block14;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
                        json = reader.lines().collect(Collectors.joining("\n"));
                    }
                }
            }
            if (json == null) {
                throw new IOException("Failed to get contents of resource head_library.json");
            }
            HeadMaterialLibrary.load(json);
        }
        catch (IOException e) {
            ((Core)this.get_module()).log.log(Level.SEVERE, "Error while loading head_library.json! Shutting down.", e);
            ((Core)this.get_module()).getServer().shutdown();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on_block_break(BlockBreakEvent event) {
        if (!this.config_player_head_drops) {
            return;
        }
        Block block = event.getBlock();
        if (block.getType() != Material.PLAYER_HEAD && block.getType() != Material.PLAYER_WALL_HEAD) {
            return;
        }
        Skull skull = (Skull)block.getState();
        String texture = BlockUtil.texture_from_skull(skull);
        if (texture == null) {
            return;
        }
        HeadMaterial head_material = HeadMaterialLibrary.from_texture(texture);
        if (head_material == null) {
            return;
        }
        block.setType(Material.AIR);
        BlockUtil.drop_naturally(block, head_material.item());
    }
}

