/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.misc;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.loot.Lootable;
import org.oddlama.vane.annotation.config.ConfigBoolean;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.core.Core;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.module.Context;

public class LootChestProtector
extends Listener<Core> {
    private final Map<Block, Map<UUID, Long>> loot_break_attempts = new HashMap<Block, Map<UUID, Long>>();
    @ConfigBoolean(def=true, desc="Prevent players from breaking blocks with loot-tables (like treasure chests) when they first attempt to destroy it. They still can break it, but must do so within a short timeframe.")
    public boolean config_warn_breaking_loot_blocks;
    @LangMessage
    public TranslatedMessage lang_break_loot_block_prevented;

    public LootChestProtector(Context<Core> context) {
        super(context);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void on_break_loot_chest(BlockBreakEvent event) {
        if (!this.config_warn_breaking_loot_blocks) {
            return;
        }
        BlockState state = event.getBlock().getState(false);
        if (!(state instanceof Lootable)) {
            return;
        }
        Lootable lootable = (Lootable)state;
        if (!lootable.hasLootTable()) {
            return;
        }
        Block block = event.getBlock();
        Player player = event.getPlayer();
        Map<UUID, Long> block_attempts = this.loot_break_attempts.get(block);
        long now = System.currentTimeMillis();
        if (block_attempts != null) {
            Long player_attempt_time = block_attempts.get(player.getUniqueId());
            if (player_attempt_time != null) {
                long elapsed = now - player_attempt_time;
                if (elapsed > 5000L && elapsed < 30000L) {
                    return;
                }
            } else {
                block_attempts.put(player.getUniqueId(), now);
            }
        } else {
            block_attempts = new HashMap<UUID, Long>();
            block_attempts.put(player.getUniqueId(), now);
            this.loot_break_attempts.put(block, block_attempts);
        }
        this.lang_break_loot_block_prevented.send((CommandSender)player, new Object[0]);
        event.setCancelled(true);
    }
}

