/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.module;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventManager;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.world.LootGenerateEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootTables;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.oddlama.vane.annotation.VaneModule;
import org.oddlama.vane.annotation.config.ConfigBoolean;
import org.oddlama.vane.annotation.config.ConfigString;
import org.oddlama.vane.annotation.config.ConfigVersion;
import org.oddlama.vane.annotation.lang.LangVersion;
import org.oddlama.vane.annotation.persistent.Persistent;
import org.oddlama.vane.core.Core;
import org.oddlama.vane.core.LootTable;
import org.oddlama.vane.core.command.Command;
import org.oddlama.vane.core.config.ConfigManager;
import org.oddlama.vane.core.functional.Consumer1;
import org.oddlama.vane.core.lang.LangManager;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.ModuleComponent;
import org.oddlama.vane.core.module.ModuleGroup;
import org.oddlama.vane.core.persistent.PersistentStorageManager;
import org.oddlama.vane.core.resourcepack.ResourcePackGenerator;
import org.oddlama.vane.external.bstats.bukkit.Metrics;
import org.oddlama.vane.util.ResourceList;

public abstract class Module<T extends Module<T>>
extends JavaPlugin
implements Context<T>,
Listener {
    public final VaneModule annotation = this.getClass().getAnnotation(VaneModule.class);
    public Core core;
    public Logger log = this.getLogger();
    public ComponentLogger clog = this.getComponentLogger();
    private final String namespace = "vane_" + this.annotation.name().replaceAll("[^a-zA-Z0-9_]", "_");
    public ConfigManager config_manager = new ConfigManager(this);
    public LangManager lang_manager = new LangManager(this);
    public PersistentStorageManager persistent_storage_manager = new PersistentStorageManager(this);
    private boolean persistent_storage_dirty = false;
    public Permission permission_command_catchall_module;
    public Random random = new Random();
    private List<String> pending_console_permissions = new ArrayList<String>();
    public PermissionAttachment console_attachment;
    @ConfigVersion
    public long config_version;
    @LangVersion
    public long lang_version;
    @Persistent
    public long storage_version;
    @ConfigString(def="inherit", desc="The language for this module. The corresponding language file must be named lang-{lang}.yml. Specifying 'inherit' will load the value set for vane-core.", metrics=true)
    public String config_lang;
    @ConfigBoolean(def=true, desc="Enable plugin metrics via bStats. You can opt-out here or via the global bStats configuration. All collected information is completely anonymous and publicly available.")
    public boolean config_metrics_enabled;
    private ModuleGroup<T> context_group = new ModuleGroup(this, "", "The module will only add functionality if this is set to true.");
    private final Map<NamespacedKey, LootTable> additional_loot_tables = new HashMap<NamespacedKey, LootTable>();
    public ProtocolManager protocol_manager;
    public Metrics metrics;

    @Override
    public void compile(ModuleComponent<T> component) {
        this.context_group.compile(component);
    }

    @Override
    public void add_child(Context<T> subcontext) {
        if (this.context_group == null) {
            return;
        }
        this.context_group.add_child(subcontext);
    }

    @Override
    public Context<T> get_context() {
        return this;
    }

    @Override
    public T get_module() {
        return (T)this;
    }

    @Override
    public String yaml_path() {
        return "";
    }

    @Override
    public String variable_yaml_path(String variable) {
        return variable;
    }

    @Override
    public boolean enabled() {
        return this.context_group.enabled();
    }

    protected void on_load() {
    }

    @Override
    public void on_enable() {
    }

    @Override
    public void on_disable() {
    }

    @Override
    public void on_config_change() {
    }

    public void on_generate_resource_pack() throws IOException {
    }

    @Override
    public final void for_each_module_component(Consumer1<ModuleComponent<?>> f) {
        this.context_group.for_each_module_component(f);
    }

    public Module() {
        this.core = this.getName().equals("vane-core") ? (Core)this : (Core)this.getServer().getPluginManager().getPlugin("vane-core");
        this.permission_command_catchall_module = new Permission("vane." + this.get_name() + ".commands.*", "Allow access to all vane-" + this.get_name() + " commands", PermissionDefault.FALSE);
        this.register_permission(this.permission_command_catchall_module);
    }

    public final String namespace() {
        return this.namespace;
    }

    public final void onLoad() {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.on_load();
    }

    public final void onEnable() {
        this.console_attachment = this.getServer().getConsoleSender().addAttachment((Plugin)this);
        for (String perm : this.pending_console_permissions) {
            this.console_attachment.setPermission(perm, true);
        }
        this.pending_console_permissions.clear();
        this.core.register_module(this);
        this.protocol_manager = ProtocolLibrary.getProtocolManager();
        this.load_persistent_storage();
        this.reload_configuration();
        this.schedule_task_timer(() -> {
            if (this.persistent_storage_dirty) {
                this.save_persistent_storage();
                this.persistent_storage_dirty = false;
            }
        }, 1200L, 1200L);
    }

    public void onDisable() {
        this.disable();
        this.save_persistent_storage();
        this.core.unregister_module(this);
    }

    @Override
    public void enable() {
        int id;
        if (this.config_metrics_enabled && (id = this.annotation.bstats()) != -1) {
            this.metrics = new Metrics((Plugin)this, id);
            this.config_manager.register_metrics(this.metrics);
        }
        this.on_enable();
        this.context_group.enable();
        this.register_listener(this);
    }

    @Override
    public void disable() {
        this.unregister_listener(this);
        this.context_group.disable();
        this.on_disable();
        this.metrics = null;
    }

    @Override
    public void config_change() {
        this.on_config_change();
        this.context_group.config_change();
    }

    @Override
    public void generate_resource_pack(ResourcePackGenerator pack) throws IOException {
        Pattern pattern = Pattern.compile("lang-.*\\.yml");
        Arrays.stream(this.getDataFolder().listFiles((d, name) -> pattern.matcher(name).matches())).sorted().forEach(lang_file -> {
            YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)lang_file);
            try {
                this.lang_manager.generate_resource_pack(pack, yaml, (File)lang_file);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while generating language for '" + String.valueOf(lang_file) + "' of module " + this.get_name(), e);
            }
        });
        InputStream index = this.getResource("resource_pack/index");
        if (index != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(index));){
                String filePath;
                while ((filePath = reader.readLine()) != null) {
                    InputStream content = this.getResource("resource_pack/" + filePath);
                    pack.add_file(filePath, content);
                }
            }
            catch (IOException e) {
                this.log.log(Level.SEVERE, "Could not load resource pack index file of module " + this.get_name(), e);
            }
        }
        this.on_generate_resource_pack(pack);
        this.context_group.generate_resource_pack(pack);
    }

    private boolean try_reload_configuration() {
        File file = this.config_manager.standard_file();
        if (!file.exists() && !this.config_manager.generate_file(file, null)) {
            return false;
        }
        return this.config_manager.reload(file);
    }

    private void update_lang_file(String lang_file) {
        File file = new File(this.getDataFolder(), lang_file);
        long file_version = YamlConfiguration.loadConfiguration((File)file).getLong("version", -1L);
        long resource_version = -1L;
        InputStream res = this.getResource(lang_file);
        try (InputStreamReader reader = new InputStreamReader(res);){
            resource_version = YamlConfiguration.loadConfiguration((Reader)reader).getLong("version", -1L);
        }
        catch (IOException e) {
            this.log.log(Level.SEVERE, "Error while updating lang file '" + String.valueOf(file) + "' of module " + this.get_name(), e);
        }
        if (resource_version > file_version) {
            try {
                Files.copy(this.getResource(lang_file), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                this.log.log(Level.SEVERE, "Error while copying lang file '" + String.valueOf(file) + "' of module " + this.get_name(), e);
            }
        }
    }

    private boolean try_reload_localization() {
        File file;
        ResourceList.get_resources(this.getClass(), Pattern.compile("lang-.*\\.yml")).stream().forEach(this::update_lang_file);
        String lang_code = this.config_lang;
        if ("inherit".equals(lang_code)) {
            lang_code = this.core.config_lang;
            if (lang_code == null) {
                lang_code = "en";
            } else if ("inherit".equals(lang_code)) {
                lang_code = "en";
            }
        }
        if (!(file = new File(this.getDataFolder(), "lang-" + lang_code + ".yml")).exists()) {
            this.log.severe("Missing language file '" + file.getName() + "' for module " + this.get_name());
            return false;
        }
        return this.lang_manager.reload(file);
    }

    public boolean reload_configuration() {
        boolean was_enabled = this.enabled();
        if (!this.try_reload_configuration()) {
            this.log.severe("Invalid plugin configuration. Shutting down.");
            this.getServer().shutdown();
            return false;
        }
        if (!this.try_reload_localization()) {
            this.log.severe("Invalid localization file. Shutting down.");
            this.getServer().shutdown();
            return false;
        }
        if (was_enabled && !this.enabled()) {
            this.disable();
        } else if (!was_enabled && this.enabled()) {
            this.enable();
        }
        this.config_change();
        return true;
    }

    public File get_persistent_storage_file() {
        return new File(this.getDataFolder(), "storage.json");
    }

    public void load_persistent_storage() {
        File file = this.get_persistent_storage_file();
        if (!this.persistent_storage_manager.load(file)) {
            this.log.severe("Invalid persistent storage. Shutting down to prevent further corruption.");
            this.getServer().shutdown();
        }
    }

    @Override
    public void mark_persistent_storage_dirty() {
        this.persistent_storage_dirty = true;
    }

    public void save_persistent_storage() {
        File file = this.get_persistent_storage_file();
        this.persistent_storage_manager.save(file);
    }

    public void register_listener(Listener listener) {
        this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
    }

    public void unregister_listener(Listener listener) {
        HandlerList.unregisterAll((Listener)listener);
    }

    public String get_name() {
        return this.annotation.name();
    }

    public void register_command(Command<?> command) {
        LifecycleEventManager manager = this.getLifecycleManager();
        manager.registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> ((Commands)event.registrar()).register(command.get_command(), command.lang_description.str(new Object[0]), command.get_aliases()));
    }

    public void unregister_command(Command<?> command) {
        Command.BukkitCommand bukkit_command = command.get_bukkit_command();
        this.getServer().getCommandMap().getKnownCommands().values().remove((Object)bukkit_command);
        bukkit_command.unregister(this.getServer().getCommandMap());
    }

    public void add_console_permission(Permission permission) {
        this.add_console_permission(permission.getName());
    }

    public void add_console_permission(String permission) {
        if (this.console_attachment == null) {
            this.pending_console_permissions.add(permission);
        } else {
            this.console_attachment.setPermission(permission, true);
        }
    }

    public void register_permission(Permission permission) {
        try {
            this.getServer().getPluginManager().addPermission(permission);
        }
        catch (IllegalArgumentException e) {
            this.log.log(Level.SEVERE, "Permission '" + permission.getName() + "' was already defined", e);
        }
    }

    public void unregister_permission(Permission permission) {
        this.getServer().getPluginManager().removePermission(permission);
    }

    public LootTable loot_table(LootTables table) {
        return this.loot_table(table.getKey());
    }

    public List<OfflinePlayer> get_offline_players_with_valid_name() {
        return Arrays.stream(this.getServer().getOfflinePlayers()).filter(k -> k.getName() != null).collect(Collectors.toList());
    }

    public LootTable loot_table(NamespacedKey key) {
        LootTable additional_loot_table = this.additional_loot_tables.get(key);
        if (additional_loot_table == null) {
            additional_loot_table = new LootTable();
            this.additional_loot_tables.put(key, additional_loot_table);
        }
        return additional_loot_table;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void on_module_loot_generate(LootGenerateEvent event) {
        org.bukkit.loot.LootTable loot_table = event.getLootTable();
        if (loot_table == null) {
            return;
        }
        LootTable additional_loot_table = this.additional_loot_tables.get(loot_table.getKey());
        if (additional_loot_table == null) {
            return;
        }
        Location loc = event.getLootContext().getLocation();
        Random local_random = new Random(this.random.nextInt() + (loc.getBlockX() & 0xFFFF0000) + (loc.getBlockY() & 0xFFFF) + (loc.getBlockZ() & 0xFFFF0000));
        additional_loot_table.generate_loot(event.getLoot(), local_random);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void on_module_player_caught_fish(PlayerFishEvent event) {
        if (event.getState() != PlayerFishEvent.State.CAUGHT_FISH) {
            return;
        }
        Entity entity = event.getCaught();
        if (entity instanceof Item) {
            Item item_entity = (Item)entity;
            Player player = event.getPlayer();
            FishHook hook_entity = event.getHook();
            double player_luck = player.getAttribute(Attribute.LUCK).getValue();
            ItemStack rod_stack = player.getInventory().getItem(event.getHand());
            double rod_luck = rod_stack.getEnchantmentLevel(Enchantment.LUCK_OF_THE_SEA);
            double total_luck = player_luck + rod_luck;
            double weight_fish = Math.max(0.0, 85.0 + total_luck * -1.0);
            double weight_junk = Math.max(0.0, 10.0 + total_luck * -2.0);
            double weight_treasure = hook_entity.isInOpenWater() ? Math.max(0.0, 5.0 + total_luck * 2.0) : 0.0;
            double roll = this.random.nextDouble() * (weight_fish + weight_junk + weight_treasure);
            NamespacedKey key = roll < weight_fish ? LootTables.FISHING_FISH.getKey() : (roll < weight_fish + weight_junk ? LootTables.FISHING_JUNK.getKey() : LootTables.FISHING_TREASURE.getKey());
            LootTable additional_loot_table = this.additional_loot_tables.get(key);
            if (additional_loot_table == null) {
                return;
            }
            ItemStack new_item = additional_loot_table.generate_override(new Random(this.random.nextInt()));
            if (new_item == null) {
                return;
            }
            item_entity.setItemStack(new_item);
        }
    }
}

