/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.module;

import java.io.IOException;
import java.util.function.Consumer;
import org.bukkit.NamespacedKey;
import org.bukkit.scheduler.BukkitTask;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.Module;
import org.oddlama.vane.core.resourcepack.ResourcePackGenerator;
import org.oddlama.vane.external.json.JSONObject;

public abstract class ModuleComponent<T extends Module<T>> {
    private Context<T> context = null;

    public ModuleComponent(Context<T> context) {
        if (context == null) {
            return;
        }
        this.set_context(context);
    }

    public void set_context(Context<T> context) {
        if (this.context != null) {
            throw new RuntimeException("Cannot replace existing context! This is a bug.");
        }
        this.context = context;
        context.compile(this);
    }

    public Context<T> get_context() {
        return this.context;
    }

    public T get_module() {
        return this.context.get_module();
    }

    public boolean enabled() {
        return this.context.enabled();
    }

    protected abstract void on_enable();

    protected abstract void on_disable();

    protected void on_config_change() {
    }

    protected void on_generate_resource_pack(ResourcePackGenerator pack) throws IOException {
    }

    public final BukkitTask schedule_task_timer(Runnable task, long delay_ticks, long period_ticks) {
        return this.context.schedule_task_timer(task, delay_ticks, period_ticks);
    }

    public final BukkitTask schedule_task(Runnable task, long delay_ticks) {
        return this.context.schedule_task(task, delay_ticks);
    }

    public final BukkitTask schedule_next_tick(Runnable task) {
        return this.context.schedule_next_tick(task);
    }

    public final void add_storage_migration_to(long to, String name, Consumer<JSONObject> migrator) {
        this.context.add_storage_migration_to(to, name, migrator);
    }

    public final String storage_path_of(String field) {
        return this.context.storage_path_of(field);
    }

    public final void mark_persistent_storage_dirty() {
        this.context.mark_persistent_storage_dirty();
    }

    public final NamespacedKey namespaced_key(String value) {
        return new NamespacedKey(this.get_module(), this.get_context().variable_yaml_path(value));
    }
}

