/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.module;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.oddlama.vane.core.functional.Consumer1;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.Module;
import org.oddlama.vane.core.module.ModuleComponent;
import org.oddlama.vane.core.resourcepack.ResourcePackGenerator;

public class ModuleContext<T extends Module<T>>
implements Context<T> {
    protected Context<T> context;
    protected T module;
    protected String name;
    private List<Context<T>> subcontexts = new ArrayList<Context<T>>();
    private List<ModuleComponent<T>> components = new ArrayList<ModuleComponent<T>>();
    private String description;
    private String separator;

    public ModuleContext(Context<T> context, String name, String description, String separator) {
        this(context, name, description, separator, true);
    }

    public ModuleContext(Context<T> context, String name, String description, String separator, boolean compile_self) {
        this.context = context;
        this.module = context.get_module();
        this.name = name;
        this.description = description;
        this.separator = separator;
        if (compile_self) {
            this.compile_self();
        }
    }

    @Override
    public String yaml_path() {
        return Context.append_yaml_path(this.context.yaml_path(), this.name, this.separator);
    }

    @Override
    public String variable_yaml_path(String variable) {
        return Context.append_yaml_path(this.yaml_path(), variable, this.separator);
    }

    @Override
    public boolean enabled() {
        return this.context.enabled();
    }

    private void compile_component(Object component) {
        ((Module)this.module).lang_manager.compile(component, this::variable_yaml_path);
        ((Module)this.module).config_manager.compile(component, this::variable_yaml_path);
        if (this.description != null) {
            ((Module)this.module).config_manager.add_section_description(this.yaml_path(), this.description);
        }
        ((Module)this.module).persistent_storage_manager.compile(component, this::variable_yaml_path);
    }

    protected void compile_self() {
        this.compile_component(this);
        this.context.add_child(this);
    }

    @Override
    public void compile(ModuleComponent<T> component) {
        this.components.add(component);
        this.compile_component(component);
    }

    @Override
    public void add_child(Context<T> subcontext) {
        this.subcontexts.add(subcontext);
    }

    @Override
    public Context<T> get_context() {
        return this.context;
    }

    @Override
    public T get_module() {
        return this.module;
    }

    @Override
    public void enable() {
        this.on_enable();
        for (ModuleComponent<T> moduleComponent : this.components) {
            moduleComponent.on_enable();
        }
        for (Context context : this.subcontexts) {
            context.enable();
        }
    }

    @Override
    public void disable() {
        int i;
        for (i = this.subcontexts.size() - 1; i >= 0; --i) {
            this.subcontexts.get(i).disable();
        }
        for (i = this.components.size() - 1; i >= 0; --i) {
            this.components.get(i).on_disable();
        }
        this.on_disable();
    }

    @Override
    public void config_change() {
        this.on_config_change();
        for (ModuleComponent<T> moduleComponent : this.components) {
            moduleComponent.on_config_change();
        }
        for (Context context : this.subcontexts) {
            context.config_change();
        }
    }

    @Override
    public void generate_resource_pack(ResourcePackGenerator pack) throws IOException {
        this.on_generate_resource_pack(pack);
        for (ModuleComponent<T> moduleComponent : this.components) {
            moduleComponent.on_generate_resource_pack(pack);
        }
        for (Context context : this.subcontexts) {
            context.generate_resource_pack(pack);
        }
    }

    @Override
    public void for_each_module_component(Consumer1<ModuleComponent<?>> f) {
        for (ModuleComponent<T> moduleComponent : this.components) {
            f.apply(moduleComponent);
        }
        for (Context context : this.subcontexts) {
            context.for_each_module_component(f);
        }
    }
}

