/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.persistent;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.function.Function;
import org.oddlama.vane.core.persistent.PersistentSerializer;
import org.oddlama.vane.external.json.JSONObject;

public class PersistentField {
    private Object owner;
    private Field field;
    private String path;

    public PersistentField(Object owner, Field field, Function<String, String> map_name) {
        this.owner = owner;
        this.field = field;
        this.path = map_name.apply(field.getName().substring("storage_".length()));
        field.setAccessible(true);
    }

    public String path() {
        return this.path;
    }

    public Object get() {
        try {
            return this.field.get(this.owner);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Invalid field access on '" + this.field.getName() + "'. This is a bug.");
        }
    }

    public void save(JSONObject json) throws IOException {
        json.put(this.path, PersistentSerializer.to_json(this.field, this.get()));
    }

    public void load(JSONObject json) throws IOException {
        if (!json.has(this.path)) {
            throw new IOException("Missing key in persistent storage: '" + this.path + "'");
        }
        try {
            this.field.set(this.owner, PersistentSerializer.from_json(this.field, json.get(this.path)));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Invalid field access on '" + this.field.getName() + "'. This is a bug.");
        }
    }
}

