/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.persistent;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.oddlama.vane.external.json.JSONArray;
import org.oddlama.vane.external.json.JSONObject;
import org.oddlama.vane.util.LazyBlock;
import org.oddlama.vane.util.LazyLocation;
import org.oddlama.vane.util.MaterialUtil;
import org.oddlama.vane.util.StorageUtil;

public class PersistentSerializer {
    public static final Map<Class<?>, Function<Object, Object>> serializers = new HashMap();
    public static final Map<Class<?>, Function<Object, Object>> deserializers = new HashMap();

    private static Object serialize_namespaced_key(@NotNull Object o) throws IOException {
        return ((NamespacedKey)o).toString();
    }

    private static NamespacedKey deserialize_namespaced_key(@NotNull Object o) throws IOException {
        String[] s = ((String)o).split(":");
        if (s.length != 2) {
            throw new IOException("Invalid namespaced key '" + String.valueOf(s) + "'");
        }
        return StorageUtil.namespaced_key(s[0], s[1]);
    }

    private static Object serialize_lazy_location(@NotNull Object o) throws IOException {
        LazyLocation lazy_location = (LazyLocation)o;
        Location location = lazy_location.location();
        JSONObject json = new JSONObject();
        json.put("world_id", PersistentSerializer.to_json(UUID.class, (Object)lazy_location.world_id()));
        json.put("x", PersistentSerializer.to_json(Double.TYPE, (Object)location.getX()));
        json.put("y", PersistentSerializer.to_json(Double.TYPE, (Object)location.getY()));
        json.put("z", PersistentSerializer.to_json(Double.TYPE, (Object)location.getZ()));
        json.put("pitch", PersistentSerializer.to_json(Float.TYPE, (Object)Float.valueOf(location.getPitch())));
        json.put("yaw", PersistentSerializer.to_json(Float.TYPE, (Object)Float.valueOf(location.getYaw())));
        return json;
    }

    private static LazyLocation deserialize_lazy_location(@NotNull Object o) throws IOException {
        JSONObject json = (JSONObject)o;
        UUID world_id = PersistentSerializer.from_json(UUID.class, json.get("world_id"));
        Double x = PersistentSerializer.from_json(Double.TYPE, json.get("x"));
        Double y = PersistentSerializer.from_json(Double.TYPE, json.get("y"));
        Double z = PersistentSerializer.from_json(Double.TYPE, json.get("z"));
        Float pitch = PersistentSerializer.from_json(Float.TYPE, json.get("pitch"));
        Float yaw = PersistentSerializer.from_json(Float.TYPE, json.get("yaw"));
        return new LazyLocation(world_id, x, y, z, yaw.floatValue(), pitch.floatValue());
    }

    private static Object serialize_lazy_block(@NotNull Object o) throws IOException {
        LazyBlock lazy_block = (LazyBlock)o;
        JSONObject json = new JSONObject();
        json.put("world_id", PersistentSerializer.to_json(UUID.class, (Object)lazy_block.world_id()));
        json.put("x", PersistentSerializer.to_json(Integer.TYPE, (Object)lazy_block.x()));
        json.put("y", PersistentSerializer.to_json(Integer.TYPE, (Object)lazy_block.y()));
        json.put("z", PersistentSerializer.to_json(Integer.TYPE, (Object)lazy_block.z()));
        return json;
    }

    private static LazyBlock deserialize_lazy_block(@NotNull Object o) throws IOException {
        JSONObject json = (JSONObject)o;
        UUID world_id = PersistentSerializer.from_json(UUID.class, json.get("world_id"));
        Integer x = PersistentSerializer.from_json(Integer.TYPE, json.get("x"));
        Integer y = PersistentSerializer.from_json(Integer.TYPE, json.get("y"));
        Integer z = PersistentSerializer.from_json(Integer.TYPE, json.get("z"));
        return new LazyBlock(world_id, x, y, z);
    }

    private static Object serialize_material(@NotNull Object o) throws IOException {
        return PersistentSerializer.to_json(NamespacedKey.class, (Object)((Material)o).getKey());
    }

    private static Material deserialize_material(@NotNull Object o) throws IOException {
        return MaterialUtil.material_from(PersistentSerializer.from_json(NamespacedKey.class, o));
    }

    private static Object serialize_item_stack(@NotNull Object o) throws IOException {
        return new String(Base64.getEncoder().encode(((ItemStack)o).serializeAsBytes()), StandardCharsets.UTF_8);
    }

    private static ItemStack deserialize_item_stack(@NotNull Object o) throws IOException {
        return ItemStack.deserializeBytes((byte[])Base64.getDecoder().decode(((String)o).getBytes(StandardCharsets.UTF_8)));
    }

    private static boolean is_null(Object o) {
        return o == null || o == JSONObject.NULL;
    }

    public static Object to_json(Field field, Object value) throws IOException {
        return PersistentSerializer.to_json(field.getGenericType(), value);
    }

    public static Object to_json(Class<?> cls, Object value) throws IOException {
        Function<Object, Object> serializer = serializers.get(cls);
        if (serializer == null) {
            throw new IOException("Cannot serialize " + String.valueOf(cls) + ". This is a bug.");
        }
        if (PersistentSerializer.is_null(value)) {
            return JSONObject.NULL;
        }
        return serializer.apply(value);
    }

    public static Object to_json(Type type, Object value) throws IOException {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterized_type = (ParameterizedType)type;
            Type base_type = parameterized_type.getRawType();
            Type[] type_args = parameterized_type.getActualTypeArguments();
            if (base_type.equals(Map.class)) {
                Class K = (Class)type_args[0];
                Type V = type_args[1];
                JSONObject json = new JSONObject();
                for (Map.Entry e : ((Map)value).entrySet()) {
                    json.put((String)PersistentSerializer.to_json(K, e.getKey()), PersistentSerializer.to_json(V, e.getValue()));
                }
                return json;
            }
            if (base_type.equals(Set.class)) {
                Type T = type_args[0];
                JSONArray json = new JSONArray();
                for (Object t : (Set)value) {
                    json.put(PersistentSerializer.to_json(T, t));
                }
                return json;
            }
            if (base_type.equals(List.class)) {
                Type T = type_args[0];
                JSONArray json = new JSONArray();
                for (Object t : (List)value) {
                    json.put(PersistentSerializer.to_json(T, t));
                }
                return json;
            }
            throw new IOException("Cannot serialize " + String.valueOf(type) + ". This is a bug.");
        }
        return PersistentSerializer.to_json((Class)type, value);
    }

    public static Object from_json(Field field, Object value) throws IOException {
        return PersistentSerializer.from_json(field.getGenericType(), value);
    }

    public static <U> U from_json(Class<U> cls, Object value) throws IOException {
        Function<Object, Object> deserializer = deserializers.get(cls);
        if (deserializer == null) {
            throw new IOException("Cannot deserialize " + String.valueOf(cls) + ". This is a bug.");
        }
        if (PersistentSerializer.is_null(value)) {
            return null;
        }
        return (U)deserializer.apply(value);
    }

    public static Object from_json(Type type, Object json) throws IOException {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterized_type = (ParameterizedType)type;
            Type base_type = parameterized_type.getRawType();
            Type[] type_args = parameterized_type.getActualTypeArguments();
            if (base_type.equals(Map.class)) {
                Class K = (Class)type_args[0];
                Type V = type_args[1];
                HashMap value = new HashMap();
                for (String key : ((JSONObject)json).keySet()) {
                    value.put(PersistentSerializer.from_json(K, (Object)key), PersistentSerializer.from_json(V, ((JSONObject)json).get(key)));
                }
                return value;
            }
            if (base_type.equals(Set.class)) {
                Type T = type_args[0];
                HashSet<Object> value = new HashSet<Object>();
                for (Object t : (JSONArray)json) {
                    value.add(PersistentSerializer.from_json(T, t));
                }
                return value;
            }
            if (base_type.equals(List.class)) {
                Type T = type_args[0];
                ArrayList<Object> value = new ArrayList<Object>();
                for (Object t : (JSONArray)json) {
                    value.add(PersistentSerializer.from_json(T, t));
                }
                return value;
            }
            throw new IOException("Cannot deserialize " + String.valueOf(type) + ". This is a bug.");
        }
        return PersistentSerializer.from_json((Class)type, json);
    }

    static {
        serializers.put(Boolean.TYPE, String::valueOf);
        serializers.put(Character.TYPE, String::valueOf);
        serializers.put(Double.TYPE, String::valueOf);
        serializers.put(Float.TYPE, String::valueOf);
        serializers.put(Integer.TYPE, String::valueOf);
        serializers.put(Long.TYPE, String::valueOf);
        serializers.put(Boolean.class, String::valueOf);
        serializers.put(Character.class, String::valueOf);
        serializers.put(Double.class, String::valueOf);
        serializers.put(Float.class, String::valueOf);
        serializers.put(Integer.class, String::valueOf);
        serializers.put(Long.class, String::valueOf);
        deserializers.put(Boolean.TYPE, x -> Boolean.parseBoolean((String)x));
        deserializers.put(Character.TYPE, x -> Character.valueOf(((String)x).charAt(0)));
        deserializers.put(Double.TYPE, x -> Double.parseDouble((String)x));
        deserializers.put(Float.TYPE, x -> Float.valueOf(Float.parseFloat((String)x)));
        deserializers.put(Integer.TYPE, x -> Integer.parseInt((String)x));
        deserializers.put(Long.TYPE, x -> Long.parseLong((String)x));
        deserializers.put(Boolean.class, x -> Boolean.valueOf((String)x));
        deserializers.put(Character.class, x -> Character.valueOf(((String)x).charAt(0)));
        deserializers.put(Double.class, x -> Double.valueOf((String)x));
        deserializers.put(Float.class, x -> Float.valueOf((String)x));
        deserializers.put(Integer.class, x -> Integer.valueOf((String)x));
        deserializers.put(Long.class, x -> Long.valueOf((String)x));
        serializers.put(String.class, x -> x);
        deserializers.put(String.class, x -> x);
        serializers.put(UUID.class, Object::toString);
        deserializers.put(UUID.class, x -> UUID.fromString((String)x));
        serializers.put(NamespacedKey.class, PersistentSerializer::serialize_namespaced_key);
        deserializers.put(NamespacedKey.class, PersistentSerializer::deserialize_namespaced_key);
        serializers.put(LazyLocation.class, PersistentSerializer::serialize_lazy_location);
        deserializers.put(LazyLocation.class, PersistentSerializer::deserialize_lazy_location);
        serializers.put(LazyBlock.class, PersistentSerializer::serialize_lazy_block);
        deserializers.put(LazyBlock.class, PersistentSerializer::deserialize_lazy_block);
        serializers.put(Material.class, PersistentSerializer::serialize_material);
        deserializers.put(Material.class, PersistentSerializer::deserialize_material);
        serializers.put(ItemStack.class, PersistentSerializer::serialize_item_stack);
        deserializers.put(ItemStack.class, PersistentSerializer::deserialize_item_stack);
    }

    @FunctionalInterface
    public static interface Function<T1, R> {
        public R apply(T1 var1) throws IOException;
    }
}

