/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.persistent;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.oddlama.vane.annotation.persistent.Persistent;
import org.oddlama.vane.core.module.Module;
import org.oddlama.vane.core.persistent.PersistentField;
import org.oddlama.vane.external.json.JSONObject;
import org.oddlama.vane.external.reflections.ReflectionUtils;

public class PersistentStorageManager {
    private List<PersistentField> persistent_fields = new ArrayList<PersistentField>();
    private List<Migration> migrations = new ArrayList<Migration>();
    Module<?> module;
    boolean is_loaded = false;

    public PersistentStorageManager(Module<?> module) {
        this.module = module;
        this.compile(module, s -> s);
    }

    private boolean has_persistent_annotation(Field field) {
        for (Annotation a : field.getAnnotations()) {
            if (!a.annotationType().getName().startsWith("org.oddlama.vane.annotation.persistent.Persistent")) continue;
            return true;
        }
        return false;
    }

    private void assert_field_prefix(Field field) {
        if (!field.getName().startsWith("storage_")) {
            throw new RuntimeException("Configuration fields must be prefixed storage_. This is a bug.");
        }
    }

    private PersistentField compile_field(Object owner, Field field, Function<String, String> map_name) {
        this.assert_field_prefix(field);
        Annotation annotation = null;
        for (Annotation a : field.getAnnotations()) {
            if (!a.annotationType().getName().startsWith("org.oddlama.vane.annotation.persistent.Persistent")) continue;
            if (annotation == null) {
                annotation = a;
                continue;
            }
            throw new RuntimeException("Persistent fields must have exactly one @Persistent annotation.");
        }
        assert (annotation != null);
        Class<? extends Annotation> atype = annotation.annotationType();
        if (atype.equals(Persistent.class)) {
            return new PersistentField(owner, field, map_name);
        }
        throw new RuntimeException("Missing PersistentField handler for @" + atype.getName() + ". This is a bug.");
    }

    public void compile(Object owner, Function<String, String> map_name) {
        this.persistent_fields.addAll(ReflectionUtils.getAllFields(owner.getClass(), new Predicate[0]).stream().filter(this::has_persistent_annotation).map(f -> this.compile_field(owner, (Field)f, map_name)).toList());
    }

    public void add_migration_to(long to, String name, Consumer<JSONObject> migrator) {
        this.migrations.add(new Migration(this, to, name, migrator));
    }

    public boolean load(File file) {
        JSONObject json;
        if (!file.exists() && this.is_loaded) {
            this.module.log.severe("Cannot reload persistent storage from nonexistent file '" + file.getName() + "'");
            return false;
        }
        this.is_loaded = false;
        if (file.exists()) {
            try {
                json = new JSONObject(Files.readString(file.toPath(), StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                this.module.log.severe("error while loading persistent data from '" + file.getName() + "':");
                this.module.log.severe(e.getMessage());
                return false;
            }
        } else {
            json = new JSONObject();
        }
        String version_path = this.module.storage_path_of("storage_version");
        long version = Long.parseLong(json.optString(version_path, "0"));
        long needed_version = this.module.annotation.storage_version();
        if (version != needed_version && this.migrations.size() > 0) {
            this.module.log.info("Persistent storage is out of date.");
            this.module.log.info("\u00a7dMigrating storage from version \u00a7b" + version + " \u2192 " + needed_version + "\u00a7d:");
            this.migrations.stream().filter(m -> m.to >= version).sorted((a, b) -> Long.compare(a.to, b.to)).forEach(m -> {
                this.module.log.info("  \u2192 \u00a7b" + m.to + "\u00a7r : Applying migration '\u00a7a" + m.name + "\u00a7r'");
                m.migrator.accept(json);
            });
        }
        json.put(version_path, String.valueOf(needed_version));
        try {
            for (PersistentField f : this.persistent_fields) {
                if (version == 0L && !json.has(f.path())) continue;
                f.load(json);
            }
        }
        catch (IOException e) {
            this.module.log.log(Level.SEVERE, "error while loading persistent variables from '" + file.getName() + "'", e);
            return false;
        }
        this.is_loaded = true;
        return true;
    }

    public void save(File file) {
        if (!this.is_loaded) {
            return;
        }
        JSONObject json = new JSONObject();
        String version_path = this.module.storage_path_of("storage_version");
        json.put(version_path, String.valueOf(this.module.annotation.storage_version()));
        for (PersistentField f : this.persistent_fields) {
            try {
                f.save(json);
            }
            catch (IOException e) {
                this.module.log.log(Level.SEVERE, "error while serializing persistent data!", e);
            }
        }
        File tmp_file = new File(file.getAbsolutePath() + ".tmp");
        try {
            Files.writeString(tmp_file.toPath(), (CharSequence)json.toString(), new OpenOption[0]);
        }
        catch (IOException e) {
            this.module.log.log(Level.SEVERE, "error while saving persistent data to temporary file!", e);
            return;
        }
        try {
            Files.move(tmp_file.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            this.module.log.log(Level.SEVERE, "error while atomically replacing '" + String.valueOf(file) + "' with temporary file (very recent changes might be lost)!", e);
        }
    }

    public class Migration {
        public long to;
        public String name;
        public Consumer<JSONObject> migrator;

        public Migration(PersistentStorageManager this$0, long to, String name, Consumer<JSONObject> migrator) {
            this.to = to;
            this.name = name;
            this.migrator = migrator;
        }
    }
}

