/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.resourcepack;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.oddlama.vane.core.Core;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.module.Context;

public class PlayerMessageDelayer
extends Listener<Core> {
    private Adapter adapter;
    private final Map<UUID, List<PacketContainer>> message_queues = new HashMap<UUID, List<PacketContainer>>();
    private final Map<UUID, Long> message_queue_start_time = new HashMap<UUID, Long>();
    private static final long message_delaying_timeout = 30000L;

    public PlayerMessageDelayer(Context<Core> context) {
        super(context.group("message_delaying", "Enable delaying messages to players until their resource pack is fully loaded. This prevents display of untranslated chat messages."));
    }

    @Override
    protected void on_enable() {
        this.adapter = new Adapter();
        ((Core)this.get_module()).protocol_manager.addPacketListener((PacketListener)this.adapter);
        super.on_enable();
        this.schedule_task_timer(() -> this.check_message_delay_timeout(), 100L, 100L);
    }

    private void check_message_delay_timeout() {
        long now = System.currentTimeMillis();
        for (UUID uuid : new HashMap<UUID, Long>(this.message_queue_start_time).keySet()) {
            Long start_time = this.message_queue_start_time.get(uuid);
            if (now - start_time <= 30000L) continue;
            OfflinePlayer offline_player = ((Core)this.get_module()).getServer().getOfflinePlayer(uuid);
            if (!offline_player.isOnline()) {
                this.stop_queueing(uuid);
                continue;
            }
            Player player = offline_player.getPlayer();
            this.relay_messages_and_stop_queueing(player);
            ((Core)this.get_module()).log.warning("Force stopped delaying messages to player '" + player.getName() + "' after their client didn't report any status after 30000 ms. If this message appears again after they reconnect, it might be a configuration issue.");
            player.sendMessage("Your client failed to report that the resource pack has been applied after 30000 ms. If you encounter text formatting issues, please reconnect. If this message appears again, it might be a plugin configuration issue.");
        }
    }

    @Override
    protected void on_disable() {
        ((Core)this.get_module()).protocol_manager.removePacketListener((PacketListener)this.adapter);
        super.on_disable();
    }

    private void start_queueing(UUID uuid) {
        this.message_queues.put(uuid, new ArrayList());
        this.message_queue_start_time.put(uuid, System.currentTimeMillis());
    }

    private List<PacketContainer> stop_queueing(UUID uuid) {
        this.message_queue_start_time.remove(uuid);
        return this.message_queues.remove(uuid);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on_player_pre_login(AsyncPlayerPreLoginEvent event) {
        if (event.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
            return;
        }
        this.start_queueing(event.getUniqueId());
    }

    private void relay_messages_and_stop_queueing(Player player) {
        List<PacketContainer> queue = this.stop_queueing(player.getUniqueId());
        if (queue == null) {
            return;
        }
        for (PacketContainer packet : queue) {
            ((Core)this.get_module()).protocol_manager.sendServerPacket(player, packet);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on_player_kick(PlayerKickEvent event) {
        this.stop_queueing(event.getPlayer().getUniqueId());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on_player_quit(PlayerQuitEvent event) {
        this.stop_queueing(event.getPlayer().getUniqueId());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void on_player_status(PlayerResourcePackStatusEvent event) {
        switch (event.getStatus()) {
            case ACCEPTED: 
            case DOWNLOADED: {
                return;
            }
        }
        Player player = event.getPlayer();
        this.relay_messages_and_stop_queueing(player);
        switch (event.getStatus()) {
            case DECLINED: {
                ((Core)this.get_module()).log.info("The player " + player.getName() + " rejected the resource pack. This will cause client-side issues with formatted text for them.");
                player.sendMessage("You have rejected the resource pack. This will cause major issues with formatted text and custom items.");
                break;
            }
            case FAILED_DOWNLOAD: {
                ((Core)this.get_module()).log.info("The resource pack download for player " + player.getName() + " failed. This will cause client-side issues with formatted text for them.");
                player.sendMessage("Your resource pack download failed. Please reconnect to retry, otherwise this will cause major issues with formatted text and custom items.");
                break;
            }
        }
    }

    public class Adapter
    extends PacketAdapter {
        public Adapter() {
            super(PlayerMessageDelayer.this.get_module(), ListenerPriority.HIGHEST, new PacketType[]{PacketType.Play.Server.SYSTEM_CHAT});
        }

        public void onPacketSending(PacketEvent event) {
            if (event.getPacketType() != PacketType.Play.Server.SYSTEM_CHAT) {
                return;
            }
            List<PacketContainer> queue = PlayerMessageDelayer.this.message_queues.get(event.getPlayer().getUniqueId());
            if (queue == null) {
                return;
            }
            queue.add(event.getPacket());
            event.setCancelled(true);
        }
    }
}

