/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.resourcepack;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.UUID;
import net.kyori.adventure.resource.ResourcePackInfo;
import net.kyori.adventure.resource.ResourcePackInfoLike;
import net.kyori.adventure.resource.ResourcePackRequest;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.oddlama.vane.annotation.config.ConfigBoolean;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.core.Core;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.ModuleGroup;
import org.oddlama.vane.core.resourcepack.CustomResourcePackConfig;
import org.oddlama.vane.core.resourcepack.PlayerMessageDelayer;
import org.oddlama.vane.core.resourcepack.ResourcePackDevServer;
import org.oddlama.vane.core.resourcepack.ResourcePackFileWatcher;
import org.oddlama.vane.util.Nms;

public class ResourcePackDistributor
extends Listener<Core> {
    private static final boolean localDev = Nms.server_handle().options.hasArgument("add-plugin") && Boolean.getBoolean("disable.watchdog");
    @ConfigBoolean(def=true, desc="Kick players if they deny to use the specified resource pack (if set). Individual players can be exempt from this rule by giving them the permission 'vane.core.resource_pack.bypass'.")
    public boolean config_force;
    @LangMessage
    public TranslatedMessage lang_declined;
    @LangMessage
    public TranslatedMessage lang_download_failed;
    public String url = null;
    public String sha1 = null;
    public UUID uuid = UUID.fromString("fbba121a-8f87-4e97-922d-2059777311bf");
    public int counter = 0;
    public final Permission bypass_permission;
    public CustomResourcePackConfig custom_resource_pack_config = new CustomResourcePackConfig(this.get_context());
    public PlayerMessageDelayer player_message_delayer = new PlayerMessageDelayer(this.get_context());
    private ResourcePackFileWatcher file_watcher;
    private ResourcePackDevServer dev_server;

    public ResourcePackDistributor(Context<Core> context) {
        super(context.group("resource_pack", "Enable resource pack distribution."));
        this.bypass_permission = new Permission("vane." + ((Core)this.get_module()).get_name() + ".resource_pack.bypass", "Allows bypassing an enforced resource pack", PermissionDefault.FALSE);
        ((Core)this.get_module()).register_permission(this.bypass_permission);
    }

    @Override
    public void on_enable() {
        if (localDev) {
            try {
                File pack_output = new File("vane-resource-pack.zip");
                if (!pack_output.exists()) {
                    ((Core)this.get_module()).log.info("Resource Pack Missing, first run? Generating resource pack.");
                    pack_output = ((Core)this.get_module()).generate_resource_pack();
                }
                this.file_watcher = new ResourcePackFileWatcher(this, pack_output);
                this.dev_server = new ResourcePackDevServer(this, pack_output);
                this.dev_server.serve();
                this.file_watcher.watch_for_changes();
            }
            catch (IOException | InterruptedException ignored) {
                ignored.printStackTrace();
            }
            ((Core)this.get_module()).log.info("Setting up dev lazy server");
        } else if (((ModuleGroup)this.custom_resource_pack_config.get_context()).config_enabled) {
            ((Core)this.get_module()).log.info("Serving custom resource pack");
            this.url = this.custom_resource_pack_config.config_url;
            this.sha1 = this.custom_resource_pack_config.config_sha1;
            this.uuid = UUID.fromString(this.custom_resource_pack_config.config_uuid);
        } else {
            ((Core)this.get_module()).log.info("Serving official vane resource pack");
            try {
                Properties properties = new Properties();
                properties.load(Core.class.getResourceAsStream("/vane-core.properties"));
                this.url = properties.getProperty("resource_pack_url");
                this.sha1 = properties.getProperty("resource_pack_sha1");
                this.uuid = UUID.fromString(properties.getProperty("resource_pack_uuid"));
            }
            catch (IOException e) {
                ((Core)this.get_module()).log.severe("Could not load official resource pack sha1 from included properties file");
                this.url = "";
                this.sha1 = "";
                this.uuid = UUID.randomUUID();
            }
        }
        if (this.sha1.length() != 40) {
            ((Core)this.get_module()).log.warning("Invalid resource pack SHA-1 sum '" + this.sha1 + "', should be 40 characters long but has " + this.sha1.length() + " characters");
            ((Core)this.get_module()).log.warning("Disabling resource pack serving and message delaying");
            this.url = "";
            ((ModuleGroup)this.player_message_delayer.get_context()).config_enabled = false;
        }
        super.on_enable();
        this.sha1 = this.sha1.toLowerCase();
        if (!this.url.isEmpty()) {
            Nms.server_handle().settings.getProperties().serverResourcePackInfo.ifPresent(rp_info -> {
                if (!rp_info.url().trim().isEmpty()) {
                    ((Core)this.get_module()).log.warning("You have manually configured a resource pack in your server.properties. This cannot be used together with vane, as servers only allow serving a single resource pack.");
                }
            });
            ((Core)this.get_module()).log.info("Distributing resource pack from '" + this.url + "' with sha1 " + this.sha1);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on_player_join(PlayerJoinEvent event) {
        if (this.url.isEmpty()) {
            return;
        }
        this.send_resource_pack(event.getPlayer());
    }

    public void send_resource_pack(Player player) {
        Object url2 = this.url;
        if (localDev) {
            url2 = this.url + "?" + this.counter;
            player.sendMessage((String)url2 + " " + this.sha1);
        }
        try {
            ResourcePackInfo info = ResourcePackInfo.resourcePackInfo((UUID)this.uuid, (URI)new URI((String)url2), (String)this.sha1);
            player.sendResourcePacks(ResourcePackRequest.resourcePackRequest().packs((ResourcePackInfoLike)info, new ResourcePackInfoLike[0]).asResourcePackRequest());
        }
        catch (URISyntaxException e) {
            ((Core)this.get_module()).log.warning("The provided resource pack URL is incorrect: " + (String)url2);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=false)
    public void on_player_status(PlayerResourcePackStatusEvent event) {
        if (!this.config_force || event.getPlayer().hasPermission(this.bypass_permission)) {
            return;
        }
        switch (event.getStatus()) {
            case DECLINED: {
                event.getPlayer().kick(this.lang_declined.str_component(new Object[0]));
                break;
            }
            case FAILED_DOWNLOAD: {
                event.getPlayer().kick(this.lang_download_failed.str_component(new Object[0]));
                break;
            }
        }
    }

    public void update_sha1(File file) {
        if (!localDev) {
            return;
        }
        try {
            HashCode hash = Files.asByteSource((File)file).hash(Hashing.sha1());
            this.sha1 = hash.toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

