/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.resourcepack;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.oddlama.vane.core.Core;
import org.oddlama.vane.core.resourcepack.ResourcePackDistributor;

public class ResourcePackFileWatcher {
    private final ResourcePackDistributor resource_pack_distributor;
    private final File file;

    public ResourcePackFileWatcher(ResourcePackDistributor resource_pack_distributor, File file) throws IOException, InterruptedException {
        this.resource_pack_distributor = resource_pack_distributor;
        this.file = file;
    }

    public void watch_for_changes() throws IOException {
        WatchService eyes = FileSystems.getDefault().newWatchService();
        PathMatcher lang_file_match = FileSystems.getDefault().getPathMatcher("glob:**/lang-*.yml");
        this.register_directories(Paths.get("plugins", new String[0]), eyes, this::is_vane_module_folder);
        this.watch_async(eyes, lang_file_match, this::update_and_send_resource_pack).runTaskAsynchronously(this.resource_pack_distributor.get_module());
    }

    private void update_and_send_resource_pack() {
        ++this.resource_pack_distributor.counter;
        ((Core)this.resource_pack_distributor.get_module()).generate_resource_pack();
        this.resource_pack_distributor.update_sha1(this.file);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.resource_pack_distributor.send_resource_pack(player);
        }
    }

    private boolean is_vane_module_folder(Path p) {
        return p.getFileName().toString().startsWith("vane-");
    }

    @NotNull
    private BukkitRunnable watch_async(final WatchService eyes, final PathMatcher match_lang, final Runnable on_hit) {
        return new BukkitRunnable(){

            public void run() {
                WatchKey key;
                boolean valid;
                boolean should_schedule = false;
                TrackRunned runner = null;
                do {
                    try {
                        key = eyes.take();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    for (WatchEvent<?> event : key.pollEvents()) {
                        Path filename;
                        if (event.kind() == StandardWatchEventKinds.OVERFLOW) continue;
                        WatchEvent<?> ev = event;
                        Path dir = (Path)key.watchable();
                        if (!match_lang.matches(dir.resolve(filename = (Path)ev.context()))) continue;
                        should_schedule = true;
                    }
                    if (!should_schedule) continue;
                    if (runner != null && !runner.has_started) {
                        runner.cancel();
                    }
                    runner = new TrackRunned(on_hit);
                    runner.runTaskLater((Plugin)((Core)ResourcePackFileWatcher.this.resource_pack_distributor.get_module()).core, 20L);
                    should_schedule = false;
                } while (valid = key.reset());
            }
        };
    }

    private void register_directories(Path root, WatchService watcher, Predicate<Path> path_match) throws IOException {
        Iterator interesting_paths = Files.walk(root, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path_match).iterator();
        while (interesting_paths.hasNext()) {
            Path p = (Path)interesting_paths.next();
            p.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        }
    }

    private static class TrackRunned
    extends BukkitRunnable {
        final Runnable r;
        boolean has_run = false;
        boolean has_started = false;

        public TrackRunned(Runnable r) {
            this.r = r;
        }

        public void run() {
            this.has_started = true;
            this.r.run();
            this.has_run = true;
        }
    }
}

