/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.resourcepack;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.oddlama.vane.external.json.JSONObject;

public class ResourcePackGenerator {
    private Map<String, Map<String, JSONObject>> translations = new HashMap<String, Map<String, JSONObject>>();
    private Map<String, byte[]> files = new HashMap<String, byte[]>();

    public JSONObject translations(String namespace, String lang_code) {
        Map ns = this.translations.computeIfAbsent(namespace, k -> new HashMap());
        JSONObject lang_map = (JSONObject)ns.get(lang_code);
        if (lang_map == null) {
            lang_map = new JSONObject();
            ns.put(lang_code, lang_map);
        }
        return lang_map;
    }

    private void write_translations(ZipOutputStream zip) throws IOException {
        for (Map.Entry<String, Map<String, JSONObject>> t : this.translations.entrySet()) {
            String namespace = t.getKey();
            for (Map.Entry<String, JSONObject> ns : t.getValue().entrySet()) {
                String lang_code = ns.getKey();
                JSONObject lang_map = ns.getValue();
                zip.putNextEntry(new ZipEntry("assets/" + namespace + "/lang/" + lang_code + ".json"));
                zip.write(lang_map.toString().getBytes(StandardCharsets.UTF_8));
                zip.closeEntry();
            }
        }
    }

    public void add_file(String path, InputStream stream) throws IOException {
        this.files.put(path, stream.readAllBytes());
    }

    public void write(File file) throws IOException {
        try (ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(file));){
            this.write_translations(zip);
            for (Map.Entry<String, byte[]> f : this.files.entrySet()) {
                String path = f.getKey();
                byte[] content = f.getValue();
                zip.putNextEntry(new ZipEntry(path));
                zip.write(content);
                zip.closeEntry();
            }
        }
    }
}

