/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.util;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Skull;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.BlockVector;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.oddlama.vane.util.MaterialUtil;

public class BlockUtil {
    public static final List<BlockFace> BLOCK_FACES = Arrays.asList(BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN);
    public static final List<BlockFace> XZ_FACES = Arrays.asList(BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST);
    public static final int NEAREST_RELATIVE_BLOCKS_FOR_RADIUS_MAX = 6;
    public static final List<List<BlockVector>> NEAREST_RELATIVE_BLOCKS_FOR_RADIUS = new ArrayList<List<BlockVector>>();

    public static boolean equals_pos(org.bukkit.block.Block b1, org.bukkit.block.Block b2) {
        return b1.getX() == b2.getX() && b1.getY() == b2.getY() && b1.getZ() == b2.getZ();
    }

    public static void drop_naturally(org.bukkit.block.Block block, ItemStack drop) {
        BlockUtil.drop_naturally(block.getLocation().add(0.5, 0.5, 0.5), drop);
    }

    public static void drop_naturally(Location loc, ItemStack drop) {
        loc.getWorld().dropItem(loc.add(Vector.getRandom().subtract(new Vector(0.5, 0.5, 0.5)).multiply(0.5)), drop).setVelocity(Vector.getRandom().add(new Vector(-0.5, 0.5, -0.5)).normalize().multiply(0.15));
    }

    public static List<BlockVector> nearest_blocks_for_radius(int radius) {
        ArrayList<BlockVector> ret = new ArrayList<BlockVector>();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if ((double)(x * x + z * z) > (double)(radius * radius) + 0.5) continue;
                ret.add(new BlockVector(x, 0, z));
            }
        }
        Collections.sort(ret, new BlockVectorRadiusComparator());
        return ret;
    }

    @NotNull
    public static org.bukkit.block.Block relative(@NotNull org.bukkit.block.Block block, @NotNull Vector relative) {
        return block.getRelative(relative.getBlockX(), relative.getBlockY(), relative.getBlockZ());
    }

    public static org.bukkit.block.Block next_tillable_block(org.bukkit.block.Block root_block, int radius, boolean careless) {
        for (BlockVector relative_pos : NEAREST_RELATIVE_BLOCKS_FOR_RADIUS.get(radius)) {
            org.bukkit.block.Block block = BlockUtil.relative(root_block, (Vector)relative_pos);
            if (!MaterialUtil.is_tillable(block.getType())) continue;
            org.bukkit.block.Block above = block.getRelative(0, 1, 0);
            if (above.getType() == Material.AIR) {
                return block;
            }
            if (!careless || !MaterialUtil.is_replaceable_grass(above.getType())) continue;
            above.setType(Material.AIR);
            return block;
        }
        return null;
    }

    public static org.bukkit.block.Block[] adjacent_blocks_3d(org.bukkit.block.Block root) {
        org.bukkit.block.Block[] adjacent = new org.bukkit.block.Block[]{root.getRelative(1, 0, 0), root.getRelative(-1, 0, 0), root.getRelative(0, 0, 1), root.getRelative(0, 0, -1), root.getRelative(0, 1, 0), root.getRelative(0, -1, 0), root.getRelative(0, -1, -1), root.getRelative(0, -1, 1), root.getRelative(0, 1, -1), root.getRelative(0, 1, 1), root.getRelative(-1, 0, -1), root.getRelative(-1, 0, 1), root.getRelative(1, 0, -1), root.getRelative(1, 0, 1), root.getRelative(-1, -1, 0), root.getRelative(-1, 1, 0), root.getRelative(1, -1, 0), root.getRelative(1, 1, 0), root.getRelative(-1, -1, -1), root.getRelative(-1, -1, 1), root.getRelative(-1, 1, -1), root.getRelative(-1, 1, 1), root.getRelative(1, -1, -1), root.getRelative(1, -1, 1), root.getRelative(1, 1, -1), root.getRelative(1, 1, 1)};
        return adjacent;
    }

    public static org.bukkit.block.Block next_seedable_block(org.bukkit.block.Block root_block, Material farmland_type, int radius) {
        for (BlockVector relative_pos : NEAREST_RELATIVE_BLOCKS_FOR_RADIUS.get(radius)) {
            org.bukkit.block.Block block = BlockUtil.relative(root_block, (Vector)relative_pos);
            org.bukkit.block.Block below = block.getRelative(BlockFace.DOWN);
            if (below.getType() != farmland_type || block.getType() != Material.AIR) continue;
            return block;
        }
        return null;
    }

    public static void update_lever(org.bukkit.block.Block block, BlockFace face) {
        ServerLevel level = ((CraftWorld)block.getWorld()).getHandle();
        org.bukkit.block.Block connected_block = block.getRelative(face.getOppositeFace());
        BlockPos block_pos_1 = new BlockPos(block.getX(), block.getY(), block.getZ());
        BlockPos block_pos_2 = new BlockPos(connected_block.getX(), connected_block.getY(), connected_block.getZ());
        Block initiator_block = level.getBlockIfLoaded(block_pos_1);
        level.updateNeighborsAt(block_pos_1, initiator_block);
        level.updateNeighborsAt(block_pos_2, initiator_block);
    }

    public static Oct raytrace_oct(LivingEntity entity, org.bukkit.block.Block block) {
        RayTraceResult result = entity.rayTraceBlocks(10.0);
        if (block == null || result == null || !block.equals((Object)result.getHitBlock())) {
            return null;
        }
        Vector block_middle = block.getLocation().toVector().add(new Vector(0.5, 0.5, 0.5));
        Vector hit = result.getHitPosition().subtract(block_middle).subtract(result.getHitBlockFace().getDirection().multiply(0.25));
        return new Oct(hit, result.getHitBlockFace());
    }

    public static RaytraceDominantFaceResult raytrace_dominant_face(LivingEntity entity, org.bukkit.block.Block block) {
        RayTraceResult result = entity.rayTraceBlocks(10.0);
        if (block == null || result == null || !block.equals((Object)result.getHitBlock())) {
            return null;
        }
        Vector block_middle = block.getLocation().toVector().add(new Vector(0.5, 0.5, 0.5));
        Vector hit_position = result.getHitPosition();
        Vector diff = hit_position.subtract(block_middle);
        RaytraceDominantFaceResult ret = new RaytraceDominantFaceResult();
        for (BlockFace face : XZ_FACES) {
            double face_dominance = face.getModX() != 0 ? diff.getX() * (double)face.getModX() : diff.getZ() * (double)face.getModZ();
            if (!(face_dominance > ret.dominance)) continue;
            ret.face = face;
            ret.dominance = face_dominance;
        }
        return ret;
    }

    public static String texture_from_skull(Skull skull) {
        PlayerProfile profile = skull.getPlayerProfile();
        if (profile == null) {
            return null;
        }
        for (ProfileProperty property : profile.getProperties()) {
            if (!"textures".equals(property.getName())) continue;
            return property.getValue();
        }
        return null;
    }

    static {
        for (int i = 0; i <= 6; ++i) {
            NEAREST_RELATIVE_BLOCKS_FOR_RADIUS.add(BlockUtil.nearest_blocks_for_radius(i));
        }
    }

    public static class BlockVectorRadiusComparator
    implements Comparator<BlockVector> {
        @Override
        public int compare(BlockVector a, BlockVector b) {
            return a.getBlockX() * a.getBlockX() + a.getBlockY() * a.getBlockY() + a.getBlockZ() * a.getBlockZ() - (b.getBlockX() * b.getBlockX() + b.getBlockY() * b.getBlockY() + b.getBlockZ() * b.getBlockZ());
        }
    }

    public static class Oct {
        private Vector hit_pos;
        private Corner corner;
        private BlockFace face;

        public Oct(Vector hit_pos, BlockFace face) {
            this.hit_pos = hit_pos;
            this.corner = new Corner(hit_pos);
            this.face = face;
        }

        public Vector hit_pos() {
            return this.hit_pos;
        }

        public Corner corner() {
            return this.corner;
        }

        public BlockFace face() {
            return this.face;
        }
    }

    public static class RaytraceDominantFaceResult {
        public BlockFace face = null;
        public double dominance = 0.0;
    }

    public static class Corner {
        private boolean x;
        private boolean y;
        private boolean z;
        private int id;

        public Corner(Vector hit) {
            this(hit.getX() >= 0.0, hit.getY() >= 0.0, hit.getZ() >= 0.0);
        }

        public Corner(boolean x, boolean y, boolean z) {
            this.x = x;
            this.y = y;
            this.z = z;
            int mx = x ? 1 : 0;
            int my = y ? 1 : 0;
            int mz = z ? 1 : 0;
            this.id = mx << 2 | my << 1 | mz << 0;
        }

        public boolean up() {
            return this.y;
        }

        public boolean east() {
            return this.x;
        }

        public boolean south() {
            return this.z;
        }

        public Corner up(boolean up) {
            return new Corner(this.x, up, this.z);
        }

        public Corner east(boolean east) {
            return new Corner(east, this.y, this.z);
        }

        public Corner south(boolean south) {
            return new Corner(this.x, this.y, south);
        }

        public Corner rotate_to_north_reference(BlockFace rotation) {
            switch (rotation) {
                default: {
                    throw new IllegalArgumentException("rotation must be one of NORTH, EAST, SOUTH, WEST");
                }
                case NORTH: {
                    return new Corner(this.x, this.y, this.z);
                }
                case EAST: {
                    return new Corner(this.z, this.y, !this.x);
                }
                case SOUTH: {
                    return new Corner(!this.x, this.y, !this.z);
                }
                case WEST: 
            }
            return new Corner(!this.z, this.y, this.x);
        }

        public BlockFace xz_face() {
            if (this.x) {
                if (this.z) {
                    return BlockFace.SOUTH_EAST;
                }
                return BlockFace.NORTH_EAST;
            }
            if (this.z) {
                return BlockFace.SOUTH_WEST;
            }
            return BlockFace.NORTH_WEST;
        }

        public int hashCode() {
            return this.id;
        }

        public boolean equals(Object other) {
            return other instanceof Corner && ((Corner)other).id == this.id;
        }
    }
}

