/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.util;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.oddlama.vane.core.Core;
import org.oddlama.vane.core.material.ExtendedMaterial;
import org.oddlama.vane.external.apache.commons.lang3.tuple.Pair;
import org.oddlama.vane.util.Nms;

public class ItemUtil {
    private static final UUID SKULL_OWNER = UUID.fromString("00000000-0000-0000-0000-000000000000");

    public static void damage_item(Player player, ItemStack item_stack, int amount) {
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (amount <= 0) {
            return;
        }
        net.minecraft.world.item.ItemStack handle = Nms.item_handle(item_stack);
        if (handle == null) {
            return;
        }
        handle.hurtAndBreak(amount, Nms.world_handle(player.getWorld()), (LivingEntity)Nms.player_handle(player), item -> {
            player.broadcastSlotBreak(EquipmentSlot.HAND);
            item_stack.subtract();
        });
    }

    public static String name_of(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return "";
        }
        ItemMeta meta = item.getItemMeta();
        if (!meta.hasDisplayName()) {
            return "";
        }
        return PlainTextComponentSerializer.plainText().serialize(meta.displayName());
    }

    public static ItemStack name_item(ItemStack item, Component name) {
        return ItemUtil.name_item(item, name, (List<Component>)null);
    }

    public static ItemStack name_item(ItemStack item, Component name, Component lore) {
        lore = lore.decoration(TextDecoration.ITALIC, false);
        return ItemUtil.name_item(item, name, List.of(lore));
    }

    public static ItemStack set_lore(ItemStack item, List<Component> lore) {
        item.editMeta(meta -> {
            List list = lore.stream().map(x -> x.decoration(TextDecoration.ITALIC, false)).collect(Collectors.toList());
            meta.lore(list);
        });
        return item;
    }

    public static ItemStack name_item(ItemStack item, Component name, List<Component> lore) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        name = name.decoration(TextDecoration.ITALIC, false);
        meta.displayName(name);
        if (lore != null) {
            List list = lore.stream().map(x -> x.decoration(TextDecoration.ITALIC, false)).collect(Collectors.toList());
            meta.lore(list);
        }
        item.setItemMeta(meta);
        return item;
    }

    public static int compare_enchantments(ItemStack item_a, ItemStack item_b) {
        Map stored;
        ItemMeta b_meta;
        Map stored2;
        Map ae = item_a.getEnchantments();
        Map be = item_b.getEnchantments();
        ItemMeta a_meta = item_a.getItemMeta();
        if (a_meta instanceof EnchantmentStorageMeta && (stored2 = ((EnchantmentStorageMeta)a_meta).getStoredEnchants()).size() > 0) {
            ae = stored2;
        }
        if ((b_meta = item_b.getItemMeta()) instanceof EnchantmentStorageMeta && (stored = ((EnchantmentStorageMeta)b_meta).getStoredEnchants()).size() > 0) {
            be = stored;
        }
        int a_count = ae.size();
        int b_count = be.size();
        if (a_count == 0 && b_count == 0) {
            return 0;
        }
        if (a_count == 0) {
            return -1;
        }
        if (b_count == 0) {
            return 1;
        }
        if (a_count != b_count) {
            return b_count - a_count;
        }
        List a_sorted = ae.entrySet().stream().sorted(Map.Entry.comparingByKey((a, b) -> a.getKey().toString().compareTo(b.getKey().toString())).thenComparing(Map.Entry.comparingByValue())).toList();
        List b_sorted = be.entrySet().stream().sorted(Map.Entry.comparingByKey((a, b) -> a.getKey().toString().compareTo(b.getKey().toString())).thenComparing(Map.Entry.comparingByValue())).toList();
        Iterator ait = a_sorted.iterator();
        Iterator bit = b_sorted.iterator();
        while (ait.hasNext()) {
            Map.Entry a_el = ait.next();
            Map.Entry b_el = bit.next();
            int name_diff = ((Enchantment)a_el.getKey()).getKey().toString().compareTo(((Enchantment)b_el.getKey()).getKey().toString());
            if (name_diff != 0) {
                return name_diff;
            }
            int level_diff = (Integer)b_el.getValue() - (Integer)a_el.getValue();
            if (level_diff == 0) continue;
            return level_diff;
        }
        return 0;
    }

    public static ItemStack skull_for_player(OfflinePlayer player, boolean is_for_menu) {
        ItemStack item = new ItemStack(Material.PLAYER_HEAD);
        if (!is_for_menu || Core.instance().config_player_heads_in_menus) {
            item.editMeta(SkullMeta.class, meta -> meta.setOwningPlayer(player));
        }
        return item;
    }

    public static ItemStack skull_with_texture(String name, String base64_texture) {
        PlayerProfile profile = Bukkit.createProfileExact((UUID)SKULL_OWNER, (String)"-");
        profile.setProperty(new ProfileProperty("textures", base64_texture));
        ItemStack item = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        TextComponent name_component = (TextComponent)((TextComponent)Component.text((String)name).decoration(TextDecoration.ITALIC, false)).color((TextColor)NamedTextColor.YELLOW);
        meta.displayName((Component)name_component);
        meta.setPlayerProfile(profile);
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    public static boolean has_sentinel(Component component, NamespacedKey sentiel) {
        if (component == null) {
            return false;
        }
        HoverEvent hover = component.hoverEvent();
        if (hover == null) {
            return false;
        }
        Object object = hover.value();
        if (object instanceof TextComponent) {
            TextComponent hover_text = (TextComponent)object;
            return hover.action() == HoverEvent.Action.SHOW_TEXT && sentiel.toString().equals(hover_text.content());
        }
        return false;
    }

    public static Component add_sentinel(Component component, NamespacedKey sentinel) {
        return component.hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)sentinel.toString())));
    }

    private static ItemStack apply_enchants(ItemStack item_stack, @Nullable String enchants) {
        String[] parts;
        if (enchants == null) {
            return item_stack;
        }
        if (!(enchants = enchants.trim()).startsWith("{") || !enchants.endsWith("}")) {
            throw new IllegalArgumentException("enchantments must be of form {<namespace:enchant>[*<level>][,<namespace:enchant>[*<level>]]...}");
        }
        for (String part : parts = enchants.substring(1, enchants.length() - 1).split(",")) {
            Enchantment ench;
            String key = part = part.trim();
            int level = 1;
            int level_delim = key.indexOf(42);
            if (level_delim != -1) {
                level = Integer.parseInt(key.substring(level_delim + 1));
                key = key.substring(0, level_delim);
            }
            if ((ench = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(NamespacedKey.fromString((String)key))) == null) {
                throw new IllegalArgumentException("Cannot apply unknown enchantment '" + key + "' to item '" + String.valueOf(item_stack) + "'");
            }
            if (item_stack.getType() == Material.ENCHANTED_BOOK) {
                int flevel = level;
                item_stack.editMeta(EnchantmentStorageMeta.class, meta -> meta.addStoredEnchant(ench, flevel, false));
                continue;
            }
            item_stack.addEnchantment(ench, level);
        }
        if (parts.length > 0) {
            Core.instance().enchantment_manager.update_enchanted_item(item_stack);
        }
        return item_stack;
    }

    @NotNull
    public static Pair<ItemStack, Boolean> itemstack_from_string(String definition) {
        int nbt_delim;
        NamespacedKey key;
        ExtendedMaterial emat;
        if ("minecraft:chain".equalsIgnoreCase(definition)) {
            definition = "minecraft:iron_chain";
        }
        int enchants_delim = definition.indexOf("#enchants{");
        String enchants = null;
        if (enchants_delim != -1) {
            enchants = definition.substring(enchants_delim + 9);
            definition = definition.substring(0, enchants_delim);
        }
        if ((emat = ExtendedMaterial.from(key = (nbt_delim = definition.indexOf(91)) == -1 ? NamespacedKey.fromString((String)definition) : NamespacedKey.fromString((String)definition.substring(0, nbt_delim)))) == null) {
            throw new IllegalArgumentException("Invalid extended material definition: " + definition);
        }
        ItemStack item_stack = emat.item();
        if (nbt_delim == -1) {
            return Pair.of(ItemUtil.apply_enchants(item_stack, enchants), emat.is_simple_material() && enchants == null);
        }
        String vanilla_definition = String.valueOf(item_stack.getType().key()) + definition.substring(nbt_delim);
        try {
            DataComponentPatch parsed_nbt = new ItemParser((HolderLookup.Provider)Commands.createValidationContext((HolderLookup.Provider)VanillaRegistries.createLookup())).parse(new StringReader(vanilla_definition)).components();
            net.minecraft.world.item.ItemStack nms_item = Nms.item_handle(item_stack).copy();
            nms_item.applyComponents(parsed_nbt);
            return Pair.of(ItemUtil.apply_enchants((ItemStack)CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)nms_item), enchants), false);
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Could not parse NBT of item definition: " + definition, e);
        }
    }

    public static class ItemStackComparator
    implements Comparator<ItemStack> {
        @Override
        public int compare(ItemStack a, ItemStack b) {
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return 1;
            }
            if (b == null) {
                return -1;
            }
            net.minecraft.world.item.ItemStack na = Nms.item_handle(a);
            net.minecraft.world.item.ItemStack nb = Nms.item_handle(b);
            if (na.isEmpty()) {
                return nb.isEmpty() ? 0 : 1;
            }
            if (nb.isEmpty()) {
                return -1;
            }
            int creative_mode_tab_diff = Nms.creative_tab_id(na) - Nms.creative_tab_id(nb);
            if (creative_mode_tab_diff != 0) {
                return creative_mode_tab_diff;
            }
            int id_diff = Item.getId((Item)na.getItem()) - Item.getId((Item)nb.getItem());
            if (id_diff != 0) {
                return id_diff;
            }
            int damage_diff = na.getDamageValue() - nb.getDamageValue();
            if (damage_diff != 0) {
                return damage_diff;
            }
            int count_diff = nb.getCount() - na.getCount();
            if (count_diff != 0) {
                return count_diff;
            }
            return ItemUtil.compare_enchantments(a, b);
        }
    }
}

