/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.util;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.types.Type;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class Nms {
    public static ServerPlayer get_player(Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    public static net.minecraft.world.entity.Entity entity_handle(Entity entity) {
        return ((CraftEntity)entity).getHandle();
    }

    public static org.bukkit.enchantments.Enchantment bukkit_enchantment(Enchantment enchantment) {
        return CraftEnchantment.minecraftToBukkit((Enchantment)enchantment);
    }

    @NotNull
    public static ItemStack bukkit_item_stack(net.minecraft.world.item.ItemStack stack) {
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)stack);
    }

    public static TagKey<Item> enchantment_slot_type(EnchantmentTarget target) {
        switch (target) {
            case ARMOR: {
                return ItemTags.ARMOR_ENCHANTABLE;
            }
            case ARMOR_FEET: {
                return ItemTags.FOOT_ARMOR_ENCHANTABLE;
            }
            case ARMOR_HEAD: {
                return ItemTags.HEAD_ARMOR_ENCHANTABLE;
            }
            case ARMOR_LEGS: {
                return ItemTags.LEG_ARMOR_ENCHANTABLE;
            }
            case ARMOR_TORSO: {
                return ItemTags.CHEST_ARMOR_ENCHANTABLE;
            }
            case TOOL: {
                return ItemTags.MINING_ENCHANTABLE;
            }
            case WEAPON: {
                return ItemTags.WEAPON_ENCHANTABLE;
            }
            case BOW: {
                return ItemTags.BOW_ENCHANTABLE;
            }
            case FISHING_ROD: {
                return ItemTags.FISHING_ENCHANTABLE;
            }
            case BREAKABLE: {
                return ItemTags.DURABILITY_ENCHANTABLE;
            }
            case WEARABLE: {
                return ItemTags.EQUIPPABLE_ENCHANTABLE;
            }
            case TRIDENT: {
                return ItemTags.TRIDENT_ENCHANTABLE;
            }
            case CROSSBOW: {
                return ItemTags.CROSSBOW_ENCHANTABLE;
            }
            case VANISHABLE: {
                return ItemTags.VANISHING_ENCHANTABLE;
            }
        }
        return null;
    }

    public static net.minecraft.world.item.ItemStack item_handle(ItemStack item_stack) {
        if (item_stack == null) {
            return null;
        }
        if (!(item_stack instanceof CraftItemStack)) {
            return CraftItemStack.asNMSCopy((ItemStack)item_stack);
        }
        try {
            Field handle = CraftItemStack.class.getDeclaredField("handle");
            handle.setAccessible(true);
            return (net.minecraft.world.item.ItemStack)handle.get(item_stack);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return null;
        }
    }

    public static ServerPlayer player_handle(Player player) {
        if (!(player instanceof CraftPlayer)) {
            return null;
        }
        return ((CraftPlayer)player).getHandle();
    }

    public static ServerLevel world_handle(World world) {
        return ((CraftWorld)world).getHandle();
    }

    public static DedicatedServer server_handle() {
        Server bukkit_server = Bukkit.getServer();
        return ((CraftServer)bukkit_server).getServer();
    }

    public static void register_entity(NamespacedKey base_entity_type, String pseudo_namespace, String key, EntityType.Builder<?> builder) {
        Map data_types;
        String id = pseudo_namespace + "_" + key;
        int world_version = SharedConstants.getCurrentVersion().dataVersion().version();
        int world_version_key = DataFixUtils.makeKey((int)world_version);
        Map data_types_map = data_types = DataFixers.getDataFixer().getSchema(world_version_key).findChoiceType(References.ENTITY).types();
        data_types_map.put("minecraft:" + id, (Type)data_types_map.get(base_entity_type.toString()));
        ResourceKey rk = ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)id));
        Registry.register((Registry)BuiltInRegistries.ENTITY_TYPE, (String)id, (Object)builder.build(rk));
    }

    public static void spawn(World world, net.minecraft.world.entity.Entity entity) {
        Nms.world_handle(world).addFreshEntity(entity);
    }

    public static int unlock_all_recipes(Player player) {
        Collection recipes = Nms.server_handle().getRecipeManager().getRecipes();
        return Nms.player_handle(player).awardRecipes(recipes);
    }

    public static int creative_tab_id(net.minecraft.world.item.ItemStack item_stack) {
        return (int)CreativeModeTabs.allTabs().stream().takeWhile(tab -> tab.contains(item_stack)).count();
    }

    public static void set_air_no_drops(Block block) {
        BlockEntity entity = Nms.world_handle(block.getWorld()).getBlockEntity(new BlockPos(block.getX(), block.getY(), block.getZ()));
        block.setType(Material.AIR, false);
    }
}

