/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.util.Vector;
import org.oddlama.vane.util.BlockUtil;

public class PlayerUtil {
    public static void apply_elytra_boost(Player player, double factor) {
        Vector v = player.getLocation().getDirection();
        v.normalize();
        v.multiply(factor);
        player.setVelocity(player.getVelocity().add(v));
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_ENDER_DRAGON_FLAP, SoundCategory.PLAYERS, 0.4f, 2.0f);
    }

    public static void remove_one_item_from_hand(Player player, EquipmentSlot hand) {
        ItemStack item = player.getEquipment().getItem(hand);
        if (item.getAmount() == 1) {
            player.getInventory().setItem(hand, null);
        } else {
            item.setAmount(item.getAmount() - 1);
            player.getInventory().setItem(hand, item);
        }
    }

    public static boolean has_items(Player player, Map<ItemStack, Integer> items) {
        if (player.getGameMode() == GameMode.CREATIVE) {
            return true;
        }
        PlayerInventory inventory = player.getInventory();
        for (Map.Entry<ItemStack, Integer> e : items.entrySet()) {
            ItemStack item = e.getKey().clone();
            item.setAmount(1);
            Integer amount = e.getValue();
            if (inventory.containsAtLeast(item, amount.intValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean take_items(Player player, ItemStack item) {
        HashMap<ItemStack, Integer> map = new HashMap<ItemStack, Integer>();
        map.put(item, item.getAmount());
        return PlayerUtil.take_items(player, map);
    }

    public static boolean take_items(Player player, Map<ItemStack, Integer> items) {
        if (player.getGameMode() == GameMode.CREATIVE) {
            return true;
        }
        if (!PlayerUtil.has_items(player, items)) {
            return false;
        }
        PlayerInventory inventory = player.getInventory();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Map.Entry<ItemStack, Integer> e : items.entrySet()) {
            stacks.addAll(Arrays.asList(PlayerUtil.create_lawful_stacks(e.getKey(), e.getValue())));
        }
        HashMap leftovers = inventory.removeItem(stacks.toArray(new ItemStack[0]));
        if (!leftovers.isEmpty()) {
            Bukkit.getLogger().warning("[vane] Unexpected leftovers while removing the following items from a player's inventory: " + String.valueOf(stacks));
            for (Map.Entry l : leftovers.entrySet()) {
                Bukkit.getLogger().warning("[vane] Leftover: " + String.valueOf(l.getKey()) + ", amount: " + String.valueOf(l.getValue()));
            }
            return false;
        }
        return true;
    }

    public static void give_item(Player player, ItemStack item) {
        PlayerUtil.give_items(player, new ItemStack[]{item});
    }

    public static ItemStack[] create_lawful_stacks(ItemStack item, int amount) {
        int stacks = (item.getMaxStackSize() - 1 + amount) / item.getMaxStackSize();
        int leftover = amount % item.getMaxStackSize();
        if (stacks < 1) {
            return new ItemStack[0];
        }
        ItemStack[] items = new ItemStack[stacks];
        for (int i = 0; i < stacks; ++i) {
            items[i] = item.clone();
            items[i].setAmount(item.getMaxStackSize());
        }
        if (leftover != 0) {
            items[stacks - 1].setAmount(leftover);
        }
        return items;
    }

    public static void give_items(Player player, ItemStack item, int amount) {
        PlayerUtil.give_items(player, PlayerUtil.create_lawful_stacks(item, amount));
    }

    public static void give_items(Player player, ItemStack[] items) {
        HashMap leftovers = player.getInventory().addItem(items);
        for (ItemStack item : leftovers.values()) {
            player.getLocation().getWorld().dropItem(player.getLocation(), item).setPickupDelay(0);
        }
    }

    public static boolean till_block(Player player, Block block) {
        BlockBreakEvent break_event = new BlockBreakEvent(block, player);
        Bukkit.getPluginManager().callEvent((Event)break_event);
        if (break_event.isCancelled()) {
            return false;
        }
        block.setType(Material.FARMLAND);
        player.getWorld().playSound(player.getLocation(), Sound.ITEM_HOE_TILL, SoundCategory.BLOCKS, 1.0f, 1.0f);
        return true;
    }

    public static boolean seed_block(Player player, ItemStack used_item, Block block, Material plant_type, Material seed_type) {
        Block below = block.getRelative(BlockFace.DOWN);
        BlockPlaceEvent place_event = new BlockPlaceEvent(block, below.getState(), below, used_item, player, true, EquipmentSlot.HAND);
        Bukkit.getPluginManager().callEvent((Event)place_event);
        if (place_event.isCancelled()) {
            return false;
        }
        if (player.getGameMode() != GameMode.CREATIVE) {
            ItemStack seedstack = new ItemStack(seed_type, 1);
            if (!player.getInventory().containsAtLeast(seedstack, 1)) {
                return false;
            }
            player.getInventory().removeItem(new ItemStack[]{seedstack});
        }
        block.setType(plant_type);
        Ageable ageable = (Ageable)block.getBlockData();
        ageable.setAge(0);
        block.setBlockData((BlockData)ageable);
        player.getWorld().playSound(player.getLocation(), seed_type == Material.NETHER_WART ? Sound.ITEM_NETHER_WART_PLANT : Sound.ITEM_CROP_PLANT, SoundCategory.BLOCKS, 1.0f, 1.0f);
        return true;
    }

    public static boolean harvest_plant(Player player, Block block) {
        ItemStack[] drops;
        switch (block.getType()) {
            default: {
                return false;
            }
            case WHEAT: {
                drops = new ItemStack[]{new ItemStack(Material.WHEAT, 1 + (int)(Math.random() * 2.5))};
                break;
            }
            case CARROTS: {
                drops = new ItemStack[]{new ItemStack(Material.CARROT, 1 + (int)(Math.random() * 2.5))};
                break;
            }
            case POTATOES: {
                drops = new ItemStack[]{new ItemStack(Material.POTATO, 1 + (int)(Math.random() * 2.5))};
                break;
            }
            case BEETROOTS: {
                drops = new ItemStack[]{new ItemStack(Material.BEETROOT, 1 + (int)(Math.random() * 2.5))};
                break;
            }
            case NETHER_WART: {
                drops = new ItemStack[]{new ItemStack(Material.NETHER_WART, 1 + (int)(Math.random() * 2.5))};
            }
        }
        if (!(block.getBlockData() instanceof Ageable)) {
            return false;
        }
        Ageable ageable = (Ageable)block.getBlockData();
        if (ageable.getAge() != ageable.getMaximumAge()) {
            return false;
        }
        BlockBreakEvent break_event = new BlockBreakEvent(block, player);
        Bukkit.getPluginManager().callEvent((Event)break_event);
        if (break_event.isCancelled()) {
            return false;
        }
        ageable.setAge(0);
        block.setBlockData((BlockData)ageable);
        for (ItemStack drop : drops) {
            BlockUtil.drop_naturally(block, drop);
        }
        return true;
    }

    public static void swing_arm(Player player, EquipmentSlot hand) {
        switch (hand) {
            case HAND: {
                player.swingMainHand();
                break;
            }
            case OFF_HAND: {
                player.swingOffHand();
            }
        }
    }
}

