/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ResourceList {
    public static Collection<String> get_resources(Class<?> clazz, Pattern pattern) {
        URL jar_url = clazz.getProtectionDomain().getCodeSource().getLocation();
        try {
            return ResourceList.get_resources(new URI(jar_url.toString()).getPath(), pattern);
        }
        catch (URISyntaxException e) {
            return new ArrayList<String>();
        }
    }

    private static Collection<String> get_resources(String path, Pattern pattern) {
        ArrayList<String> retval = new ArrayList<String>();
        File file = new File(path);
        if (file.isDirectory()) {
            retval.addAll(ResourceList.get_resources_from_directory(file, pattern));
        } else {
            retval.addAll(ResourceList.get_resources_from_jar_file(file, pattern));
        }
        return retval;
    }

    private static Collection<String> get_resources_from_jar_file(File file, Pattern pattern) {
        ZipFile zf;
        ArrayList<String> retval = new ArrayList<String>();
        try {
            zf = new ZipFile(file);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        Enumeration<? extends ZipEntry> e = zf.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            String fileName = ze.getName();
            boolean accept = pattern.matcher(fileName).matches();
            if (!accept) continue;
            retval.add(fileName);
        }
        try {
            zf.close();
        }
        catch (IOException e1) {
            throw new Error(e1);
        }
        return retval;
    }

    private static Collection<String> get_resources_from_directory(File directory, Pattern pattern) {
        File[] fileList;
        ArrayList<String> retval = new ArrayList<String>();
        for (File file : fileList = directory.listFiles()) {
            if (file.isDirectory()) {
                retval.addAll(ResourceList.get_resources_from_directory(file, pattern));
                continue;
            }
            try {
                String fileName = file.getCanonicalPath();
                boolean accept = pattern.matcher(fileName).matches();
                if (!accept) continue;
                retval.add(fileName);
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
        return retval;
    }
}

