/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.util;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class StorageUtil {
    public static NamespacedKey namespaced_key(String namespace, String key) {
        return new NamespacedKey(namespace, key);
    }

    public static NamespacedKey subkey(NamespacedKey key, String sub) {
        return StorageUtil.namespaced_key(key.namespace(), key.value() + "." + sub);
    }

    public static boolean storage_has_location(@NotNull PersistentDataContainer data, NamespacedKey key) {
        return data.has(StorageUtil.subkey(key, "world"), PersistentDataType.STRING);
    }

    public static Location storage_get_location(@NotNull PersistentDataContainer data, NamespacedKey key, Location def) {
        try {
            String world_id = (String)data.get(StorageUtil.subkey(key, "world"), PersistentDataType.STRING);
            Double x = (Double)data.get(StorageUtil.subkey(key, "x"), PersistentDataType.DOUBLE);
            Double y = (Double)data.get(StorageUtil.subkey(key, "y"), PersistentDataType.DOUBLE);
            Double z = (Double)data.get(StorageUtil.subkey(key, "z"), PersistentDataType.DOUBLE);
            Float yaw = (Float)data.get(StorageUtil.subkey(key, "yaw"), PersistentDataType.FLOAT);
            Float pitch = (Float)data.get(StorageUtil.subkey(key, "pitch"), PersistentDataType.FLOAT);
            World world = Bukkit.getWorld((UUID)UUID.fromString(world_id));
            if (world == null) {
                return def;
            }
            return new Location(world, x.doubleValue(), y.doubleValue(), z.doubleValue(), yaw.floatValue(), pitch.floatValue());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return def;
        }
    }

    public static void storage_remove_location(@NotNull PersistentDataContainer data, NamespacedKey key) {
        data.remove(StorageUtil.subkey(key, "world"));
        data.remove(StorageUtil.subkey(key, "x"));
        data.remove(StorageUtil.subkey(key, "y"));
        data.remove(StorageUtil.subkey(key, "z"));
        data.remove(StorageUtil.subkey(key, "yaw"));
        data.remove(StorageUtil.subkey(key, "pitch"));
    }

    public static void storage_set_location(@NotNull PersistentDataContainer data, NamespacedKey key, @NotNull Location location) {
        data.set(StorageUtil.subkey(key, "world"), PersistentDataType.STRING, (Object)location.getWorld().getUID().toString());
        data.set(StorageUtil.subkey(key, "x"), PersistentDataType.DOUBLE, (Object)location.getX());
        data.set(StorageUtil.subkey(key, "y"), PersistentDataType.DOUBLE, (Object)location.getY());
        data.set(StorageUtil.subkey(key, "z"), PersistentDataType.DOUBLE, (Object)location.getZ());
        data.set(StorageUtil.subkey(key, "yaw"), PersistentDataType.FLOAT, (Object)Float.valueOf(location.getYaw()));
        data.set(StorageUtil.subkey(key, "pitch"), PersistentDataType.FLOAT, (Object)Float.valueOf(location.getPitch()));
    }
}

