/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.util;

import java.util.HashMap;
import java.util.UUID;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class WorldUtil {
    private static final HashMap<UUID, BukkitTask> running_time_change_tasks = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean change_time_smoothly(final World world, Plugin plugin, long world_ticks, final long interpolation_ticks) {
        HashMap<UUID, BukkitTask> hashMap = running_time_change_tasks;
        synchronized (hashMap) {
            if (running_time_change_tasks.containsKey(world.getUID())) {
                return false;
            }
            long rel_to = world_ticks;
            long rel_from = world.getTime();
            if (rel_to <= rel_from) {
                rel_to += 24000L;
            }
            final long delta_ticks = rel_to - rel_from;
            final long absolute_from = world.getFullTime();
            long absolute_to = absolute_from - rel_from + rel_to;
            BukkitTask task = plugin.getServer().getScheduler().runTaskTimer(plugin, new Runnable(){
                private long elapsed = 0L;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (this.elapsed > interpolation_ticks) {
                        HashMap<UUID, BukkitTask> hashMap = running_time_change_tasks;
                        synchronized (hashMap) {
                            running_time_change_tasks.remove(world.getUID()).cancel();
                        }
                    }
                    float lin_delta = (float)this.elapsed / (float)interpolation_ticks;
                    float delta = (1.0f - (float)Math.cos(Math.PI * (double)lin_delta)) / 2.0f;
                    long cur_ticks = absolute_from + (long)((float)delta_ticks * delta);
                    world.setFullTime(cur_ticks);
                    ++this.elapsed;
                }
            }, 1L, 1L);
            running_time_change_tasks.put(world.getUID(), task);
        }
        return true;
    }
}

