/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.enchantments;

import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.data.EnchantmentRegistryEntry;
import io.papermc.paper.registry.event.RegistryComposeEvent;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.registry.set.RegistrySet;
import io.papermc.paper.registry.tag.TagKey;
import java.util.List;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemType;

public abstract class CustomEnchantmentRegistry {
    public static final String NAMESPACE = "vane_enchantments";
    private static final String TRANSLATE_KEY = "vane_enchantments.enchantment_%s.name";
    Key key;
    Component description;
    int max_level;
    TagKey<ItemType> supported_item_tags;
    List<TypedKey<ItemType>> supported_items = List.of();
    TagKey<Enchantment> exclusive_with_tags;
    List<TypedKey<Enchantment>> exclusive_with = List.of();

    public CustomEnchantmentRegistry(String name, TagKey<ItemType> supported_item_tags, int max_level) {
        this.key = Key.key((String)NAMESPACE, (String)name);
        this.description = Component.translatable((String)String.format(TRANSLATE_KEY, name));
        this.supported_item_tags = supported_item_tags;
        this.max_level = max_level;
    }

    public CustomEnchantmentRegistry(String name, List<TypedKey<ItemType>> supported_items, int max_level) {
        this.key = Key.key((String)NAMESPACE, (String)name);
        this.description = Component.translatable((String)String.format(TRANSLATE_KEY, name));
        this.supported_items = supported_items;
        this.max_level = max_level;
    }

    public CustomEnchantmentRegistry exclusive_with(List<TypedKey<Enchantment>> enchantments) {
        this.exclusive_with = enchantments;
        return this;
    }

    public CustomEnchantmentRegistry exclusive_with(TagKey<Enchantment> enchantment_tag) {
        this.exclusive_with_tags = enchantment_tag;
        return this;
    }

    public RegistryKeySet<Enchantment> exclusive_with(RegistryComposeEvent<Enchantment, EnchantmentRegistryEntry.Builder> composeEvent) {
        if (this.exclusive_with_tags != null) {
            return composeEvent.getOrCreateTag(this.exclusive_with_tags);
        }
        return RegistrySet.keySet((RegistryKey)RegistryKey.ENCHANTMENT, this.exclusive_with);
    }

    public void register(RegistryComposeEvent<Enchantment, EnchantmentRegistryEntry.Builder> composeEvent) {
        composeEvent.registry().register(TypedKey.create((RegistryKey)RegistryKey.ENCHANTMENT, (Key)this.key), e -> e.description(this.description).supportedItems((RegistryKeySet)(this.supported_items.size() > 0 ? RegistrySet.keySet((RegistryKey)RegistryKey.ITEM, this.supported_items) : composeEvent.getOrCreateTag(this.supported_item_tags))).anvilCost(1).maxLevel(this.max_level).weight(10).minimumCost(EnchantmentRegistryEntry.EnchantmentCost.of((int)1, (int)1)).maximumCost(EnchantmentRegistryEntry.EnchantmentCost.of((int)3, (int)1)).activeSlots(new EquipmentSlotGroup[]{EquipmentSlotGroup.ANY}).exclusiveWith(this.exclusive_with(composeEvent)));
    }

    public TypedKey<Enchantment> typedKey(String name) {
        return TypedKey.create((RegistryKey)RegistryKey.ENCHANTMENT, (Key)Key.key((String)NAMESPACE, (String)name));
    }
}

