/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.enchantments.enchantments;

import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootTables;
import org.bukkit.util.Vector;
import org.oddlama.vane.annotation.config.ConfigDouble;
import org.oddlama.vane.annotation.config.ConfigDoubleList;
import org.oddlama.vane.annotation.enchantment.Rarity;
import org.oddlama.vane.annotation.enchantment.VaneEnchantment;
import org.oddlama.vane.core.config.loot.LootDefinition;
import org.oddlama.vane.core.config.loot.LootTableList;
import org.oddlama.vane.core.config.recipes.RecipeDefinition;
import org.oddlama.vane.core.config.recipes.RecipeList;
import org.oddlama.vane.core.config.recipes.ShapedRecipeDefinition;
import org.oddlama.vane.core.enchantments.CustomEnchantment;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.enchantments.Enchantments;

@VaneEnchantment(name="angel", max_level=5, rarity=Rarity.VERY_RARE, treasure=true, allow_custom=true)
public class Angel
extends CustomEnchantment<Enchantments> {
    @ConfigDouble(def=0.1, min=0.0, max=1.0, desc="Acceleration percentage. Each tick, the current flying speed is increased X percent towards the target speed. Low values (~0.1) typically result in a smooth acceleration curve and a natural feeling.")
    private double config_acceleration_percentage;
    @ConfigDoubleList(def={0.7, 1.1, 1.4, 1.7, 2.0}, min=0.0, desc="Flying speed in blocks per second for each enchantment level.")
    private List<Double> config_speed;

    public Angel(Context<Enchantments> context) {
        super(context);
    }

    public RecipeList default_recipes() {
        return RecipeList.of((RecipeDefinition[])new RecipeDefinition[]{new ShapedRecipeDefinition("generic").shape(new String[]{"prp", "mbm", "mdm"}).set_ingredient('b', "vane_enchantments:ancient_tome_of_the_gods").set_ingredient('m', Material.PHANTOM_MEMBRANE).set_ingredient('d', Material.DRAGON_BREATH).set_ingredient('p', Material.PUFFERFISH_BUCKET).set_ingredient('r', Material.FIREWORK_ROCKET).result(this.on("vane_enchantments:enchanted_ancient_tome_of_the_gods"))});
    }

    public LootTableList default_loot_tables() {
        return LootTableList.of((LootDefinition[])new LootDefinition[]{new LootDefinition("generic").in(LootTables.BURIED_TREASURE).in(LootTables.PILLAGER_OUTPOST).in(LootTables.RUINED_PORTAL).in(LootTables.STRONGHOLD_LIBRARY).in(LootTables.UNDERWATER_RUIN_BIG).in(LootTables.VILLAGE_TEMPLE).add(0.004, 1, 1, this.on("vane_enchantments:enchanted_ancient_tome_of_the_gods"))});
    }

    private double get_speed(int level) {
        if (level > 0 && level <= this.config_speed.size()) {
            return this.config_speed.get(level - 1);
        }
        return this.config_speed.get(0);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on_player_move(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (!player.isSneaking() || !player.isGliding()) {
            return;
        }
        ItemStack chest = player.getEquipment().getChestplate();
        if (chest == null) {
            return;
        }
        int level = chest.getEnchantmentLevel(this.bukkit());
        if (level == 0) {
            return;
        }
        Location loc = player.getLocation();
        Vector dir = loc.getDirection();
        if (dir.length() == 0.0) {
            return;
        }
        Vector vel = player.getVelocity();
        double delta = this.config_acceleration_percentage * (1.0 - (double)dir.angle(vel) / Math.PI);
        double factor = this.get_speed(level);
        Vector new_vel = vel.multiply(1.0 - delta).add(dir.normalize().multiply(delta * factor));
        player.setVelocity(new_vel);
        loc.getWorld().spawnParticle(Particle.FIREWORK, loc, 0, -new_vel.getX(), -new_vel.getY(), -new_vel.getZ(), 0.4);
    }
}

