/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.enchantments.enchantments;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.oddlama.vane.annotation.config.ConfigDouble;
import org.oddlama.vane.annotation.config.ConfigDoubleList;
import org.oddlama.vane.annotation.enchantment.Rarity;
import org.oddlama.vane.annotation.enchantment.VaneEnchantment;
import org.oddlama.vane.core.config.recipes.RecipeDefinition;
import org.oddlama.vane.core.config.recipes.RecipeList;
import org.oddlama.vane.core.config.recipes.ShapedRecipeDefinition;
import org.oddlama.vane.core.enchantments.CustomEnchantment;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.enchantments.Enchantments;

@VaneEnchantment(name="grappling_hook", max_level=3, rarity=Rarity.UNCOMMON, treasure=true, target=EnchantmentTarget.FISHING_ROD)
public class GrapplingHook
extends CustomEnchantment<Enchantments> {
    private static final Vector CONSTANT_OFFSET = new Vector(0.0, 0.2, 0.0);
    private static final double BOUNDING_BOX_RADIUS = 0.2;
    @ConfigDouble(def=16.0, min=2.0, max=50.0, desc="Ideal grappling distance for maximum grapple strength. Strength increases rapidly before, and falls of slowly after.")
    private double config_ideal_distance;
    @ConfigDoubleList(def={1.6, 2.1, 2.7}, min=0.0, desc="Grappling strength for each enchantment level.")
    private List<Double> config_strength;

    public GrapplingHook(Context<Enchantments> context) {
        super(context);
    }

    public RecipeList default_recipes() {
        return RecipeList.of((RecipeDefinition[])new RecipeDefinition[]{new ShapedRecipeDefinition("generic").shape(new String[]{"h", "l", "b"}).set_ingredient('b', "vane_enchantments:ancient_tome_of_knowledge").set_ingredient('l', Material.LEAD).set_ingredient('h', Material.TRIPWIRE_HOOK).result(this.on("vane_enchantments:enchanted_ancient_tome_of_knowledge"))});
    }

    private double get_strength(int level) {
        if (level > 0 && level <= this.config_strength.size()) {
            return this.config_strength.get(level - 1);
        }
        return this.config_strength.get(0);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void on_player_fish_event(PlayerFishEvent event) {
        Player player = event.getPlayer();
        ItemStack item = player.getEquipment().getItemInMainHand();
        int level = item.getEnchantmentLevel(this.bukkit());
        if (level == 0 && (level = (item = player.getEquipment().getItemInOffHand()).getEnchantmentLevel(this.bukkit())) == 0) {
            return;
        }
        switch (event.getState()) {
            case IN_GROUND: {
                break;
            }
            case REEL_IN: {
                double hook_x = event.getHook().getLocation().getX();
                double hook_y = event.getHook().getLocation().getY();
                double hook_z = event.getHook().getLocation().getZ();
                if (event.getHook().wouldCollideUsing(new BoundingBox(hook_x - 0.2, hook_y - 0.2, hook_z - 0.2, hook_x + 0.2, hook_y + 0.2, hook_z + 0.2))) break;
                return;
            }
            default: {
                return;
            }
        }
        Vector direction = event.getHook().getLocation().subtract(player.getLocation()).toVector();
        double distance = direction.length();
        double attenuation = distance / this.config_ideal_distance;
        player.setFallDistance(0.0f);
        double vector_multiplier = this.get_strength(level) * Math.exp(1.0 - attenuation) * attenuation;
        Vector adjusted_vector = direction.normalize().multiply(vector_multiplier).add(CONSTANT_OFFSET);
        if (player.getY() - event.getHook().getY() > 0.0) {
            adjusted_vector.setY(0.0).add(CONSTANT_OFFSET);
        }
        player.setVelocity(player.getVelocity().add(adjusted_vector));
    }
}

