/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.enchantments.enchantments;

import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.oddlama.vane.annotation.config.ConfigBoolean;
import org.oddlama.vane.annotation.config.ConfigInt;
import org.oddlama.vane.annotation.enchantment.Rarity;
import org.oddlama.vane.annotation.enchantment.VaneEnchantment;
import org.oddlama.vane.core.config.recipes.RecipeDefinition;
import org.oddlama.vane.core.config.recipes.RecipeList;
import org.oddlama.vane.core.config.recipes.ShapedRecipeDefinition;
import org.oddlama.vane.core.enchantments.CustomEnchantment;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.enchantments.Enchantments;

@VaneEnchantment(name="lightning", max_level=1, rarity=Rarity.RARE, treasure=true, target=EnchantmentTarget.WEAPON)
public class Lightning
extends CustomEnchantment<Enchantments> {
    @ConfigBoolean(def=true, desc="Toggle lightning enchantment to cancel lightning damage for wielders of the enchant")
    private boolean config_lightning_protection;
    @ConfigInt(def=4, min=0, max=20, desc="Damage modifier for the lightning enchant")
    private int config_lightning_damage;
    @ConfigBoolean(def=true, desc="Enable lightning to work in rainstorms as well")
    private boolean config_lightning_rain;

    public Lightning(Context<Enchantments> context) {
        super(context, false);
    }

    public RecipeList default_recipes() {
        return RecipeList.of((RecipeDefinition[])new RecipeDefinition[]{new ShapedRecipeDefinition("generic").shape(new String[]{"r r", "utu", " b "}).set_ingredient('r', Material.LIGHTNING_ROD).set_ingredient('t', "vane_enchantments:ancient_tome_of_knowledge").set_ingredient('b', Material.BEACON).set_ingredient('u', Material.TOTEM_OF_UNDYING).result(this.on("vane_enchantments:enchanted_ancient_tome_of_knowledge"))});
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void on_lightning_attack(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (event.getCause() != EntityDamageEvent.DamageCause.LIGHTNING) {
            return;
        }
        if (!this.config_lightning_protection) {
            return;
        }
        Player player = (Player)event.getEntity();
        ItemStack item = player.getEquipment().getItemInMainHand();
        int level = item.getEnchantmentLevel(this.bukkit());
        if (level == 0) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void on_sword_attack(EntityDamageByEntityEvent event) {
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        if (event.getCause() != EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
            return;
        }
        Player damager = (Player)event.getDamager();
        Entity damagee = event.getEntity();
        World world = damager.getWorld();
        ItemStack item = damager.getEquipment().getItemInMainHand();
        int level = item.getEnchantmentLevel(this.bukkit());
        if (level == 0) {
            return;
        }
        if (!world.hasStorm()) {
            return;
        }
        if (!this.config_lightning_rain && !world.isThundering()) {
            return;
        }
        if (damagee.getLocation().getBlockY() < world.getHighestBlockYAt(damagee.getLocation())) {
            return;
        }
        event.setDamage(event.getDamage() + (double)this.config_lightning_damage);
        world.strikeLightning(damagee.getLocation());
    }
}

