/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.enchantments.enchantments;

import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.oddlama.vane.annotation.enchantment.Rarity;
import org.oddlama.vane.annotation.enchantment.VaneEnchantment;
import org.oddlama.vane.core.config.recipes.RecipeDefinition;
import org.oddlama.vane.core.config.recipes.RecipeList;
import org.oddlama.vane.core.config.recipes.ShapedRecipeDefinition;
import org.oddlama.vane.core.enchantments.CustomEnchantment;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.enchantments.Enchantments;
import org.oddlama.vane.util.BlockUtil;
import org.oddlama.vane.util.ItemUtil;
import org.oddlama.vane.util.PlayerUtil;

@VaneEnchantment(name="rake", max_level=4, rarity=Rarity.COMMON, treasure=true, target=EnchantmentTarget.TOOL)
public class Rake
extends CustomEnchantment<Enchantments> {
    public Rake(Context<Enchantments> context) {
        super(context);
    }

    public RecipeList default_recipes() {
        return RecipeList.of((RecipeDefinition[])new RecipeDefinition[]{new ShapedRecipeDefinition("generic").shape(new String[]{" h ", "hbh", " h "}).set_ingredient('b', "vane_enchantments:ancient_tome_of_knowledge").set_ingredient('h', Material.GOLDEN_HOE).result(this.on("vane_enchantments:enchanted_ancient_tome_of_knowledge"))});
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void on_player_till_farmland(PlayerInteractEvent event) {
        if (!event.hasBlock() || event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getClickedBlock().getType() != Material.FARMLAND) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getEquipment().getItem(event.getHand());
        int level = item.getEnchantmentLevel(this.bukkit());
        if (level == 0) {
            return;
        }
        Block tillable = BlockUtil.next_tillable_block((Block)event.getClickedBlock(), (int)level, (boolean)true);
        if (tillable == null) {
            return;
        }
        if (PlayerUtil.till_block((Player)player, (Block)tillable)) {
            ItemUtil.damage_item((Player)player, (ItemStack)item, (int)1);
            PlayerUtil.swing_arm((Player)player, (EquipmentSlot)event.getHand());
        }
    }
}

