/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.enchantments.enchantments;

import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.oddlama.vane.annotation.enchantment.Rarity;
import org.oddlama.vane.annotation.enchantment.VaneEnchantment;
import org.oddlama.vane.core.config.recipes.RecipeDefinition;
import org.oddlama.vane.core.config.recipes.RecipeList;
import org.oddlama.vane.core.config.recipes.ShapedRecipeDefinition;
import org.oddlama.vane.core.enchantments.CustomEnchantment;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.enchantments.Enchantments;
import org.oddlama.vane.util.BlockUtil;
import org.oddlama.vane.util.ItemUtil;
import org.oddlama.vane.util.MaterialUtil;
import org.oddlama.vane.util.PlayerUtil;

@VaneEnchantment(name="seeding", max_level=4, rarity=Rarity.COMMON, treasure=true, target=EnchantmentTarget.TOOL)
public class Seeding
extends CustomEnchantment<Enchantments> {
    public Seeding(Context<Enchantments> context) {
        super(context);
    }

    public RecipeList default_recipes() {
        return RecipeList.of((RecipeDefinition[])new RecipeDefinition[]{new ShapedRecipeDefinition("generic").shape(new String[]{"1 7", "2b6", "345"}).set_ingredient('b', "vane_enchantments:ancient_tome_of_knowledge").set_ingredient('1', Material.PUMPKIN_SEEDS).set_ingredient('2', Material.CARROT).set_ingredient('3', Material.WHEAT_SEEDS).set_ingredient('4', Material.NETHER_WART).set_ingredient('5', Material.BEETROOT_SEEDS).set_ingredient('6', Material.POTATO).set_ingredient('7', Material.MELON_SEEDS).result(this.on("vane_enchantments:enchanted_ancient_tome_of_knowledge"))});
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void on_player_right_click_plant(PlayerInteractEvent event) {
        if (!event.hasBlock() || event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Material plant_type = event.getClickedBlock().getType();
        if (!MaterialUtil.is_seeded_plant((Material)plant_type)) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getEquipment().getItem(event.getHand());
        int level = item.getEnchantmentLevel(this.bukkit());
        if (level == 0) {
            return;
        }
        Material seed_type = MaterialUtil.seed_for((Material)plant_type);
        Material farmland_type = MaterialUtil.farmland_for((Material)seed_type);
        Block seedable = BlockUtil.next_seedable_block((Block)event.getClickedBlock(), (Material)farmland_type, (int)level);
        if (seedable == null) {
            return;
        }
        if (PlayerUtil.seed_block((Player)player, (ItemStack)item, (Block)seedable, (Material)plant_type, (Material)seed_type)) {
            ItemUtil.damage_item((Player)player, (ItemStack)item, (int)1);
            PlayerUtil.swing_arm((Player)player, (EquipmentSlot)event.getHand());
        }
    }
}

