/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.enchantments.enchantments;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.loot.LootTables;
import org.bukkit.persistence.PersistentDataHolder;
import org.oddlama.vane.annotation.config.ConfigLong;
import org.oddlama.vane.annotation.enchantment.Rarity;
import org.oddlama.vane.annotation.enchantment.VaneEnchantment;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.core.config.loot.LootDefinition;
import org.oddlama.vane.core.config.loot.LootTableList;
import org.oddlama.vane.core.config.recipes.RecipeDefinition;
import org.oddlama.vane.core.config.recipes.RecipeList;
import org.oddlama.vane.core.config.recipes.ShapedRecipeDefinition;
import org.oddlama.vane.core.data.CooldownData;
import org.oddlama.vane.core.enchantments.CustomEnchantment;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.enchantments.Enchantments;
import org.oddlama.vane.util.StorageUtil;

@VaneEnchantment(name="soulbound", rarity=Rarity.RARE, treasure=true, allow_custom=true)
public class Soulbound
extends CustomEnchantment<Enchantments> {
    @ConfigLong(def=2000L, min=0L, desc="Window to allow Soulbound item drop immediately after a previous drop in milliseconds")
    public long config_cooldown;
    private static final NamespacedKey IGNORE_SOULBOUND_DROP = StorageUtil.namespaced_key((String)"vane_enchantments", (String)"ignore_soulbound_drop");
    private CooldownData drop_cooldown;
    @LangMessage
    public TranslatedMessage lang_drop_lock_warning;
    @LangMessage
    public TranslatedMessage lang_dropped_notification;
    @LangMessage
    public TranslatedMessage lang_drop_cooldown;

    public Soulbound(Context<Enchantments> context) {
        super(context);
        this.drop_cooldown = new CooldownData(IGNORE_SOULBOUND_DROP, this.config_cooldown);
    }

    public void on_config_change() {
        super.on_config_change();
        this.drop_cooldown = new CooldownData(IGNORE_SOULBOUND_DROP, this.config_cooldown);
    }

    public RecipeList default_recipes() {
        return RecipeList.of((RecipeDefinition[])new RecipeDefinition[]{new ShapedRecipeDefinition("generic").shape(new String[]{"cqc", "obe", "rgt"}).set_ingredient('b', "vane_enchantments:ancient_tome_of_the_gods").set_ingredient('c', Material.IRON_CHAIN).set_ingredient('q', Material.WRITABLE_BOOK).set_ingredient('o', Material.BONE).set_ingredient('r', "minecraft:enchanted_book#enchants{minecraft:binding_curse*1}").set_ingredient('g', Material.GHAST_TEAR).set_ingredient('t', Material.TOTEM_OF_UNDYING).set_ingredient('e', Material.ENDER_EYE).result(this.on("vane_enchantments:enchanted_ancient_tome_of_the_gods"))});
    }

    public LootTableList default_loot_tables() {
        return LootTableList.of((LootDefinition[])new LootDefinition[]{new LootDefinition("generic").in(LootTables.BASTION_TREASURE).add(0.06666666666666667, 1, 1, this.on("vane_enchantments:enchanted_ancient_tome_of_the_gods"))});
    }

    public Component apply_display_format(Component component) {
        return component.color((TextColor)NamedTextColor.DARK_GRAY);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on_player_death(PlayerDeathEvent event) {
        List keep_items = event.getItemsToKeep();
        Iterator it = event.getDrops().iterator();
        while (it.hasNext()) {
            ItemStack drop = (ItemStack)it.next();
            if (!this.is_soulbound(drop)) continue;
            keep_items.add(drop);
            it.remove();
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void on_player_inventory_check(InventoryClickEvent event) {
        boolean too_slow;
        if (event.getCursor() == null) {
            return;
        }
        if (!this.is_soulbound(event.getCursor())) {
            return;
        }
        if ((event.getAction() == InventoryAction.DROP_ALL_CURSOR || event.getAction() == InventoryAction.DROP_ONE_CURSOR) && (too_slow = this.drop_cooldown.peek_cooldown((PersistentDataHolder)event.getCursor().getItemMeta()))) {
            ItemMeta meta = event.getCursor().getItemMeta();
            this.drop_cooldown.check_or_update_cooldown((PersistentDataHolder)meta);
            event.getCursor().setItemMeta(meta);
            this.lang_drop_cooldown.send_action_bar((CommandSender)event.getWhoClicked(), new Object[0]);
            event.setResult(Event.Result.DENY);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void on_player_drop_item(PlayerDropItemEvent event) {
        ItemStack dropped_item = event.getItemDrop().getItemStack();
        if (this.is_soulbound(dropped_item)) {
            boolean too_slow = this.drop_cooldown.peek_cooldown((PersistentDataHolder)dropped_item.getItemMeta());
            if (!too_slow) {
                ItemMeta meta = dropped_item.getItemMeta();
                this.drop_cooldown.clear((PersistentDataHolder)dropped_item.getItemMeta());
                dropped_item.setItemMeta(meta);
                this.lang_dropped_notification.send((CommandSender)event.getPlayer(), new Object[]{dropped_item.displayName()});
                return;
            }
            PlayerInventory inventory = event.getPlayer().getInventory();
            if (inventory.firstEmpty() != -1) {
                event.setCancelled(true);
                this.lang_drop_lock_warning.send_action_bar((CommandSender)event.getPlayer(), new Object[]{event.getItemDrop().getItemStack().displayName()});
            } else {
                ListIterator it = inventory.iterator();
                ItemStack non_soulbound_item = null;
                int non_soulbound_item_slot = 0;
                while (it.hasNext()) {
                    ItemStack item = (ItemStack)it.next();
                    if (item.getEnchantmentLevel(this.bukkit()) == 0) {
                        non_soulbound_item = item;
                        break;
                    }
                    ++non_soulbound_item_slot;
                }
                if (non_soulbound_item == null) {
                    return;
                }
                Player player = event.getPlayer();
                inventory.setItem(non_soulbound_item_slot, dropped_item);
                player.getLocation().getWorld().dropItem(player.getLocation(), non_soulbound_item);
                this.lang_drop_lock_warning.send_action_bar((CommandSender)player, new Object[]{event.getItemDrop().getItemStack().displayName()});
                event.setCancelled(true);
            }
        }
    }

    private boolean is_soulbound(ItemStack dropped_item) {
        return dropped_item.getEnchantmentLevel(this.bukkit()) > 0;
    }
}

