/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.enchantments.items;

import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.PrepareGrindstoneEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootTables;
import org.oddlama.vane.annotation.item.VaneItem;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.config.loot.LootDefinition;
import org.oddlama.vane.core.config.loot.LootTableList;
import org.oddlama.vane.core.config.recipes.RecipeDefinition;
import org.oddlama.vane.core.config.recipes.RecipeList;
import org.oddlama.vane.core.config.recipes.ShapedRecipeDefinition;
import org.oddlama.vane.core.config.recipes.ShapelessRecipeDefinition;
import org.oddlama.vane.core.item.CustomItem;
import org.oddlama.vane.core.item.CustomItemHelper;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.ModuleGroup;
import org.oddlama.vane.enchantments.Enchantments;
import org.oddlama.vane.util.StorageUtil;

public class Tomes
extends ModuleGroup<Enchantments> {
    public Tomes(Context<Enchantments> context) {
        super(context, "tomes", "These tomes are needed to craft custom enchantments. If you disable them here, you will need to adjust the recipes for the enchantments accordingly.");
        new GrindstoneListener((Context<Enchantments>)this.get_context());
        new AncientTome((Context<Enchantments>)this.get_context());
        new EnchantedAncientTome((Context<Enchantments>)this.get_context());
        new AncientTomeOfKnowledge((Context<Enchantments>)this.get_context());
        new EnchantedAncientTomeOfKnowledge((Context<Enchantments>)this.get_context());
        new AncientTomeOfTheGods((Context<Enchantments>)this.get_context());
        new EnchantedAncientTomeOfTheGods((Context<Enchantments>)this.get_context());
    }

    @VaneItem(name="enchanted_ancient_tome_of_the_gods", base=Material.ENCHANTED_BOOK, model_data=0x770005, version=1)
    public static class GrindstoneListener
    extends Listener<Enchantments> {
        public GrindstoneListener(Context<Enchantments> context) {
            super(context);
        }

        @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
        public void on_prepare_grindstone(PrepareGrindstoneEvent event) {
            ItemStack res = event.getResult();
            if (res == null) {
                return;
            }
            if (!res.getEnchantments().isEmpty()) {
                return;
            }
            org.oddlama.vane.core.item.api.CustomItem custom_item = ((Enchantments)this.get_module()).core.item_registry().get(res);
            if (custom_item instanceof EnchantedAncientTome) {
                event.setResult(CustomItemHelper.newStack((String)"vane_enchantments:ancient_tome"));
            } else if (custom_item instanceof EnchantedAncientTomeOfKnowledge) {
                event.setResult(CustomItemHelper.newStack((String)"vane_enchantments:ancient_tome_of_knowledge"));
            } else if (custom_item instanceof EnchantedAncientTomeOfTheGods) {
                event.setResult(CustomItemHelper.newStack((String)"vane_enchantments:ancient_tome_of_the_gods"));
            }
        }
    }

    @VaneItem(name="ancient_tome", base=Material.BOOK, model_data=0x770000, version=1)
    public static class AncientTome
    extends CustomItem<Enchantments> {
        public AncientTome(Context<Enchantments> context) {
            super(context);
        }

        public LootTableList default_loot_tables() {
            return LootTableList.of((LootDefinition[])new LootDefinition[]{new LootDefinition("generic").in(LootTables.ABANDONED_MINESHAFT).in(LootTables.BASTION_BRIDGE).in(LootTables.BASTION_HOGLIN_STABLE).in(LootTables.BASTION_OTHER).in(LootTables.BASTION_TREASURE).in(LootTables.BURIED_TREASURE).in(LootTables.DESERT_PYRAMID).in(LootTables.END_CITY_TREASURE).in(LootTables.FISHING_TREASURE).in(LootTables.IGLOO_CHEST).in(LootTables.JUNGLE_TEMPLE).in(LootTables.NETHER_BRIDGE).in(LootTables.PILLAGER_OUTPOST).in(LootTables.RUINED_PORTAL).in(LootTables.SHIPWRECK_TREASURE).in(LootTables.STRONGHOLD_LIBRARY).in(LootTables.UNDERWATER_RUIN_BIG).in(LootTables.UNDERWATER_RUIN_SMALL).in(LootTables.VILLAGE_TEMPLE).in(LootTables.WOODLAND_MANSION).add(0.2, 0, 2, this.key().toString()), new LootDefinition("ancientcity").in(LootTables.ANCIENT_CITY).add(0.05, 0, 2, this.key().toString()), new LootDefinition("terralith_generic").in(StorageUtil.namespaced_key((String)"terralith", (String)"spire/common")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/desert/generic_low")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/fortified/generic_low")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/fortified/smith/novice")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/desert/smith/novice")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/fortified/tavern_downstairs")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/fortified/tavern_upstairs")).in(StorageUtil.namespaced_key((String)"terralith", (String)"ruin/glacial/main_cs")).in(StorageUtil.namespaced_key((String)"terralith", (String)"spire/treasure")).in(StorageUtil.namespaced_key((String)"terralith", (String)"underground/chest")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/desert/archer")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/desert/attic")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/desert/butcher")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/desert/cartographer")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/desert/generic")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/desert/library")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/desert/mason")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/desert/smith")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/desert/treasure")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/fortified/archer")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/fortified/attic")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/fortified/butcher")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/fortified/cartographer")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/fortified/fisherman")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/fortified/food")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/fortified/generic")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/fortified/library")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/fortified/mason")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/fortified/smith")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/fortified/treasure")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/treasure/diamond")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/treasure/emerald")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/treasure/golem")).add(0.2, 0, 2, this.key().toString()), new LootDefinition("terralith_rare").in(StorageUtil.namespaced_key((String)"terralith", (String)"village/desert/smith/expert")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/fortified/smith/expert")).in(StorageUtil.namespaced_key((String)"terralith", (String)"spire/rare")).add(0.05, 0, 2, this.key().toString())});
        }
    }

    @VaneItem(name="enchanted_ancient_tome", base=Material.ENCHANTED_BOOK, model_data=0x770001, version=1)
    public static class EnchantedAncientTome
    extends CustomItem<Enchantments> {
        public EnchantedAncientTome(Context<Enchantments> context) {
            super(context);
        }
    }

    @VaneItem(name="ancient_tome_of_knowledge", base=Material.BOOK, model_data=0x770002, version=1)
    public static class AncientTomeOfKnowledge
    extends CustomItem<Enchantments> {
        public AncientTomeOfKnowledge(Context<Enchantments> context) {
            super(context);
        }

        public RecipeList default_recipes() {
            return RecipeList.of((RecipeDefinition[])new RecipeDefinition[]{new ShapelessRecipeDefinition("generic").add_ingredient("vane_enchantments:ancient_tome").add_ingredient(Material.FEATHER).add_ingredient(Material.BLAZE_ROD).add_ingredient(Material.GHAST_TEAR).result(this.key().toString())});
        }

        public LootTableList default_loot_tables() {
            return LootTableList.of((LootDefinition[])new LootDefinition[]{new LootDefinition("generic").in(LootTables.ABANDONED_MINESHAFT).in(LootTables.BASTION_TREASURE).in(LootTables.BURIED_TREASURE).in(LootTables.DESERT_PYRAMID).in(LootTables.NETHER_BRIDGE).in(LootTables.RUINED_PORTAL).in(LootTables.SHIPWRECK_TREASURE).in(LootTables.STRONGHOLD_LIBRARY).in(LootTables.UNDERWATER_RUIN_BIG).in(LootTables.VILLAGE_TEMPLE).in(LootTables.WOODLAND_MANSION).add(0.025, 1, 1, this.key().toString()), new LootDefinition("ancientcity").in(LootTables.ANCIENT_CITY).add(0.03333333333333333, 1, 1, this.key().toString()).add(0.03333333333333333, 1, 1, this.key().toString()), new LootDefinition("terralith_generic").in(StorageUtil.namespaced_key((String)"terralith", (String)"ruin/glacial/main_cs")).in(StorageUtil.namespaced_key((String)"terralith", (String)"spire/treasure")).in(StorageUtil.namespaced_key((String)"terralith", (String)"underground/chest")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/desert/archer")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/desert/attic")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/desert/butcher")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/desert/cartographer")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/desert/generic")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/desert/library")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/desert/mason")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/desert/smith")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/desert/treasure")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/fortified/archer")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/fortified/attic")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/fortified/butcher")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/fortified/cartographer")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/fortified/fisherman")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/fortified/food")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/fortified/generic")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/fortified/library")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/fortified/mason")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/fortified/smith")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/fortified/treasure")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/treasure/diamond")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/treasure/emerald")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/treasure/golem")).add(0.025, 1, 1, this.key().toString()), new LootDefinition("terralith_rare").in(StorageUtil.namespaced_key((String)"terralith", (String)"village/desert/smith/expert")).in(StorageUtil.namespaced_key((String)"terralith", (String)"village/fortified/smith/expert")).in(StorageUtil.namespaced_key((String)"terralith", (String)"spire/rare")).add(0.03333333333333333, 1, 1, this.key().toString()).add(0.03333333333333333, 1, 1, this.key().toString())});
        }
    }

    @VaneItem(name="enchanted_ancient_tome_of_knowledge", base=Material.ENCHANTED_BOOK, model_data=0x770003, version=1)
    public static class EnchantedAncientTomeOfKnowledge
    extends CustomItem<Enchantments> {
        public EnchantedAncientTomeOfKnowledge(Context<Enchantments> context) {
            super(context);
        }
    }

    @VaneItem(name="ancient_tome_of_the_gods", base=Material.BOOK, model_data=0x770004, version=1)
    public static class AncientTomeOfTheGods
    extends CustomItem<Enchantments> {
        public AncientTomeOfTheGods(Context<Enchantments> context) {
            super(context);
        }

        public RecipeList default_recipes() {
            return RecipeList.of((RecipeDefinition[])new RecipeDefinition[]{new ShapedRecipeDefinition("generic").shape(new String[]{" s ", "ebe", " n "}).set_ingredient('b', "vane_enchantments:ancient_tome_of_knowledge").set_ingredient('e', Material.ENCHANTED_BOOK).set_ingredient('s', Material.NETHER_STAR).set_ingredient('n', Material.NAUTILUS_SHELL).result(this.key().toString())});
        }

        public LootTableList default_loot_tables() {
            return LootTableList.of((LootDefinition[])new LootDefinition[]{new LootDefinition("generic").in(LootTables.BASTION_TREASURE).in(LootTables.BURIED_TREASURE).in(LootTables.SHIPWRECK_TREASURE).in(LootTables.UNDERWATER_RUIN_BIG).add(0.005, 1, 1, this.key().toString()), new LootDefinition("ancientcity").in(LootTables.ANCIENT_CITY).add(0.006666666666666667, 1, 1, this.key().toString()), new LootDefinition("terralith_generic").in(StorageUtil.namespaced_key((String)"terralith", (String)"spire/treasure")).in(StorageUtil.namespaced_key((String)"terralith", (String)"underground/chest")).add(0.005, 1, 1, this.key().toString()), new LootDefinition("terralith_rare").in(StorageUtil.namespaced_key((String)"terralith", (String)"spire/rare")).add(0.006666666666666667, 1, 1, this.key().toString())});
        }
    }

    @VaneItem(name="enchanted_ancient_tome_of_the_gods", base=Material.ENCHANTED_BOOK, model_data=0x770005, version=1)
    public static class EnchantedAncientTomeOfTheGods
    extends CustomItem<Enchantments> {
        public EnchantedAncientTomeOfTheGods(Context<Enchantments> context) {
            super(context);
        }
    }
}

