/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.permissions;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.RemoteServerCommandEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.oddlama.vane.annotation.VaneModule;
import org.oddlama.vane.annotation.config.ConfigBoolean;
import org.oddlama.vane.annotation.config.ConfigString;
import org.oddlama.vane.annotation.config.ConfigStringListMap;
import org.oddlama.vane.annotation.config.ConfigStringListMapEntry;
import org.oddlama.vane.annotation.persistent.Persistent;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.Module;
import org.oddlama.vane.permissions.commands.Permission;
import org.oddlama.vane.permissions.commands.Vouch;

@VaneModule(name="permissions", bstats=8641, config_version=1L, lang_version=1L, storage_version=1L)
public class Permissions
extends Module<Permissions> {
    @ConfigBoolean(def=false, desc="Remove all default permissions from ANY SOURCE (including other plugins and minecraft permissions) to start with a clean preset. This will allow you to exactly set which player have which permissions instead of having to resort to volatile stateful changes like negative permissions. This will result in OPed players to lose access to commands, if not explicitly added back via permissions. The wildcard permissions can be viewed using `perms list permissions`. The wildcard permissions `minecraft` and `craftbukkit` may be especially useful.")
    public boolean config_remove_defaults;
    @ConfigString(def="default", desc="The permission group that will be given to players that have no other permission group.")
    public String config_default_group;
    @ConfigStringListMap(def={@ConfigStringListMapEntry(key="default", list={"bukkit.command.help", "bukkit.broadcast", "bukkit.broadcast.user"}), @ConfigStringListMapEntry(key="user", list={"vane.permissions.groups.default", "vane.admin.modify_world", "vane.regions.commands.region", "vane.trifles.commands.heads"}), @ConfigStringListMapEntry(key="verified", list={"vane.permissions.groups.user", "vane.permissions.commands.vouch"}), @ConfigStringListMapEntry(key="admin", list={"vane.permissions.groups.verified", "vane.admin.bypass_spawn_protection", "vane.portals.admin", "vane.regions.admin", "vane.*.commands.*"})}, desc="The permission groups. A player can have multiple permission groups assigned. Permission groups can inherit other permission groups by specifying vane.permissions.groups.<groupname> as a permission.")
    public Map<String, List<String>> config_groups;
    @Persistent
    public Map<UUID, Set<String>> storage_player_groups = new HashMap<UUID, Set<String>>();
    public final Map<String, Set<String>> permission_groups = new HashMap<String, Set<String>>();
    private final Map<UUID, PermissionAttachment> player_attachments = new HashMap<UUID, PermissionAttachment>();
    private final Map<CommandSender, PermissionAttachment> sender_attachments = new HashMap<CommandSender, PermissionAttachment>();

    public Permissions() {
        new Permission((Context<Permissions>)this);
        new Vouch((Context<Permissions>)this);
    }

    public void on_enable() {
        this.schedule_next_tick(() -> {
            if (this.config_remove_defaults) {
                for (org.bukkit.permissions.Permission perm : this.getServer().getPluginManager().getPermissions()) {
                    perm.setDefault(PermissionDefault.FALSE);
                    this.getServer().getPluginManager().recalculatePermissionDefaults(perm);
                    this.add_console_permission(perm);
                }
            }
        });
    }

    public void on_config_change() {
        this.flatten_groups();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on_player_join(PlayerJoinEvent event) {
        this.register_player(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on_player_kick(PlayerKickEvent event) {
        this.unregister_player(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on_player_quit(PlayerQuitEvent event) {
        this.unregister_player(event.getPlayer());
    }

    private void add_console_permissions(CommandSender sender) {
        if (!this.sender_attachments.containsKey(sender)) {
            PermissionAttachment attachment = sender.addAttachment((Plugin)this);
            this.sender_attachments.put(sender, attachment);
            Map attached_perms = this.console_attachment.getPermissions();
            attached_perms.forEach((p, v) -> attachment.setPermission(p, v.booleanValue()));
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_server_command_event(ServerCommandEvent event) {
        CommandSender sender = event.getSender();
        if (sender instanceof Player && sender.isOp()) {
            this.add_console_permissions(sender);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_remote_server_command_event(RemoteServerCommandEvent event) {
        CommandSender sender = event.getSender();
        if (sender.isOp()) {
            this.add_console_permissions(sender);
        }
    }

    private void flatten_groups() {
        this.permission_groups.clear();
        this.config_groups.forEach((k, v) -> {
            HashSet<String> set = new HashSet<String>();
            for (String perm : v) {
                if (perm.startsWith("vane.permissions.groups.")) continue;
                set.add(perm);
            }
            this.permission_groups.put((String)k, (Set<String>)set);
        });
        var modified = new Object(this){
            boolean value = false;
        };
        do {
            modified.value = false;
            this.config_groups.forEach((k, v) -> {
                Set<String> set = this.permission_groups.get(k);
                for (String perm : v) {
                    if (!perm.startsWith("vane.permissions.groups.")) continue;
                    String group = perm.substring("vane.permissions.groups.".length());
                    Set<String> group_perms = this.permission_groups.get(group);
                    if (group_perms == null) {
                        this.log.severe("Nonexistent permission group '" + group + "' referenced by group '" + k + "'; Ignoring statement!");
                        continue;
                    }
                    modified.value |= set.addAll(group_perms);
                }
            });
        } while (modified.value);
    }

    private void register_player(Player player) {
        PermissionAttachment attachment = player.addAttachment((Plugin)this);
        this.player_attachments.put(player.getUniqueId(), attachment);
        this.recalculate_player_permissions(player);
    }

    public void recalculate_player_permissions(Player player) {
        PermissionAttachment attachment = this.player_attachments.get(player.getUniqueId());
        Map attached_perms = attachment.getPermissions();
        attached_perms.forEach((p, v) -> attachment.unsetPermission(p));
        Set<String> groups = this.storage_player_groups.get(player.getUniqueId());
        if (groups == null || groups.isEmpty()) {
            groups = Set.of(this.config_default_group);
        }
        for (String group : groups) {
            for (String p2 : this.permission_groups.getOrDefault(group, Collections.emptySet())) {
                org.bukkit.permissions.Permission perm = this.getServer().getPluginManager().getPermission(p2);
                if (perm == null) {
                    this.log.warning("Use of unregistered permission '" + p2 + "' might have unintended effects.");
                }
                attachment.setPermission(p2, true);
            }
        }
        player.updateCommands();
    }

    private void unregister_player(Player player) {
        PermissionAttachment attachment = this.player_attachments.remove(player.getUniqueId());
        if (attachment != null) {
            player.removeAttachment(attachment);
        }
    }

    public void save_and_recalculate(OfflinePlayer player) {
        this.mark_persistent_storage_dirty();
        if (player.isOnline()) {
            this.recalculate_player_permissions(player.getPlayer());
        }
    }

    public boolean add_player_to_group(OfflinePlayer player, String group) {
        Set set = this.storage_player_groups.computeIfAbsent(player.getUniqueId(), k -> new HashSet());
        boolean added = set.add(group);
        if (added) {
            this.log.info("[audit] Group " + group + " assigned to " + String.valueOf(player.getUniqueId()) + " (" + player.getName() + ")");
            this.save_and_recalculate(player);
        }
        return added;
    }

    public boolean remove_player_from_group(OfflinePlayer player, String group) {
        Set<String> set = this.storage_player_groups.get(player.getUniqueId());
        boolean removed = false;
        if (set != null) {
            removed = set.remove(group);
        }
        if (removed) {
            this.log.info("[audit] Group " + group + " removed from " + String.valueOf(player.getUniqueId()) + " (" + player.getName() + ")");
            this.save_and_recalculate(player);
        }
        return removed;
    }
}

