/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.permissions.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Collections;
import java.util.Set;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;
import org.oddlama.vane.annotation.command.Aliases;
import org.oddlama.vane.annotation.command.Name;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.core.command.Command;
import org.oddlama.vane.core.command.argumentType.OfflinePlayerArgumentType;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.permissions.Permissions;
import org.oddlama.vane.permissions.argumentTypes.PermissionGroupArgumentType;

@Name(value="permission")
@Aliases(value={"perm"})
public class Permission
extends Command<Permissions> {
    @LangMessage
    private TranslatedMessage lang_list_empty;
    @LangMessage
    private TranslatedMessage lang_list_header_groups;
    @LangMessage
    private TranslatedMessage lang_list_header_permissions;
    @LangMessage
    private TranslatedMessage lang_list_header_player_groups;
    @LangMessage
    private TranslatedMessage lang_list_header_player_permissions;
    @LangMessage
    private TranslatedMessage lang_list_header_group_permissions;
    @LangMessage
    private TranslatedMessage lang_list_player_offline;
    @LangMessage
    private TranslatedMessage lang_list_group;
    @LangMessage
    private TranslatedMessage lang_list_permission;
    @LangMessage
    private TranslatedMessage lang_group_assigned;
    @LangMessage
    private TranslatedMessage lang_group_removed;
    @LangMessage
    private TranslatedMessage lang_group_already_assigned;
    @LangMessage
    private TranslatedMessage lang_group_not_assigned;

    public Permission(Context<Permissions> context) {
        super(context);
    }

    public LiteralArgumentBuilder<CommandSourceStack> get_command_base() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)super.get_command_base().then((ArgumentBuilder)this.help())).then(((LiteralArgumentBuilder)Commands.literal((String)"list").then(((LiteralArgumentBuilder)Commands.literal((String)"groups").executes(ctx -> {
            this.list_groups(((CommandSourceStack)ctx.getSource()).getSender());
            return 1;
        })).then(Commands.argument((String)"offline_player", (ArgumentType)OfflinePlayerArgumentType.offlinePlayer()).executes(ctx -> {
            this.list_groups_for_player((CommandSender)this.sender((CommandContext<CommandSourceStack>)ctx), this.offline_player((CommandContext<CommandSourceStack>)ctx));
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"permissions").then(Commands.argument((String)"permission_group", (ArgumentType)PermissionGroupArgumentType.permissionGroup(((Permissions)this.get_module()).permission_groups)).executes(ctx -> {
            this.list_permissions_for_group(((CommandSourceStack)ctx.getSource()).getSender(), this.permission_group((CommandContext<CommandSourceStack>)ctx));
            return 1;
        }))).then(Commands.argument((String)"offline_player", (ArgumentType)OfflinePlayerArgumentType.offlinePlayer()).executes(ctx -> {
            this.list_permissions_for_player(((CommandSourceStack)ctx.getSource()).getSender(), this.offline_player((CommandContext<CommandSourceStack>)ctx));
            return 1;
        }))).executes(ctx -> {
            this.list_permissions(((CommandSourceStack)ctx.getSource()).getSender());
            return 1;
        })))).then(Commands.literal((String)"add").then(Commands.argument((String)"offline_player", (ArgumentType)OfflinePlayerArgumentType.offlinePlayer()).then(Commands.argument((String)"permission_group", (ArgumentType)PermissionGroupArgumentType.permissionGroup(((Permissions)this.get_module()).permission_groups)).executes(ctx -> {
            this.add_player_to_group(((CommandSourceStack)ctx.getSource()).getSender(), this.offline_player((CommandContext<CommandSourceStack>)ctx), this.permission_group((CommandContext<CommandSourceStack>)ctx));
            return 1;
        }))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"offline_player", (ArgumentType)OfflinePlayerArgumentType.offlinePlayer()).then(Commands.argument((String)"permission_group", (ArgumentType)PermissionGroupArgumentType.permissionGroup(((Permissions)this.get_module()).permission_groups)).executes(ctx -> {
            this.remove_player_from_group(((CommandSourceStack)ctx.getSource()).getSender(), this.offline_player((CommandContext<CommandSourceStack>)ctx), this.permission_group((CommandContext<CommandSourceStack>)ctx));
            return 1;
        }))));
    }

    private String permission_group(CommandContext<CommandSourceStack> ctx) {
        return (String)ctx.getArgument("permission_group", String.class);
    }

    private Player sender(CommandContext<CommandSourceStack> ctx) {
        return (Player)((CommandSourceStack)ctx.getSource()).getSender();
    }

    private OfflinePlayer offline_player(CommandContext<CommandSourceStack> ctx) {
        return (OfflinePlayer)ctx.getArgument("offline_player", OfflinePlayer.class);
    }

    private String permission_default_value_color_code(PermissionDefault def) {
        switch (def) {
            default: {
                return "\u00a76";
            }
            case FALSE: {
                return "\u00a7c";
            }
            case NOT_OP: {
                return "\u00a75";
            }
            case OP: {
                return "\u00a7b";
            }
            case TRUE: 
        }
        return "\u00a7a";
    }

    private String permission_value_color_code(boolean value) {
        return this.permission_default_value_color_code(value ? PermissionDefault.TRUE : PermissionDefault.FALSE);
    }

    private void list_groups(CommandSender sender) {
        this.lang_list_header_groups.send(sender, new Object[0]);
        ((Permissions)this.get_module()).permission_groups.keySet().stream().sorted((a, b) -> a.compareTo((String)b)).forEach(group -> this.lang_list_group.send(sender, new Object[]{"\u00a7b" + group}));
    }

    private void list_permissions(CommandSender sender) {
        this.lang_list_header_permissions.send(sender, new Object[0]);
        ((Permissions)this.get_module()).getServer().getPluginManager().getPermissions().stream().sorted((a, b) -> a.getName().compareTo(b.getName())).forEach(perm -> this.lang_list_permission.send(sender, new Object[]{"\u00a7d" + perm.getName(), this.permission_default_value_color_code(perm.getDefault()) + perm.getDefault().toString().toLowerCase(), perm.getDescription()}));
    }

    private void list_permissions_for_player(CommandSender sender, OfflinePlayer offline_player) {
        this.lang_list_header_player_permissions.send(sender, new Object[]{"\u00a7b" + offline_player.getName()});
        Player player = offline_player.getPlayer();
        if (player == null) {
            this.lang_list_player_offline.send(sender, new Object[0]);
            Set<String> groups = ((Permissions)this.get_module()).storage_player_groups.get(offline_player.getUniqueId());
            if (groups == null) {
                this.lang_list_empty.send(sender, new Object[0]);
            } else {
                for (String group : groups) {
                    this.list_permissions_for_group_no_header(sender, group);
                }
            }
        } else {
            Set effective_permissions = player.getEffectivePermissions();
            if (effective_permissions.isEmpty()) {
                this.lang_list_empty.send(sender, new Object[0]);
            } else {
                player.getEffectivePermissions().stream().sorted((a, b) -> a.getPermission().compareTo(b.getPermission())).forEach(att -> {
                    org.bukkit.permissions.Permission perm = ((Permissions)this.get_module()).getServer().getPluginManager().getPermission(att.getPermission());
                    if (perm == null) {
                        ((Permissions)this.get_module()).log.warning("Encountered unregistered permission '" + att.getPermission() + "'");
                        return;
                    }
                    this.lang_list_permission.send(sender, new Object[]{"\u00a7d" + perm.getName(), this.permission_value_color_code(att.getValue()) + att.getValue(), perm.getDescription()});
                });
            }
        }
    }

    private void list_permissions_for_group_no_header(CommandSender sender, String group) {
        for (String p : ((Permissions)this.get_module()).permission_groups.getOrDefault(group, Collections.emptySet())) {
            org.bukkit.permissions.Permission perm = ((Permissions)this.get_module()).getServer().getPluginManager().getPermission(p);
            if (perm == null) {
                ((Permissions)this.get_module()).log.warning("Use of unregistered permission '" + p + "' might have unintended effects.");
                this.lang_list_permission.send(sender, new Object[]{"\u00a7d" + p, this.permission_value_color_code(true) + "true", ""});
                continue;
            }
            this.lang_list_permission.send(sender, new Object[]{"\u00a7d" + perm.getName(), this.permission_value_color_code(true) + "true", perm.getDescription()});
        }
    }

    private void list_permissions_for_group(CommandSender sender, String group) {
        this.lang_list_header_group_permissions.send(sender, new Object[]{"\u00a7b" + group});
        this.list_permissions_for_group_no_header(sender, group);
    }

    private void list_groups_for_player(CommandSender sender, OfflinePlayer offline_player) {
        Set<String> set = ((Permissions)this.get_module()).storage_player_groups.get(offline_player.getUniqueId());
        if (set == null) {
            this.lang_list_empty.send(sender, new Object[0]);
        } else {
            this.lang_list_header_player_groups.send(sender, new Object[]{"\u00a7b" + offline_player.getName()});
            for (String group : set) {
                this.lang_list_group.send(sender, new Object[]{group});
            }
        }
    }

    private void add_player_to_group(CommandSender sender, OfflinePlayer player, String group) {
        if (((Permissions)this.get_module()).add_player_to_group(player, group)) {
            this.lang_group_assigned.send(sender, new Object[]{"\u00a7b" + player.getName(), "\u00a7a" + group});
        } else {
            this.lang_group_already_assigned.send(sender, new Object[]{"\u00a7b" + player.getName(), "\u00a7a" + group});
        }
    }

    private void remove_player_from_group(CommandSender sender, OfflinePlayer player, String group) {
        if (((Permissions)this.get_module()).remove_player_from_group(player, group)) {
            this.lang_group_removed.send(sender, new Object[]{"\u00a7b" + player.getName(), "\u00a7a" + group});
        } else {
            this.lang_group_not_assigned.send(sender, new Object[]{"\u00a7b" + player.getName(), "\u00a7a" + group});
        }
    }
}

