/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.permissions.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.oddlama.vane.annotation.command.Name;
import org.oddlama.vane.annotation.config.ConfigString;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.annotation.persistent.Persistent;
import org.oddlama.vane.core.command.Command;
import org.oddlama.vane.core.command.argumentType.OfflinePlayerArgumentType;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.permissions.Permissions;

@Name(value="vouch")
public class Vouch
extends Command<Permissions> {
    @LangMessage
    private TranslatedMessage lang_vouched;
    @LangMessage
    private TranslatedMessage lang_already_vouched;
    @ConfigString(def="user", desc="The group to assign to players when someone vouches for them.", metrics=true)
    private String config_vouch_group;
    @Persistent
    public Map<UUID, Set<UUID>> storage_vouched_by = new HashMap<UUID, Set<UUID>>();

    public Vouch(Context<Permissions> context) {
        super(context);
    }

    public LiteralArgumentBuilder<CommandSourceStack> get_command_base() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)super.get_command_base().then((ArgumentBuilder)this.help())).then(Commands.argument((String)"offline_player", (ArgumentType)OfflinePlayerArgumentType.offlinePlayer()).executes(ctx -> {
            this.vouch_for_player((Player)((CommandSourceStack)ctx.getSource()).getSender(), (OfflinePlayer)ctx.getArgument("offline_player", OfflinePlayer.class));
            return 1;
        }));
    }

    private void vouch_for_player(Player sender, OfflinePlayer vouched_player) {
        Set vouched_by_set = this.storage_vouched_by.computeIfAbsent(vouched_player.getUniqueId(), k -> new HashSet());
        if (vouched_by_set.add(sender.getUniqueId())) {
            if (vouched_by_set.size() == 1) {
                ((Permissions)this.get_module()).add_player_to_group(vouched_player, this.config_vouch_group);
            }
            this.lang_vouched.send((CommandSender)sender, new Object[]{"\u00a7b" + vouched_player.getName()});
        } else {
            this.lang_already_vouched.send((CommandSender)sender, new Object[]{"\u00a7b" + vouched_player.getName()});
        }
        this.mark_persistent_storage_dirty();
    }
}

