/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.regions;

import java.util.UUID;
import org.bukkit.plugin.Plugin;
import org.oddlama.vane.annotation.config.ConfigBoolean;
import org.oddlama.vane.annotation.config.ConfigDouble;
import org.oddlama.vane.annotation.config.ConfigInt;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.ModuleComponent;
import org.oddlama.vane.regions.RegionBlueMapLayerDelegate;
import org.oddlama.vane.regions.Regions;
import org.oddlama.vane.regions.region.Region;

public class RegionBlueMapLayer
extends ModuleComponent<Regions> {
    @ConfigBoolean(def=false, desc="If the marker set should be hidden by default.")
    public boolean config_hide_by_default;
    @ConfigBoolean(def=true, desc="Set to false to make the area markers visible through terrain and other objects.")
    public boolean config_depth_test;
    @ConfigInt(def=2, min=1, desc="Area marker line width.")
    public int config_line_width;
    @ConfigInt(def=16757794, min=0, max=0xFFFFFF, desc="Area marker fill color (0xRRGGBB).")
    public int config_fill_color;
    @ConfigDouble(def=0.1, min=0.0, max=1.0, desc="Area marker fill opacity.")
    public double config_fill_opacity;
    @ConfigInt(def=16757794, min=0, max=0xFFFFFF, desc="Area marker line color (0xRRGGBB).")
    public int config_line_color;
    @ConfigDouble(def=1.0, min=0.0, max=1.0, desc="Area marker line opacity.")
    public double config_line_opacity;
    @LangMessage
    public TranslatedMessage lang_layer_label;
    @LangMessage
    public TranslatedMessage lang_marker_label;
    private RegionBlueMapLayerDelegate delegate = null;

    public RegionBlueMapLayer(Context<Regions> context) {
        super((Context)context.group("blue_map", "Enable BlueMap integration."));
    }

    public void delayed_on_enable() {
        Plugin plugin = ((Regions)this.get_module()).getServer().getPluginManager().getPlugin("BlueMap");
        if (plugin == null) {
            return;
        }
        this.delegate = new RegionBlueMapLayerDelegate(this);
        this.delegate.on_enable(plugin);
    }

    public void on_enable() {
        this.schedule_next_tick(this::delayed_on_enable);
    }

    public void on_disable() {
        if (this.delegate != null) {
            this.delegate.on_disable();
            this.delegate = null;
        }
    }

    public void update_marker(Region region) {
        if (this.delegate != null) {
            this.delegate.update_marker(region);
        }
    }

    public void remove_marker(UUID region_id) {
        if (this.delegate != null) {
            this.delegate.remove_marker(region_id);
        }
    }

    public void update_all_markers() {
        if (this.delegate != null) {
            this.delegate.update_all_markers();
        }
    }
}

