/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.regions;

import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.markers.ExtrudeMarker;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.api.math.Color;
import de.bluecolored.bluemap.api.math.Shape;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;
import org.oddlama.vane.regions.RegionBlueMapLayer;
import org.oddlama.vane.regions.Regions;
import org.oddlama.vane.regions.region.Region;

public class RegionBlueMapLayerDelegate {
    public static final String MARKER_SET_ID = "vane_regions.regions";
    private final RegionBlueMapLayer parent;
    private boolean bluemap_enabled = false;
    private final HashMap<UUID, MarkerSet> marker_sets = new HashMap();

    public RegionBlueMapLayerDelegate(RegionBlueMapLayer parent) {
        this.parent = parent;
    }

    public Regions get_module() {
        return (Regions)this.parent.get_module();
    }

    public void on_enable(Plugin plugin) {
        BlueMapAPI.onEnable(api -> {
            this.get_module().log.info("Enabling BlueMap integration");
            this.bluemap_enabled = true;
            for (World world : this.get_module().getServer().getWorlds()) {
                this.create_marker_set((BlueMapAPI)api, world);
            }
            this.update_all_markers();
        });
    }

    public void on_disable() {
        if (!this.bluemap_enabled) {
            return;
        }
        this.get_module().log.info("Disabling BlueMap integration");
        this.bluemap_enabled = false;
    }

    private void create_marker_set(BlueMapAPI api, World world) {
        if (this.marker_sets.containsKey(world.getUID())) {
            return;
        }
        MarkerSet marker_set = MarkerSet.builder().label(this.parent.lang_layer_label.str(new Object[0])).toggleable(Boolean.valueOf(true)).defaultHidden(Boolean.valueOf(this.parent.config_hide_by_default)).build();
        api.getWorld((Object)world).ifPresent(bm_world -> {
            for (BlueMapMap map : bm_world.getMaps()) {
                map.getMarkerSets().put(MARKER_SET_ID, marker_set);
            }
        });
        this.marker_sets.put(world.getUID(), marker_set);
    }

    public void update_marker(Region region) {
        this.remove_marker(region.id());
        Block min = region.extent().min();
        Block max = region.extent().max();
        Shape shape = Shape.createRect((double)min.getX(), (double)min.getZ(), (double)(max.getX() + 1), (double)(max.getZ() + 1));
        ExtrudeMarker marker = ((ExtrudeMarker.Builder)ExtrudeMarker.builder().shape(shape, (float)min.getY(), (float)(max.getY() + 1)).label(this.parent.lang_marker_label.str(new Object[]{region.name()}))).lineWidth(this.parent.config_line_width).lineColor(new Color(this.parent.config_line_color, (float)this.parent.config_line_opacity)).fillColor(new Color(this.parent.config_fill_color, (float)this.parent.config_fill_opacity)).depthTestEnabled(this.parent.config_depth_test).centerPosition().build();
        this.marker_sets.get(min.getWorld().getUID()).getMarkers().put(region.id().toString(), marker);
    }

    public void remove_marker(UUID region_id) {
        for (MarkerSet marker_set : this.marker_sets.values()) {
            marker_set.getMarkers().remove(region_id.toString());
        }
    }

    public void update_all_markers() {
        for (Region region : this.get_module().all_regions()) {
            this.update_marker(region);
        }
    }
}

