/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.regions;

import java.util.HashSet;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;
import org.dynmap.DynmapCommonAPI;
import org.dynmap.DynmapCommonAPIListener;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.Marker;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerSet;
import org.oddlama.vane.regions.RegionDynmapLayer;
import org.oddlama.vane.regions.Regions;
import org.oddlama.vane.regions.region.Region;

public class RegionDynmapLayerDelegate {
    private final RegionDynmapLayer parent;
    private DynmapCommonAPI dynmap_api = null;
    private MarkerAPI marker_api = null;
    private boolean dynmap_enabled = false;
    private MarkerSet marker_set = null;

    public RegionDynmapLayerDelegate(RegionDynmapLayer parent) {
        this.parent = parent;
    }

    public Regions get_module() {
        return (Regions)this.parent.get_module();
    }

    public void on_enable(Plugin plugin) {
        try {
            DynmapCommonAPIListener.register((DynmapCommonAPIListener)new DynmapCommonAPIListener(){

                public void apiEnabled(DynmapCommonAPI api) {
                    RegionDynmapLayerDelegate.this.dynmap_api = api;
                    RegionDynmapLayerDelegate.this.marker_api = RegionDynmapLayerDelegate.this.dynmap_api.getMarkerAPI();
                }
            });
        }
        catch (Exception e) {
            this.get_module().log.log(Level.WARNING, "Error while enabling dynmap integration!", e);
            return;
        }
        if (this.marker_api == null) {
            return;
        }
        this.get_module().log.info("Enabling dynmap integration");
        this.dynmap_enabled = true;
        this.create_or_load_layer();
    }

    public void on_disable() {
        if (!this.dynmap_enabled) {
            return;
        }
        this.get_module().log.info("Disabling dynmap integration");
        this.dynmap_enabled = false;
        this.dynmap_api = null;
        this.marker_api = null;
    }

    private void create_or_load_layer() {
        this.marker_set = this.marker_api.getMarkerSet("vane_regions.regions");
        if (this.marker_set == null) {
            this.marker_set = this.marker_api.createMarkerSet("vane_regions.regions", this.parent.lang_layer_label.str(new Object[0]), null, false);
        }
        if (this.marker_set == null) {
            this.get_module().log.severe("Failed to create dynmap region marker set!");
            return;
        }
        this.marker_set.setMarkerSetLabel(this.parent.lang_layer_label.str(new Object[0]));
        this.marker_set.setLayerPriority(this.parent.config_layer_priority);
        this.marker_set.setHideByDefault(this.parent.config_layer_hide);
        this.update_all_markers();
    }

    private String id_for(UUID region_id) {
        return region_id.toString();
    }

    private String id_for(Region region) {
        return this.id_for(region.id());
    }

    public void update_marker(Region region) {
        if (!this.dynmap_enabled) {
            return;
        }
        this.remove_marker(region.id());
        Block min = region.extent().min();
        Block max = region.extent().max();
        String world_name = min.getWorld().getName();
        String marker_id = this.id_for(region);
        String marker_label = this.parent.lang_marker_label.str(new Object[]{region.name()});
        double[] xs = new double[]{min.getX(), max.getX() + 1};
        double[] zs = new double[]{min.getZ(), max.getZ() + 1};
        AreaMarker area = this.marker_set.createAreaMarker(marker_id, marker_label, false, world_name, xs, zs, false);
        area.setRangeY((double)(max.getY() + 1), (double)min.getY());
        area.setLineStyle(this.parent.config_line_weight, this.parent.config_line_opacity, this.parent.config_line_color);
        area.setFillStyle(this.parent.config_fill_opacity, this.parent.config_fill_color);
    }

    public void remove_marker(UUID region_id) {
        this.remove_marker(this.id_for(region_id));
    }

    public void remove_marker(String marker_id) {
        if (!this.dynmap_enabled || marker_id == null) {
            return;
        }
        this.remove_marker(this.marker_set.findMarker(marker_id));
    }

    public void remove_marker(Marker marker) {
        if (!this.dynmap_enabled || marker == null) {
            return;
        }
        marker.deleteMarker();
    }

    public void update_all_markers() {
        if (!this.dynmap_enabled) {
            return;
        }
        HashSet<String> id_set = new HashSet<String>();
        for (Region region : this.get_module().all_regions()) {
            id_set.add(this.id_for(region));
            this.update_marker(region);
        }
        for (Marker marker : this.marker_set.getMarkers()) {
            String id = marker.getMarkerID();
            if (id == null || id_set.contains(id)) continue;
            this.remove_marker(marker);
        }
    }
}

