/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.regions;

import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.oddlama.vane.regions.Regions;

public class RegionEconomyDelegate {
    public Regions parent;
    public Economy economy;

    public RegionEconomyDelegate(Regions parent) {
        this.parent = parent;
    }

    public Regions get_module() {
        return this.parent;
    }

    public boolean setup(Plugin plugin) {
        RegisteredServiceProvider rsp = this.get_module().getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            this.get_module().log.severe("Economy was selected as the currency provider, but no Economy service provider is registered via VaultAPI! Falling back to material currency.");
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        return true;
    }

    public boolean has(OfflinePlayer player, double amount) {
        return this.economy.has(player, amount);
    }

    public EconomyResponse withdraw(OfflinePlayer player, double amount) {
        return this.economy.withdrawPlayer(player, amount);
    }

    public EconomyResponse deposit(OfflinePlayer player, double amount) {
        return this.economy.depositPlayer(player, amount);
    }

    public String currency_name_plural() {
        return this.economy.currencyNamePlural();
    }

    public int fractionalDigits() {
        return this.economy.fractionalDigits();
    }
}

