/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.regions;

import java.io.Serializable;
import org.bukkit.plugin.Plugin;
import org.oddlama.vane.core.functional.Function2;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.portals.Portals;
import org.oddlama.vane.regions.Regions;
import org.oddlama.vane.regions.event.RegionPortalRoleSettingEnforcer;
import org.oddlama.vane.regions.region.Region;
import org.oddlama.vane.regions.region.RegionGroup;
import org.oddlama.vane.regions.region.RoleSetting;

public class RegionPortalIntegration {
    public RegionPortalIntegration(Regions context, Plugin portals_plugin) {
        new RegionPortalRoleSettingEnforcer((Context<Regions>)context);
        if (portals_plugin instanceof Portals) {
            Portals portals = (Portals)portals_plugin;
            portals.set_is_in_same_region_group_callback((Function2 & Serializable)(a, b) -> {
                Region reg_a = context.region_at(a.spawn());
                Region reg_b = context.region_at(b.spawn());
                if (reg_a == null || reg_b == null) {
                    return reg_a == reg_b;
                }
                return reg_a.region_group_id().equals(reg_b.region_group_id());
            });
            portals.set_player_can_use_portals_in_region_group_of_callback((Function2 & Serializable)(player, portal) -> {
                Region region = context.region_at(portal.spawn());
                if (region == null) {
                    return true;
                }
                RegionGroup group = region.region_group((Regions)context.get_module());
                return group.get_role(player.getUniqueId()).get_setting(RoleSetting.PORTAL);
            });
        }
    }
}

