/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.regions;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.milkbowl.vault.economy.EconomyResponse;
import net.minecraft.core.BlockPos;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.oddlama.vane.annotation.VaneModule;
import org.oddlama.vane.annotation.config.ConfigBoolean;
import org.oddlama.vane.annotation.config.ConfigDouble;
import org.oddlama.vane.annotation.config.ConfigInt;
import org.oddlama.vane.annotation.config.ConfigMaterial;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.annotation.persistent.Persistent;
import org.oddlama.vane.core.functional.Consumer2;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.Module;
import org.oddlama.vane.core.persistent.PersistentSerializer;
import org.oddlama.vane.external.apache.commons.lang3.StringUtils;
import org.oddlama.vane.external.json.JSONObject;
import org.oddlama.vane.regions.RegionBlueMapLayer;
import org.oddlama.vane.regions.RegionDynmapLayer;
import org.oddlama.vane.regions.RegionEconomyDelegate;
import org.oddlama.vane.regions.RegionGlobalEnvironmentOverrides;
import org.oddlama.vane.regions.RegionGlobalRoleOverrides;
import org.oddlama.vane.regions.RegionPortalIntegration;
import org.oddlama.vane.regions.commands.Region;
import org.oddlama.vane.regions.event.RegionEnvironmentSettingEnforcer;
import org.oddlama.vane.regions.event.RegionRoleSettingEnforcer;
import org.oddlama.vane.regions.event.RegionSelectionListener;
import org.oddlama.vane.regions.menu.RegionGroupMenuTag;
import org.oddlama.vane.regions.menu.RegionMenuGroup;
import org.oddlama.vane.regions.menu.RegionMenuTag;
import org.oddlama.vane.regions.region.EnvironmentSetting;
import org.oddlama.vane.regions.region.RegionExtent;
import org.oddlama.vane.regions.region.RegionGroup;
import org.oddlama.vane.regions.region.RegionSelection;
import org.oddlama.vane.regions.region.Role;
import org.oddlama.vane.regions.region.RoleSetting;
import org.oddlama.vane.util.PlayerUtil;
import org.oddlama.vane.util.StorageUtil;

@VaneModule(name="regions", bstats=8643, config_version=4L, lang_version=3L, storage_version=1L)
public class Regions
extends Module<Regions> {
    @ConfigInt(def=4, min=1, desc="Minimum region extent in x direction.")
    public int config_min_region_extent_x;
    @ConfigInt(def=4, min=1, desc="Minimum region extent in y direction.")
    public int config_min_region_extent_y;
    @ConfigInt(def=4, min=1, desc="Minimum region extent in z direction.")
    public int config_min_region_extent_z;
    @ConfigInt(def=2048, min=1, desc="Maximum region extent in x direction.")
    public int config_max_region_extent_x;
    @ConfigInt(def=2048, min=1, desc="Maximum region extent in y direction.")
    public int config_max_region_extent_y;
    @ConfigInt(def=2048, min=1, desc="Maximum region extent in z direction.")
    public int config_max_region_extent_z;
    @ConfigBoolean(def=false, desc="Use economy via VaultAPI as currency provider.")
    public boolean config_economy_as_currency;
    @ConfigBoolean(def=false, desc="Enable this to prevent players without the container permission from being able to view chests.")
    public boolean config_prohibit_viewing_containers;
    @ConfigInt(def=0, min=-1, desc="The amount of decimal places the costs will be rounded to. If set to -1, it will round to the amount of decimal places specified by your economy plugin. If set to 0, costs will simply be rounded up to the nearest integer.")
    public int config_economy_decimal_places;
    @ConfigMaterial(def=Material.DIAMOND, desc="The currency material for regions. The alternative option to an economy plugin.")
    public Material config_currency;
    @ConfigDouble(def=2.0, min=0.0, desc="The base amount of currency required to buy an area equal to one chunk (256 blocks).")
    public double config_cost_xz_base;
    @ConfigDouble(def=1.15, min=1.0, desc="The multiplicator determines how much the cost increases for each additional 16 blocks of height. A region of height h will cost multiplicator^(h / 16.0) * base_amount. Rounding is applied at the end.")
    public double config_cost_y_multiplicator;
    @Persistent
    private Map<UUID, org.oddlama.vane.regions.region.Region> storage_regions = new HashMap<UUID, org.oddlama.vane.regions.region.Region>();
    private Map<UUID, org.oddlama.vane.regions.region.Region> regions = new HashMap<UUID, org.oddlama.vane.regions.region.Region>();
    @Persistent
    private Map<UUID, RegionGroup> storage_region_groups = new HashMap<UUID, RegionGroup>();
    @Persistent
    private Map<UUID, UUID> storage_default_region_group = new HashMap<UUID, UUID>();
    private Map<UUID, Map<Long, List<org.oddlama.vane.regions.region.Region>>> regions_in_chunk_in_world = new HashMap<UUID, Map<Long, List<org.oddlama.vane.regions.region.Region>>>();
    private Map<UUID, RegionSelection> region_selections = new HashMap<UUID, RegionSelection>();
    @LangMessage
    public TranslatedMessage lang_start_region_selection;
    public final Permission admin_permission;
    public RegionMenuGroup menus = new RegionMenuGroup((Context<Regions>)this);
    public RegionDynmapLayer dynmap_layer;
    public RegionBlueMapLayer blue_map_layer;
    public RegionEconomyDelegate economy;
    public boolean vane_portals_available = false;
    public static RegionGlobalRoleOverrides role_overrides;
    public static RegionGlobalEnvironmentOverrides environment_overrides;
    private static final int visualize_max_particles = 20000;
    private static final int visualize_particles_per_block = 12;
    private static final double visualize_stddev_compensation = 0.25;
    private static final Particle.DustOptions visualize_dust_invalid;
    private static final Particle.DustOptions visualize_dust_valid;
    public static final NamespacedKey STORAGE_REGIONS;

    public Regions() {
        role_overrides = new RegionGlobalRoleOverrides((Context<Regions>)this);
        environment_overrides = new RegionGlobalEnvironmentOverrides((Context<Regions>)this);
        new Region((Context<Regions>)this);
        new RegionEnvironmentSettingEnforcer((Context<Regions>)this);
        new RegionRoleSettingEnforcer((Context<Regions>)this);
        new RegionSelectionListener((Context<Regions>)this);
        this.dynmap_layer = new RegionDynmapLayer((Context<Regions>)this);
        this.blue_map_layer = new RegionBlueMapLayer((Context<Regions>)this);
        this.admin_permission = new Permission("vane." + ((Regions)this.get_module()).get_name() + ".admin", "Allows administration of any region", PermissionDefault.OP);
        ((Regions)this.get_module()).register_permission(this.admin_permission);
    }

    public void delayed_on_enable() {
        if (this.config_economy_as_currency && !this.setup_economy()) {
            this.config_economy_as_currency = false;
        }
    }

    private boolean setup_economy() {
        ((Regions)this.get_module()).log.info("Enabling economy integration");
        Plugin vault_api_plugin = ((Regions)this.get_module()).getServer().getPluginManager().getPlugin("Vault");
        if (vault_api_plugin == null) {
            ((Regions)this.get_module()).log.severe("Economy was selected as the currency provider, but the Vault plugin wasn't found! Falling back to material currency.");
            return false;
        }
        this.economy = new RegionEconomyDelegate(this);
        return this.economy.setup(vault_api_plugin);
    }

    public void on_enable() {
        Plugin portals_plugin = ((Regions)this.get_module()).getServer().getPluginManager().getPlugin("vane-portals");
        if (portals_plugin != null) {
            new RegionPortalIntegration(this, portals_plugin);
            this.vane_portals_available = true;
        }
        this.schedule_next_tick(this::delayed_on_enable);
        this.schedule_task_timer(this::visualize_selections, 1L, 20L);
    }

    public Collection<org.oddlama.vane.regions.region.Region> all_regions() {
        return this.regions.values().stream().filter(p -> this.getServer().getWorld(p.extent().world()) != null).collect(Collectors.toList());
    }

    public Collection<RegionGroup> all_region_groups() {
        return this.storage_region_groups.values();
    }

    public void start_region_selection(Player player) {
        this.region_selections.put(player.getUniqueId(), new RegionSelection(this));
        this.lang_start_region_selection.send((CommandSender)player, new Object[0]);
    }

    public void cancel_region_selection(Player player) {
        this.region_selections.remove(player.getUniqueId());
    }

    public boolean is_selecting_region(Player player) {
        return this.region_selections.containsKey(player.getUniqueId());
    }

    public RegionSelection get_region_selection(Player player) {
        return this.region_selections.get(player.getUniqueId());
    }

    private void visualize_edge(World world, BlockPos c1, BlockPos c2, boolean valid) {
        double mx = (double)(c1.getX() + c2.getX()) / 2.0 + 0.5;
        double my = (double)(c1.getY() + c2.getY()) / 2.0 + 0.5;
        double mz = (double)(c1.getZ() + c2.getZ()) / 2.0 + 0.5;
        double dx = Math.abs(c1.getX() - c2.getX());
        double dy = Math.abs(c1.getY() - c2.getY());
        double dz = Math.abs(c1.getZ() - c2.getZ());
        double len = dx + dy + dz;
        int count = Math.min(20000, (int)(12.0 * len));
        world.spawnParticle(Particle.END_ROD, mx, my, mz, count, dx *= 0.25, dy *= 0.25, dz *= 0.25, 0.0, null, true);
        world.spawnParticle(Particle.DUST, mx, my, mz, count, dx, dy, dz, 0.0, (Object)(valid ? visualize_dust_valid : visualize_dust_invalid), true);
    }

    private void visualize_selections() {
        for (UUID selection_owner : this.region_selections.keySet()) {
            OfflinePlayer offline_player;
            RegionSelection selection = this.region_selections.get(selection_owner);
            if (selection == null || !(offline_player = this.getServer().getOfflinePlayer(selection_owner)).isOnline()) continue;
            Player player = offline_player.getPlayer();
            if (selection.primary == null || selection.secondary == null || !selection.primary.getWorld().equals((Object)selection.secondary.getWorld())) continue;
            World world = selection.primary.getWorld();
            boolean valid = selection.is_valid(player);
            int lx = Math.min(selection.primary.getX(), selection.secondary.getX());
            int ly = Math.min(selection.primary.getY(), selection.secondary.getY());
            int lz = Math.min(selection.primary.getZ(), selection.secondary.getZ());
            int hx = Math.max(selection.primary.getX(), selection.secondary.getX());
            int hy = Math.max(selection.primary.getY(), selection.secondary.getY());
            int hz = Math.max(selection.primary.getZ(), selection.secondary.getZ());
            BlockPos A = new BlockPos(lx, ly, lz);
            BlockPos B = new BlockPos(hx, ly, lz);
            BlockPos C = new BlockPos(hx, hy, lz);
            BlockPos D = new BlockPos(lx, hy, lz);
            BlockPos E = new BlockPos(lx, ly, hz);
            BlockPos F = new BlockPos(hx, ly, hz);
            BlockPos G = new BlockPos(hx, hy, hz);
            BlockPos H = new BlockPos(lx, hy, hz);
            this.visualize_edge(world, A, B, valid);
            this.visualize_edge(world, B, C, valid);
            this.visualize_edge(world, C, D, valid);
            this.visualize_edge(world, D, A, valid);
            this.visualize_edge(world, E, F, valid);
            this.visualize_edge(world, F, G, valid);
            this.visualize_edge(world, G, H, valid);
            this.visualize_edge(world, H, E, valid);
            this.visualize_edge(world, A, E, valid);
            this.visualize_edge(world, B, F, valid);
            this.visualize_edge(world, C, G, valid);
            this.visualize_edge(world, D, H, valid);
        }
    }

    public void add_region_group(RegionGroup group) {
        this.storage_region_groups.put(group.id(), group);
        this.mark_persistent_storage_dirty();
    }

    public boolean can_remove_region_group(RegionGroup group) {
        if (this.storage_default_region_group.containsValue(group.id())) {
            return false;
        }
        return this.regions.values().stream().noneMatch(r -> r.region_group_id().equals(group.id()));
    }

    public void remove_region_group(RegionGroup group) {
        if (!this.can_remove_region_group(group)) {
            return;
        }
        if (this.storage_region_groups.remove(group.id()) == null) {
            return;
        }
        this.mark_persistent_storage_dirty();
        ((Regions)this.get_module()).core.menu_manager.for_each_open((Consumer2 & Serializable)(player, menu) -> {
            if (menu.tag() instanceof RegionGroupMenuTag && Objects.equals(((RegionGroupMenuTag)menu.tag()).region_group_id(), group.id())) {
                menu.taint();
                menu.close(player);
            }
        });
    }

    public RegionGroup get_region_group(UUID region_group) {
        return this.storage_region_groups.get(region_group);
    }

    public boolean create_region_from_selection(Player player, String name) {
        RegionSelection selection = this.get_region_selection(player);
        if (!selection.is_valid(player)) {
            return false;
        }
        double price = selection.price();
        if (this.config_economy_as_currency) {
            EconomyResponse transaction;
            if (price > 0.0 && !(transaction = this.economy.withdraw((OfflinePlayer)player, price)).transactionSuccess()) {
                this.log.warning("Player " + String.valueOf(player) + " tried to create region '" + name + "' (cost " + price + ") but the economy plugin failed to withdraw:");
                this.log.warning("Error message: " + transaction.errorMessage);
                return false;
            }
        } else {
            HashMap<ItemStack, Integer> map = new HashMap<ItemStack, Integer>();
            map.put(new ItemStack(this.config_currency), (int)price);
            if (price > 0.0 && !PlayerUtil.take_items((Player)player, map)) {
                return false;
            }
        }
        RegionGroup def_region_group = this.get_or_create_default_region_group(player);
        org.oddlama.vane.regions.region.Region region = new org.oddlama.vane.regions.region.Region(name, player.getUniqueId(), selection.extent(), def_region_group.id());
        this.add_new_region(region);
        this.cancel_region_selection(player);
        return true;
    }

    public String currency_string() {
        if (this.config_economy_as_currency) {
            return this.economy.currency_name_plural();
        }
        return String.valueOf(this.config_currency).toLowerCase();
    }

    public void add_new_region(org.oddlama.vane.regions.region.Region region) {
        region.invalidated = true;
        this.index_region(region);
    }

    public void remove_region(org.oddlama.vane.regions.region.Region region) {
        if (this.regions.remove(region.id()) == null) {
            return;
        }
        this.update_persistent_data();
        ((Regions)this.get_module()).core.menu_manager.for_each_open((Consumer2 & Serializable)(player, menu) -> {
            if (menu.tag() instanceof RegionMenuTag && Objects.equals(((RegionMenuTag)menu.tag()).region_id(), region.id())) {
                menu.taint();
                menu.close(player);
            }
        });
        this.index_remove_region(region);
        this.remove_marker(region.id());
    }

    public void update_marker(org.oddlama.vane.regions.region.Region region) {
        this.dynmap_layer.update_marker(region);
        this.blue_map_layer.update_marker(region);
    }

    public void remove_marker(UUID region_id) {
        this.dynmap_layer.remove_marker(region_id);
        this.blue_map_layer.remove_marker(region_id);
    }

    private void index_region(org.oddlama.vane.regions.region.Region region) {
        this.regions.put(region.id(), region);
        Block min = region.extent().min();
        Block max = region.extent().max();
        UUID world_id = min.getWorld().getUID();
        Map regions_in_chunk = this.regions_in_chunk_in_world.computeIfAbsent(world_id, k -> new HashMap());
        Chunk min_chunk = min.getChunk();
        Chunk max_chunk = max.getChunk();
        for (int cx = min_chunk.getX(); cx <= max_chunk.getX(); ++cx) {
            for (int cz = min_chunk.getZ(); cz <= max_chunk.getZ(); ++cz) {
                long chunk_key = Chunk.getChunkKey((int)cx, (int)cz);
                List possible_regions = regions_in_chunk.computeIfAbsent(chunk_key, k -> new ArrayList());
                possible_regions.add(region);
            }
        }
        this.update_marker(region);
    }

    private void index_remove_region(org.oddlama.vane.regions.region.Region region) {
        Block min = region.extent().min();
        Block max = region.extent().max();
        UUID world_id = min.getWorld().getUID();
        Map<Long, List<org.oddlama.vane.regions.region.Region>> regions_in_chunk = this.regions_in_chunk_in_world.get(world_id);
        if (regions_in_chunk == null) {
            return;
        }
        Chunk min_chunk = min.getChunk();
        Chunk max_chunk = max.getChunk();
        for (int cx = min_chunk.getX(); cx <= max_chunk.getX(); ++cx) {
            for (int cz = min_chunk.getZ(); cz <= max_chunk.getZ(); ++cz) {
                long chunk_key = Chunk.getChunkKey((int)cx, (int)cz);
                List<org.oddlama.vane.regions.region.Region> possible_regions = regions_in_chunk.get(chunk_key);
                if (possible_regions == null) continue;
                possible_regions.remove(region);
            }
        }
    }

    public org.oddlama.vane.regions.region.Region region_at(Location loc) {
        UUID world_id = loc.getWorld().getUID();
        Map<Long, List<org.oddlama.vane.regions.region.Region>> regions_in_chunk = this.regions_in_chunk_in_world.get(world_id);
        if (regions_in_chunk == null) {
            return null;
        }
        long chunk_key = loc.getChunk().getChunkKey();
        List<org.oddlama.vane.regions.region.Region> possible_regions = regions_in_chunk.get(chunk_key);
        if (possible_regions == null) {
            return null;
        }
        for (org.oddlama.vane.regions.region.Region region : possible_regions) {
            if (!region.extent().is_inside(loc)) continue;
            return region;
        }
        return null;
    }

    public org.oddlama.vane.regions.region.Region region_at(Block block) {
        UUID world_id = block.getWorld().getUID();
        Map<Long, List<org.oddlama.vane.regions.region.Region>> regions_in_chunk = this.regions_in_chunk_in_world.get(world_id);
        if (regions_in_chunk == null) {
            return null;
        }
        long chunk_key = block.getChunk().getChunkKey();
        List<org.oddlama.vane.regions.region.Region> possible_regions = regions_in_chunk.get(chunk_key);
        if (possible_regions == null) {
            return null;
        }
        for (org.oddlama.vane.regions.region.Region region : possible_regions) {
            if (!region.extent().is_inside(block)) continue;
            return region;
        }
        return null;
    }

    public boolean may_administrate(Player player, RegionGroup group) {
        return player.getUniqueId().equals(group.owner()) || group != null && group.get_role(player.getUniqueId()).get_setting(RoleSetting.ADMIN);
    }

    public boolean may_administrate(Player player, org.oddlama.vane.regions.region.Region region) {
        return player.getUniqueId().equals(region.owner()) || player.hasPermission(this.admin_permission);
    }

    public RegionGroup get_or_create_default_region_group(Player owner) {
        UUID owner_id = owner.getUniqueId();
        UUID region_group_id = this.storage_default_region_group.get(owner_id);
        if (region_group_id != null) {
            return this.get_region_group(region_group_id);
        }
        RegionGroup region_group = new RegionGroup("[default] " + owner.getName(), owner_id);
        this.add_region_group(region_group);
        this.storage_default_region_group.put(owner_id, region_group.id());
        this.mark_persistent_storage_dirty();
        return region_group;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on_player_quit(PlayerQuitEvent event) {
        this.cancel_region_selection(event.getPlayer());
    }

    @EventHandler
    public void on_save_world(WorldSaveEvent event) {
        this.update_persistent_data(event.getWorld());
    }

    @EventHandler
    public void on_load_world(WorldLoadEvent event) {
        this.load_persistent_data(event.getWorld());
    }

    @EventHandler
    public void on_unload_world(WorldUnloadEvent event) {
        this.update_persistent_data(event.getWorld());
    }

    public void load_persistent_data(World world) {
        PersistentDataContainer data = world.getPersistentDataContainer();
        String storage_region_prefix = String.valueOf(STORAGE_REGIONS) + ".";
        Set pdc_regions = data.getKeys().stream().filter(key -> key.toString().startsWith(storage_region_prefix)).map(key -> StringUtils.removeStart((String)key.toString(), (String)storage_region_prefix)).map(uuid -> UUID.fromString(uuid)).collect(Collectors.toSet());
        for (UUID region_id : pdc_regions) {
            byte[] json_bytes = (byte[])data.get(NamespacedKey.fromString((String)(storage_region_prefix + region_id.toString())), PersistentDataType.BYTE_ARRAY);
            try {
                org.oddlama.vane.regions.region.Region region = (org.oddlama.vane.regions.region.Region)PersistentSerializer.from_json(org.oddlama.vane.regions.region.Region.class, (Object)new JSONObject(new String(json_bytes)));
                this.index_region(region);
            }
            catch (IOException e) {
                this.log.log(Level.SEVERE, "error while serializing persistent data!", e);
            }
        }
        this.log.log(Level.INFO, "Loaded " + pdc_regions.size() + " regions for world " + world.getName() + "(" + String.valueOf(world.getUID()) + ")");
        HashSet<UUID> remove_from_legacy_storage = new HashSet<UUID>();
        int converted = 0;
        for (org.oddlama.vane.regions.region.Region region : this.storage_regions.values()) {
            if (!region.extent().world().equals(world.getUID())) continue;
            if (this.regions.containsKey(region.id())) {
                remove_from_legacy_storage.add(region.id());
                continue;
            }
            this.index_region(region);
            region.invalidated = true;
            ++converted;
        }
        remove_from_legacy_storage.forEach(this.storage_regions::remove);
        if (remove_from_legacy_storage.size() > 0) {
            this.mark_persistent_storage_dirty();
        }
        if (converted > 0) {
            this.update_persistent_data();
        }
    }

    public void update_persistent_data() {
        for (World world : this.getServer().getWorlds()) {
            this.update_persistent_data(world);
        }
    }

    public void update_persistent_data(World world) {
        PersistentDataContainer data = world.getPersistentDataContainer();
        String storage_region_prefix = String.valueOf(STORAGE_REGIONS) + ".";
        this.regions.values().stream().filter(x -> x.invalidated && x.extent().world().equals(world.getUID())).forEach(region -> {
            try {
                Object json = PersistentSerializer.to_json(org.oddlama.vane.regions.region.Region.class, (Object)region);
                data.set(NamespacedKey.fromString((String)(storage_region_prefix + region.id().toString())), PersistentDataType.BYTE_ARRAY, (Object)json.toString().getBytes());
            }
            catch (IOException e) {
                this.log.log(Level.SEVERE, "error while serializing persistent data!", e);
                return;
            }
            region.invalidated = false;
        });
        Set stored_regions = data.getKeys().stream().filter(key -> key.toString().startsWith(storage_region_prefix)).map(key -> StringUtils.removeStart((String)key.toString(), (String)storage_region_prefix)).map(uuid -> UUID.fromString(uuid)).collect(Collectors.toSet());
        Sets.difference(stored_regions, this.regions.keySet()).forEach(id -> data.remove(NamespacedKey.fromString((String)(storage_region_prefix + id.toString()))));
    }

    public void on_disable() {
        this.update_persistent_data();
        super.on_disable();
    }

    static {
        PersistentSerializer.serializers.put(EnvironmentSetting.class, x -> ((EnvironmentSetting)((Object)((Object)x))).name());
        PersistentSerializer.deserializers.put(EnvironmentSetting.class, x -> EnvironmentSetting.valueOf((String)x));
        PersistentSerializer.serializers.put(RoleSetting.class, x -> ((RoleSetting)((Object)((Object)x))).name());
        PersistentSerializer.deserializers.put(RoleSetting.class, x -> RoleSetting.valueOf((String)x));
        PersistentSerializer.serializers.put(Role.class, Role::serialize);
        PersistentSerializer.deserializers.put(Role.class, Role::deserialize);
        PersistentSerializer.serializers.put(Role.RoleType.class, x -> ((Role.RoleType)((Object)((Object)x))).name());
        PersistentSerializer.deserializers.put(Role.RoleType.class, x -> Role.RoleType.valueOf((String)x));
        PersistentSerializer.serializers.put(RegionGroup.class, RegionGroup::serialize);
        PersistentSerializer.deserializers.put(RegionGroup.class, RegionGroup::deserialize);
        PersistentSerializer.serializers.put(org.oddlama.vane.regions.region.Region.class, org.oddlama.vane.regions.region.Region::serialize);
        PersistentSerializer.deserializers.put(org.oddlama.vane.regions.region.Region.class, org.oddlama.vane.regions.region.Region::deserialize);
        PersistentSerializer.serializers.put(RegionExtent.class, RegionExtent::serialize);
        PersistentSerializer.deserializers.put(RegionExtent.class, RegionExtent::deserialize);
        role_overrides = null;
        environment_overrides = null;
        visualize_dust_invalid = new Particle.DustOptions(Color.fromRGB((int)230, (int)60, (int)11), 1.0f);
        visualize_dust_valid = new Particle.DustOptions(Color.fromRGB((int)120, (int)220, (int)60), 1.0f);
        STORAGE_REGIONS = StorageUtil.namespaced_key((String)"vane_regions", (String)"regions");
    }
}

