/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.regions.event;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.regions.Regions;
import org.oddlama.vane.regions.region.EnvironmentSetting;
import org.oddlama.vane.regions.region.Region;
import org.oddlama.vane.regions.region.RegionGroup;

public class RegionEnvironmentSettingEnforcer
extends Listener<Regions> {
    public RegionEnvironmentSettingEnforcer(Context<Regions> context) {
        super(context);
    }

    public boolean check_setting_at(Location location, EnvironmentSetting setting, boolean check_against) {
        Region region = ((Regions)this.get_module()).region_at(location);
        if (region == null) {
            return false;
        }
        RegionGroup group = region.region_group((Regions)this.get_module());
        return group.get_setting(setting) == check_against;
    }

    public boolean check_setting_at(Block block, EnvironmentSetting setting, boolean check_against) {
        Region region = ((Regions)this.get_module()).region_at(block);
        if (region == null) {
            return false;
        }
        RegionGroup group = region.region_group((Regions)this.get_module());
        return group.get_setting(setting) == check_against;
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_block_explode(BlockExplodeEvent event) {
        event.blockList().removeIf(block -> this.check_setting_at((Block)block, EnvironmentSetting.EXPLOSIONS, false));
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_entity_explode(EntityExplodeEvent event) {
        event.blockList().removeIf(block -> this.check_setting_at((Block)block, EnvironmentSetting.EXPLOSIONS, false));
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_entity_change_block(EntityChangeBlockEvent event) {
        if (!(event.getEntity() instanceof Monster)) {
            return;
        }
        if (this.check_setting_at(event.getBlock(), EnvironmentSetting.MONSTERS, false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_block_burn(BlockBurnEvent event) {
        if (this.check_setting_at(event.getBlock(), EnvironmentSetting.FIRE, false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_block_spread(BlockSpreadEvent event) {
        EnvironmentSetting setting;
        switch (event.getNewState().getType()) {
            default: {
                return;
            }
            case FIRE: {
                setting = EnvironmentSetting.FIRE;
                break;
            }
            case VINE: {
                setting = EnvironmentSetting.VINE_GROWTH;
            }
        }
        if (this.check_setting_at(event.getBlock(), setting, false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_creature_spawn(CreatureSpawnEvent event) {
        switch (event.getSpawnReason()) {
            case JOCKEY: 
            case MOUNT: 
            case NATURAL: {
                break;
            }
            default: {
                return;
            }
        }
        LivingEntity entity = event.getEntity();
        if (entity instanceof Monster) {
            if (this.check_setting_at(event.getLocation(), EnvironmentSetting.MONSTERS, false)) {
                event.setCancelled(true);
            }
        } else if (entity instanceof Animals && this.check_setting_at(event.getLocation(), EnvironmentSetting.ANIMALS, false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_entity_damage_by_entity(EntityDamageByEntityEvent event) {
        Player player_damager;
        Entity damaged = event.getEntity();
        Entity damager = event.getDamager();
        if (damaged.getType() != EntityType.PLAYER) {
            return;
        }
        Player player_damaged = (Player)damaged;
        if (damager instanceof Player) {
            player_damager = (Player)damager;
        } else if (damager instanceof Projectile && ((Projectile)damager).getShooter() instanceof Player) {
            player_damager = (Player)((Projectile)damager).getShooter();
        } else {
            return;
        }
        if (player_damager != null && player_damaged != player_damager && (this.check_setting_at(player_damaged.getLocation(), EnvironmentSetting.PVP, false) || this.check_setting_at(player_damager.getLocation(), EnvironmentSetting.PVP, false))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_hanging_break_event(HangingBreakEvent event) {
        switch (event.getCause()) {
            default: {
                return;
            }
            case ENTITY: {
                return;
            }
            case EXPLOSION: 
        }
        if (this.check_setting_at(event.getEntity().getLocation(), EnvironmentSetting.EXPLOSIONS, false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_player_interact(PlayerInteractEvent event) {
        if (event.getAction() != Action.PHYSICAL) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block != null && block.getType() == Material.FARMLAND && this.check_setting_at(block, EnvironmentSetting.TRAMPLE, false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_potion_splash(PotionSplashEvent event) {
        if (!(event.getEntity().getShooter() instanceof Player)) {
            return;
        }
        Player thrower = (Player)event.getEntity().getShooter();
        boolean source_pvp_restricted = this.check_setting_at(thrower.getLocation(), EnvironmentSetting.PVP, false);
        for (LivingEntity target : event.getAffectedEntities()) {
            if (!(target instanceof Player) || !source_pvp_restricted && !this.check_setting_at(target.getLocation(), EnvironmentSetting.PVP, false)) continue;
            event.setIntensity(target, 0.0);
            return;
        }
    }
}

