/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.regions.event;

import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.portals.event.PortalActivateEvent;
import org.oddlama.vane.portals.event.PortalChangeSettingsEvent;
import org.oddlama.vane.portals.event.PortalConstructEvent;
import org.oddlama.vane.portals.event.PortalDeactivateEvent;
import org.oddlama.vane.portals.event.PortalDestroyEvent;
import org.oddlama.vane.portals.event.PortalLinkConsoleEvent;
import org.oddlama.vane.portals.event.PortalOpenConsoleEvent;
import org.oddlama.vane.portals.event.PortalSelectTargetEvent;
import org.oddlama.vane.portals.event.PortalUnlinkConsoleEvent;
import org.oddlama.vane.regions.Regions;
import org.oddlama.vane.regions.region.Region;
import org.oddlama.vane.regions.region.RegionGroup;
import org.oddlama.vane.regions.region.RoleSetting;

public class RegionPortalRoleSettingEnforcer
extends Listener<Regions> {
    public RegionPortalRoleSettingEnforcer(Context<Regions> context) {
        super(context);
    }

    public boolean check_setting_at(Location location, Player player, RoleSetting setting, boolean check_against) {
        Region region = ((Regions)this.get_module()).region_at(location);
        if (region == null) {
            return false;
        }
        RegionGroup group = region.region_group((Regions)this.get_module());
        return group.get_role(player.getUniqueId()).get_setting(setting) == check_against;
    }

    public boolean check_setting_at(Block block, Player player, RoleSetting setting, boolean check_against) {
        Region region = ((Regions)this.get_module()).region_at(block);
        if (region == null) {
            return false;
        }
        RegionGroup group = region.region_group((Regions)this.get_module());
        return group.get_role(player.getUniqueId()).get_setting(setting) == check_against;
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_portal_activate(PortalActivateEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (this.check_setting_at(event.getPortal().spawn(), event.getPlayer(), RoleSetting.PORTAL, false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_portal_deactivate(PortalDeactivateEvent event) {
        if (this.check_setting_at(event.getPortal().spawn(), event.getPlayer(), RoleSetting.PORTAL, false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_portal_construct(PortalConstructEvent event) {
        for (Block block : event.getBoundary().all_blocks()) {
            if (!this.check_setting_at(block, event.getPlayer(), RoleSetting.ADMIN, false)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_portal_destroy(PortalDestroyEvent event) {
        if (event.getPortal().owner().equals(event.getPlayer().getUniqueId())) {
            return;
        }
        if (this.check_setting_at(event.getPortal().spawn(), event.getPlayer(), RoleSetting.ADMIN, false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=false)
    public void on_portal_link_console(PortalLinkConsoleEvent event) {
        if (event.getPortal() != null && event.getPortal().owner().equals(event.getPlayer().getUniqueId())) {
            return;
        }
        if (event.getPortal() != null && ((Regions)this.get_module()).region_at(event.getPortal().spawn()) != null) {
            event.setCancelIfNotOwner(false);
        }
        if (this.check_setting_at(event.getConsole(), event.getPlayer(), RoleSetting.ADMIN, false)) {
            event.setCancelled(true);
            return;
        }
        if (event.getPortal() != null && this.check_setting_at(event.getPortal().spawn(), event.getPlayer(), RoleSetting.ADMIN, false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=false)
    public void on_portal_unlink_console(PortalUnlinkConsoleEvent event) {
        if (event.getPortal().owner().equals(event.getPlayer().getUniqueId())) {
            return;
        }
        if (((Regions)this.get_module()).region_at(event.getPortal().spawn()) != null) {
            event.setCancelIfNotOwner(false);
        }
        if (this.check_setting_at(event.getConsole(), event.getPlayer(), RoleSetting.ADMIN, false)) {
            event.setCancelled(true);
            return;
        }
        if (this.check_setting_at(event.getPortal().spawn(), event.getPlayer(), RoleSetting.ADMIN, false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_portal_open_console(PortalOpenConsoleEvent event) {
        if (event.getPortal().owner().equals(event.getPlayer().getUniqueId())) {
            return;
        }
        if (this.check_setting_at(event.getConsole(), event.getPlayer(), RoleSetting.PORTAL, false)) {
            event.setCancelled(true);
            return;
        }
        if (this.check_setting_at(event.getPortal().spawn(), event.getPlayer(), RoleSetting.PORTAL, false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_portal_select_target(PortalSelectTargetEvent event) {
        if (event.getPortal().owner().equals(event.getPlayer().getUniqueId())) {
            return;
        }
        if (this.check_setting_at(event.getPortal().spawn(), event.getPlayer(), RoleSetting.PORTAL, false)) {
            event.setCancelled(true);
            return;
        }
        if (event.getTarget() != null && this.check_setting_at(event.getTarget().spawn(), event.getPlayer(), RoleSetting.PORTAL, false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=false)
    public void on_portal_change_settings(PortalChangeSettingsEvent event) {
        if (event.getPortal().owner().equals(event.getPlayer().getUniqueId())) {
            return;
        }
        if (((Regions)this.get_module()).region_at(event.getPortal().spawn()) == null) {
            return;
        }
        event.setCancelIfNotOwner(false);
        if (this.check_setting_at(event.getPortal().spawn(), event.getPlayer(), RoleSetting.ADMIN, false)) {
            event.setCancelled(true);
        }
    }
}

