/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.regions.event;

import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryInteractEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.regions.Regions;
import org.oddlama.vane.regions.region.Region;
import org.oddlama.vane.regions.region.RegionGroup;
import org.oddlama.vane.regions.region.RoleSetting;

public class RegionRoleSettingEnforcer
extends Listener<Regions> {
    public RegionRoleSettingEnforcer(Context<Regions> context) {
        super(context);
    }

    public boolean check_setting_at(Location location, Player player, RoleSetting setting, boolean check_against) {
        Region region = ((Regions)this.get_module()).region_at(location);
        if (region == null) {
            return false;
        }
        RegionGroup group = region.region_group((Regions)this.get_module());
        return group.get_role(player.getUniqueId()).get_setting(setting) == check_against;
    }

    public boolean check_setting_at(Block block, Player player, RoleSetting setting, boolean check_against) {
        Region region = ((Regions)this.get_module()).region_at(block);
        if (region == null) {
            return false;
        }
        RegionGroup group = region.region_group((Regions)this.get_module());
        return group.get_role(player.getUniqueId()).get_setting(setting) == check_against;
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_block_break(BlockBreakEvent event) {
        if (this.check_setting_at(event.getBlock(), event.getPlayer(), RoleSetting.BUILD, false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_block_place(BlockPlaceEvent event) {
        if (this.check_setting_at(event.getBlock(), event.getPlayer(), RoleSetting.BUILD, false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_entity_damage_by_entity(EntityDamageByEntityEvent event) {
        Entity damaged = event.getEntity();
        Entity damager = event.getDamager();
        switch (damaged.getType()) {
            default: {
                return;
            }
            case ARMOR_STAND: {
                if (!(damager instanceof Player)) break;
                Player player_damager = (Player)damager;
                if (this.check_setting_at(damaged.getLocation().getBlock(), player_damager, RoleSetting.BUILD, false)) {
                    event.setCancelled(true);
                }
                return;
            }
            case ITEM_FRAME: {
                if (!(damager instanceof Player)) break;
                Player player_damager = (Player)damager;
                ItemFrame item_frame = (ItemFrame)damaged;
                ItemStack item = item_frame.getItem();
                if (item.getType() == Material.AIR || !this.check_setting_at(damaged.getLocation().getBlock(), player_damager, RoleSetting.CONTAINER, false)) break;
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_hanging_break_by_entity(HangingBreakByEntityEvent event) {
        Projectile projectile;
        ProjectileSource shooter;
        Entity remover = event.getRemover();
        Player player = null;
        if (remover instanceof Player) {
            player = (Player)remover;
        } else if (remover instanceof Projectile && (shooter = (projectile = (Projectile)remover).getShooter()) instanceof Player) {
            player = (Player)shooter;
        }
        if (player != null && this.check_setting_at(event.getEntity().getLocation(), player, RoleSetting.BUILD, false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_hanging_place(HangingPlaceEvent event) {
        if (this.check_setting_at(event.getEntity().getLocation(), event.getPlayer(), RoleSetting.BUILD, false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_player_armor_stand_manipulate(PlayerArmorStandManipulateEvent event) {
        if (this.check_setting_at(event.getRightClicked().getLocation(), event.getPlayer(), RoleSetting.BUILD, false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_player_bucket_empty(PlayerBucketEmptyEvent event) {
        if (this.check_setting_at(event.getBlockClicked(), event.getPlayer(), RoleSetting.BUILD, false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_player_bucket_fill(PlayerBucketFillEvent event) {
        if (this.check_setting_at(event.getBlockClicked(), event.getPlayer(), RoleSetting.BUILD, false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_player_interact_entity(PlayerInteractEntityEvent event) {
        Entity entity = event.getRightClicked();
        if (entity.getType() != EntityType.ITEM_FRAME) {
            return;
        }
        if (this.check_setting_at(entity.getLocation(), event.getPlayer(), RoleSetting.CONTAINER, false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void on_player_interact(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        switch (event.getAction()) {
            default: {
                return;
            }
            case PHYSICAL: {
                if (Tag.PRESSURE_PLATES.isTagged((Keyed)block.getType())) {
                    if (this.check_setting_at(block, player, RoleSetting.USE, false)) {
                        event.setCancelled(true);
                    }
                } else if (block.getType() == Material.TRIPWIRE && this.check_setting_at(block, player, RoleSetting.USE, false)) {
                    event.setCancelled(true);
                }
                return;
            }
            case RIGHT_CLICK_BLOCK: 
        }
        if (this.check_setting_at(block, player, RoleSetting.USE, false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_player_inventory_open(InventoryOpenEvent event) {
        if (!((Regions)this.get_module()).config_prohibit_viewing_containers) {
            return;
        }
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Inventory inventory = event.getInventory();
        if (inventory.getLocation() == null || inventory.getHolder() == null) {
            return;
        }
        InventoryHolder holder = inventory.getHolder();
        if ((holder instanceof DoubleChest || holder instanceof Container || holder instanceof Minecart) && this.check_setting_at(inventory.getLocation(), player, RoleSetting.CONTAINER, false)) {
            event.setCancelled(true);
        }
    }

    public void on_player_inventory_interact(InventoryInteractEvent event) {
        HumanEntity clicker = event.getWhoClicked();
        if (!(clicker instanceof Player)) {
            return;
        }
        Inventory inventory = event.getInventory();
        if (inventory.getLocation() == null || inventory.getHolder() == null) {
            return;
        }
        InventoryHolder holder = inventory.getHolder();
        if ((holder instanceof DoubleChest || holder instanceof Container || holder instanceof Minecart) && this.check_setting_at(inventory.getLocation(), (Player)clicker, RoleSetting.CONTAINER, false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_player_inventory_click(InventoryClickEvent event) {
        this.on_player_inventory_interact((InventoryInteractEvent)event);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_player_inventory_drag(InventoryDragEvent event) {
        this.on_player_inventory_interact((InventoryInteractEvent)event);
    }
}

