/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.regions.event;

import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.regions.Regions;
import org.oddlama.vane.regions.region.RegionSelection;

public class RegionSelectionListener
extends Listener<Regions> {
    @LangMessage
    public TranslatedMessage lang_select_primary_block;
    @LangMessage
    public TranslatedMessage lang_select_secondary_block;

    public RegionSelectionListener(Context<Regions> context) {
        super(context);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=false)
    public void on_player_interact(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getItem() != null) {
            return;
        }
        Player player = event.getPlayer();
        RegionSelection selection = ((Regions)this.get_module()).get_region_selection(player);
        if (selection == null) {
            return;
        }
        if (player.getEquipment().getItemInMainHand().getType() != Material.AIR || player.getEquipment().getItemInOffHand().getType() != Material.AIR) {
            return;
        }
        Block block = event.getClickedBlock();
        switch (event.getAction()) {
            default: {
                return;
            }
            case LEFT_CLICK_BLOCK: {
                selection.primary = block;
                this.lang_select_primary_block.send((CommandSender)player, new Object[]{"\u00a7b" + block.getX(), "\u00a7b" + block.getY(), "\u00a7b" + block.getZ()});
                break;
            }
            case RIGHT_CLICK_BLOCK: {
                selection.secondary = block;
                this.lang_select_secondary_block.send((CommandSender)player, new Object[]{"\u00a7b" + block.getX(), "\u00a7b" + block.getY(), "\u00a7b" + block.getZ()});
            }
        }
        event.setUseInteractedBlock(Event.Result.DENY);
        event.setUseItemInHand(Event.Result.DENY);
    }
}

