/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.regions.menu;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.core.config.TranslatedItemStack;
import org.oddlama.vane.core.functional.Consumer1;
import org.oddlama.vane.core.functional.Function1;
import org.oddlama.vane.core.functional.Function2;
import org.oddlama.vane.core.functional.Function3;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.menu.Filter;
import org.oddlama.vane.core.menu.Menu;
import org.oddlama.vane.core.menu.MenuFactory;
import org.oddlama.vane.core.menu.MenuItem;
import org.oddlama.vane.core.menu.MenuWidget;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.ModuleComponent;
import org.oddlama.vane.regions.Regions;
import org.oddlama.vane.regions.menu.RegionMenuTag;
import org.oddlama.vane.regions.region.Region;
import org.oddlama.vane.regions.region.RegionGroup;
import org.oddlama.vane.regions.region.RegionSelection;

public class MainMenu
extends ModuleComponent<Regions> {
    @LangMessage
    public TranslatedMessage lang_title;
    @LangMessage
    public TranslatedMessage lang_select_region_title;
    @LangMessage
    public TranslatedMessage lang_filter_regions_title;
    @LangMessage
    public TranslatedMessage lang_select_region_group_title;
    @LangMessage
    public TranslatedMessage lang_filter_region_groups_title;
    public TranslatedItemStack<?> item_create_region_start_selection;
    public TranslatedItemStack<?> item_create_region_invalid_selection;
    public TranslatedItemStack<?> item_create_region_valid_selection;
    public TranslatedItemStack<?> item_cancel_selection;
    public TranslatedItemStack<?> item_current_region;
    public TranslatedItemStack<?> item_list_regions;
    public TranslatedItemStack<?> item_select_region;
    public TranslatedItemStack<?> item_create_region_group;
    public TranslatedItemStack<?> item_current_region_group;
    public TranslatedItemStack<?> item_list_region_groups;
    public TranslatedItemStack<?> item_select_region_group;

    public MainMenu(Context<Regions> context) {
        super((Context)context.namespace("main"));
        Context ctx = this.get_context();
        this.item_create_region_start_selection = new TranslatedItemStack(ctx, "create_region_start_selection", Material.WRITABLE_BOOK, 1, "Used to start creating a new region selection.");
        this.item_create_region_invalid_selection = new TranslatedItemStack(ctx, "create_region_invalid_selection", Material.BARRIER, 1, "Used to indicate an invalid selection.");
        this.item_create_region_valid_selection = new TranslatedItemStack(ctx, "create_region_valid_selection", Material.WRITABLE_BOOK, 1, "Used to create a new region with the current selection.");
        this.item_cancel_selection = new TranslatedItemStack(ctx, "cancel_selection", Material.RED_TERRACOTTA, 1, "Used to cancel region selection.");
        this.item_list_regions = new TranslatedItemStack(ctx, "list_regions", Material.COMPASS, 1, "Used to select a region the player owns.");
        this.item_select_region = new TranslatedItemStack(ctx, "select_region", Material.FILLED_MAP, 1, "Used to represent a region in the region selection list.");
        this.item_current_region = new TranslatedItemStack(ctx, "current_region", Material.FILLED_MAP, 1, "Used to access the region the player currently stands in.");
        this.item_create_region_group = new TranslatedItemStack(ctx, "create_region_group", Material.WRITABLE_BOOK, 1, "Used to create a new region group.");
        this.item_list_region_groups = new TranslatedItemStack(ctx, "list_region_groups", Material.COMPASS, 1, "Used to select a region group the player may administrate.");
        this.item_current_region_group = new TranslatedItemStack(ctx, "current_region_group", Material.GLOBE_BANNER_PATTERN, 1, "Used to access the region group associated with the region the player currently stands in.");
        this.item_select_region_group = new TranslatedItemStack(ctx, "select_region_group", Material.GLOBE_BANNER_PATTERN, 1, "Used to represent a region group in the region group selection list.");
    }

    public Menu create(Player player) {
        int columns = 9;
        Component title = this.lang_title.str_component(new Object[0]);
        Menu main_menu = new Menu(this.get_context(), Bukkit.createInventory(null, (int)9, (Component)title));
        boolean selection_mode = ((Regions)this.get_module()).is_selecting_region(player);
        Region region = ((Regions)this.get_module()).region_at(player.getLocation());
        if (region != null) {
            main_menu.tag((Object)new RegionMenuTag(region.id()));
        }
        if (selection_mode) {
            RegionSelection selection = ((Regions)this.get_module()).get_region_selection(player);
            main_menu.add(this.menu_item_create_region(player, selection));
            main_menu.add(this.menu_item_cancel_selection());
        } else {
            main_menu.add(this.menu_item_start_selection());
            main_menu.add(this.menu_item_list_regions());
            if (region != null && ((Regions)this.get_module()).may_administrate(player, region)) {
                main_menu.add(this.menu_item_current_region(region));
            }
        }
        main_menu.add(this.menu_item_create_region_group());
        main_menu.add(this.menu_item_list_region_groups());
        if (region != null) {
            RegionGroup group = region.region_group((Regions)this.get_module());
            if (((Regions)this.get_module()).may_administrate(player, group)) {
                main_menu.add(this.menu_item_current_region_group(group));
            }
        }
        return main_menu;
    }

    private MenuWidget menu_item_start_selection() {
        return new MenuItem(0, this.item_create_region_start_selection.item(new Object[0]), (Function3 & Serializable)(player, menu, self) -> {
            menu.close(player);
            ((Regions)this.get_module()).start_region_selection((Player)player);
            return Menu.ClickResult.SUCCESS;
        });
    }

    private MenuWidget menu_item_cancel_selection() {
        return new MenuItem(1, this.item_cancel_selection.item(new Object[0]), (Function3 & Serializable)(player, menu, self) -> {
            menu.close(player);
            ((Regions)this.get_module()).cancel_region_selection((Player)player);
            return Menu.ClickResult.SUCCESS;
        });
    }

    private MenuWidget menu_item_create_region(final Player final_player, final RegionSelection selection) {
        return new MenuItem(0, null, (Function3 & Serializable)(player, menu, self) -> {
            if (selection.is_valid(final_player)) {
                menu.close(player);
                ((Regions)this.get_module()).menus.enter_region_name_menu.create((Player)player, (Function2<Player, String, Menu.ClickResult>)(Function2 & Serializable)(player2, name) -> {
                    if (((Regions)this.get_module()).create_region_from_selection(final_player, (String)name)) {
                        return Menu.ClickResult.SUCCESS;
                    }
                    return Menu.ClickResult.ERROR;
                }).on_natural_close((Consumer1 & Serializable)player2 -> menu.open(player2)).open(player);
                return Menu.ClickResult.SUCCESS;
            }
            return Menu.ClickResult.ERROR;
        }){

            public void item(ItemStack item) {
                if (selection.is_valid(final_player)) {
                    int dx = 1 + Math.abs(selection.primary.getX() - selection.secondary.getX());
                    int dy = 1 + Math.abs(selection.primary.getY() - selection.secondary.getY());
                    int dz = 1 + Math.abs(selection.primary.getZ() - selection.secondary.getZ());
                    super.item(MainMenu.this.item_create_region_valid_selection.item(new Object[]{"\u00a7a" + dx, "\u00a7a" + dy, "\u00a7a" + dz, "\u00a7b" + ((Regions)MainMenu.this.get_module()).config_min_region_extent_x, "\u00a7b" + ((Regions)MainMenu.this.get_module()).config_min_region_extent_y, "\u00a7b" + ((Regions)MainMenu.this.get_module()).config_min_region_extent_z, "\u00a7b" + ((Regions)MainMenu.this.get_module()).config_max_region_extent_x, "\u00a7b" + ((Regions)MainMenu.this.get_module()).config_max_region_extent_y, "\u00a7b" + ((Regions)MainMenu.this.get_module()).config_max_region_extent_z, "\u00a7a" + selection.price() + " \u00a7b" + ((Regions)MainMenu.this.get_module()).currency_string()}));
                } else {
                    Object price;
                    boolean can_afford;
                    boolean no_intersection;
                    boolean maximum_satisfied;
                    boolean minimum_satisfied;
                    String sdz;
                    String sdy;
                    String sdx;
                    boolean same_world;
                    boolean is_primary_set = selection.primary != null;
                    boolean is_secondary_set = selection.secondary != null;
                    boolean bl = same_world = is_primary_set && is_secondary_set && selection.primary.getWorld().equals((Object)selection.secondary.getWorld());
                    if (is_primary_set && is_secondary_set && same_world) {
                        int dx = 1 + Math.abs(selection.primary.getX() - selection.secondary.getX());
                        int dy = 1 + Math.abs(selection.primary.getY() - selection.secondary.getY());
                        int dz = 1 + Math.abs(selection.primary.getZ() - selection.secondary.getZ());
                        sdx = Integer.toString(dx);
                        sdy = Integer.toString(dy);
                        sdz = Integer.toString(dz);
                        minimum_satisfied = dx >= ((Regions)MainMenu.this.get_module()).config_min_region_extent_x && dy >= ((Regions)MainMenu.this.get_module()).config_min_region_extent_y && dz >= ((Regions)MainMenu.this.get_module()).config_min_region_extent_z;
                        maximum_satisfied = dx <= ((Regions)MainMenu.this.get_module()).config_max_region_extent_x && dy <= ((Regions)MainMenu.this.get_module()).config_max_region_extent_y && dz <= ((Regions)MainMenu.this.get_module()).config_max_region_extent_z;
                        no_intersection = !selection.intersects_existing();
                        can_afford = selection.can_afford(final_player);
                        price = (can_afford ? "\u00a7a" : "\u00a7c") + selection.price() + " \u00a7b" + ((Regions)MainMenu.this.get_module()).currency_string();
                    } else {
                        sdx = "\u00a77?";
                        sdy = "\u00a77?";
                        sdz = "\u00a77?";
                        minimum_satisfied = false;
                        maximum_satisfied = false;
                        no_intersection = true;
                        can_afford = false;
                        price = "\u00a77?";
                    }
                    String extent_color = minimum_satisfied && maximum_satisfied ? "\u00a7a" : "\u00a7c";
                    super.item(MainMenu.this.item_create_region_invalid_selection.item(new Object[]{is_primary_set ? "\u00a7a\u2713" : "\u00a7c\u2715", is_secondary_set ? "\u00a7a\u2713" : "\u00a7c\u2715", same_world ? "\u00a7a\u2713" : "\u00a7c\u2715", no_intersection ? "\u00a7a\u2713" : "\u00a7c\u2715", minimum_satisfied ? "\u00a7a\u2713" : "\u00a7c\u2715", maximum_satisfied ? "\u00a7a\u2713" : "\u00a7c\u2715", can_afford ? "\u00a7a\u2713" : "\u00a7c\u2715", extent_color + sdx, extent_color + sdy, extent_color + sdz, "\u00a7b" + ((Regions)MainMenu.this.get_module()).config_min_region_extent_x, "\u00a7b" + ((Regions)MainMenu.this.get_module()).config_min_region_extent_y, "\u00a7b" + ((Regions)MainMenu.this.get_module()).config_min_region_extent_z, "\u00a7b" + ((Regions)MainMenu.this.get_module()).config_max_region_extent_x, "\u00a7b" + ((Regions)MainMenu.this.get_module()).config_max_region_extent_y, "\u00a7b" + ((Regions)MainMenu.this.get_module()).config_max_region_extent_z, price}));
                }
            }
        };
    }

    private MenuWidget menu_item_list_regions() {
        return new MenuItem(1, this.item_list_regions.item(new Object[0]), (Function3 & Serializable)(player, menu, self) -> {
            menu.close(player);
            List all_regions = ((Regions)this.get_module()).all_regions().stream().filter(r -> ((Regions)this.get_module()).may_administrate((Player)player, (Region)r)).sorted((a, b) -> a.name().compareToIgnoreCase(b.name())).collect(Collectors.toList());
            Filter.StringFilter filter = new Filter.StringFilter((Function2 & Serializable)(r, str) -> r.name().toLowerCase().contains((CharSequence)str));
            MenuFactory.generic_selector((Context)this.get_context(), (Player)player, (String)this.lang_select_region_title.str(new Object[0]), (String)this.lang_filter_regions_title.str(new Object[0]), all_regions, (Function1 & Serializable)r -> this.item_select_region.item(new Object[]{"\u00a7a\u00a7l" + r.name()}), (Filter)filter, (Function3 & Serializable)(player2, m, region) -> {
                m.close(player2);
                ((Regions)this.get_module()).menus.region_menu.create((Region)region, (Player)player2).open(player2);
                return Menu.ClickResult.SUCCESS;
            }, (Consumer1 & Serializable)player2 -> menu.open(player2)).open(player);
            return Menu.ClickResult.SUCCESS;
        });
    }

    private MenuWidget menu_item_current_region(Region region) {
        return new MenuItem(2, this.item_current_region.item(new Object[]{"\u00a7a\u00a7l" + region.name()}), (Function3 & Serializable)(player, menu, self) -> {
            menu.close(player);
            ((Regions)this.get_module()).menus.region_menu.create(region, (Player)player).open(player);
            return Menu.ClickResult.SUCCESS;
        });
    }

    private MenuWidget menu_item_create_region_group() {
        return new MenuItem(7, this.item_create_region_group.item(new Object[0]), (Function3 & Serializable)(player, menu, self) -> {
            menu.close(player);
            ((Regions)this.get_module()).menus.enter_region_group_name_menu.create((Player)player, (Function2<Player, String, Menu.ClickResult>)(Function2 & Serializable)(player2, name) -> {
                RegionGroup group = new RegionGroup((String)name, player2.getUniqueId());
                ((Regions)this.get_module()).add_region_group(group);
                ((Regions)this.get_module()).menus.region_group_menu.create(group, (Player)player).open(player);
                return Menu.ClickResult.SUCCESS;
            }).on_natural_close((Consumer1 & Serializable)player2 -> menu.open(player2)).open(player);
            return Menu.ClickResult.SUCCESS;
        });
    }

    private MenuWidget menu_item_list_region_groups() {
        return new MenuItem(8, this.item_list_region_groups.item(new Object[0]), (Function3 & Serializable)(player, menu, self) -> {
            menu.close(player);
            List all_region_groups = ((Regions)this.get_module()).all_region_groups().stream().filter(g -> ((Regions)this.get_module()).may_administrate((Player)player, (RegionGroup)g)).sorted((a, b) -> a.name().compareToIgnoreCase(b.name())).collect(Collectors.toList());
            Filter.StringFilter filter = new Filter.StringFilter((Function2 & Serializable)(r, str) -> r.name().toLowerCase().contains((CharSequence)str));
            MenuFactory.generic_selector((Context)this.get_context(), (Player)player, (String)this.lang_select_region_group_title.str(new Object[0]), (String)this.lang_filter_region_groups_title.str(new Object[0]), all_region_groups, (Function1 & Serializable)r -> this.item_select_region_group.item(new Object[]{"\u00a7a\u00a7l" + r.name()}), (Filter)filter, (Function3 & Serializable)(player2, m, group) -> {
                m.close(player2);
                ((Regions)this.get_module()).menus.region_group_menu.create((RegionGroup)group, (Player)player).open(player);
                return Menu.ClickResult.SUCCESS;
            }, (Consumer1 & Serializable)player2 -> menu.open(player2)).open(player);
            return Menu.ClickResult.SUCCESS;
        });
    }

    private MenuWidget menu_item_current_region_group(RegionGroup region_group) {
        return new MenuItem(6, this.item_current_region_group.item(new Object[]{"\u00a7a\u00a7l" + region_group.name()}), (Function3 & Serializable)(player, menu, self) -> {
            menu.close(player);
            ((Regions)this.get_module()).menus.region_group_menu.create(region_group, (Player)player).open(player);
            return Menu.ClickResult.SUCCESS;
        });
    }

    public void on_enable() {
    }

    public void on_disable() {
    }
}

