/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.regions.menu;

import java.io.Serializable;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.core.config.TranslatedItemStack;
import org.oddlama.vane.core.functional.Consumer1;
import org.oddlama.vane.core.functional.Function1;
import org.oddlama.vane.core.functional.Function2;
import org.oddlama.vane.core.functional.Function3;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.menu.Filter;
import org.oddlama.vane.core.menu.Menu;
import org.oddlama.vane.core.menu.MenuFactory;
import org.oddlama.vane.core.menu.MenuItem;
import org.oddlama.vane.core.menu.MenuWidget;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.ModuleComponent;
import org.oddlama.vane.regions.Regions;
import org.oddlama.vane.regions.menu.RegionGroupMenuTag;
import org.oddlama.vane.regions.region.EnvironmentSetting;
import org.oddlama.vane.regions.region.RegionGroup;
import org.oddlama.vane.regions.region.Role;
import org.oddlama.vane.util.StorageUtil;

public class RegionGroupMenu
extends ModuleComponent<Regions> {
    @LangMessage
    public TranslatedMessage lang_title;
    @LangMessage
    public TranslatedMessage lang_delete_confirm_title;
    @LangMessage
    public TranslatedMessage lang_select_role_title;
    @LangMessage
    public TranslatedMessage lang_filter_roles_title;
    public TranslatedItemStack<?> item_rename;
    public TranslatedItemStack<?> item_delete;
    public TranslatedItemStack<?> item_delete_confirm_accept;
    public TranslatedItemStack<?> item_delete_confirm_cancel;
    public TranslatedItemStack<?> item_create_role;
    public TranslatedItemStack<?> item_list_roles;
    public TranslatedItemStack<?> item_select_role;
    public TranslatedItemStack<?> item_setting_toggle_on;
    public TranslatedItemStack<?> item_setting_toggle_off;
    public TranslatedItemStack<?> item_setting_info_animals;
    public TranslatedItemStack<?> item_setting_info_monsters;
    public TranslatedItemStack<?> item_setting_info_explosions;
    public TranslatedItemStack<?> item_setting_info_fire;
    public TranslatedItemStack<?> item_setting_info_pvp;
    public TranslatedItemStack<?> item_setting_info_trample;
    public TranslatedItemStack<?> item_setting_info_vine_growth;

    public RegionGroupMenu(Context<Regions> context) {
        super((Context)context.namespace("region_group"));
        Context ctx = this.get_context();
        this.item_rename = new TranslatedItemStack(ctx, "rename", Material.NAME_TAG, 1, "Used to rename the region group.");
        this.item_delete = new TranslatedItemStack(ctx, "delete", StorageUtil.namespaced_key((String)"vane", (String)"decoration_tnt_1"), 1, "Used to delete this region group.");
        this.item_delete_confirm_accept = new TranslatedItemStack(ctx, "delete_confirm_accept", StorageUtil.namespaced_key((String)"vane", (String)"decoration_tnt_1"), 1, "Used to confirm deleting the region group.");
        this.item_delete_confirm_cancel = new TranslatedItemStack(ctx, "delete_confirm_cancel", Material.PRISMARINE_SHARD, 1, "Used to cancel deleting the region group.");
        this.item_create_role = new TranslatedItemStack(ctx, "create_role", Material.WRITABLE_BOOK, 1, "Used to create a new role.");
        this.item_list_roles = new TranslatedItemStack(ctx, "list_roles", Material.GLOBE_BANNER_PATTERN, 1, "Used to list all defined roles.");
        this.item_select_role = new TranslatedItemStack(ctx, "select_role", Material.GLOBE_BANNER_PATTERN, 1, "Used to represent a role in the role selection list.");
        this.item_setting_toggle_on = new TranslatedItemStack(ctx, "setting_toggle_on", Material.GREEN_TERRACOTTA, 1, "Used to represent a toggle button with current state on.");
        this.item_setting_toggle_off = new TranslatedItemStack(ctx, "setting_toggle_off", Material.RED_TERRACOTTA, 1, "Used to represent a toggle button with current state off.");
        this.item_setting_info_animals = new TranslatedItemStack(ctx, "setting_info_animals", StorageUtil.namespaced_key((String)"vane", (String)"animals_baby_pig_2"), 1, "Used to represent the info for the animals setting.");
        this.item_setting_info_monsters = new TranslatedItemStack(ctx, "setting_info_monsters", Material.ZOMBIE_HEAD, 1, "Used to represent the info for the monsters setting.");
        this.item_setting_info_explosions = new TranslatedItemStack(ctx, "setting_info_explosions", StorageUtil.namespaced_key((String)"vane", (String)"monsters_creeper_with_tnt_2"), 1, "Used to represent the info for the explosions setting.");
        this.item_setting_info_fire = new TranslatedItemStack(ctx, "setting_info_fire", Material.CAMPFIRE, 1, "Used to represent the info for the fire setting.");
        this.item_setting_info_pvp = new TranslatedItemStack(ctx, "setting_info_pvp", Material.IRON_SWORD, 1, "Used to represent the info for the pvp setting.");
        this.item_setting_info_trample = new TranslatedItemStack(ctx, "setting_info_trample", Material.FARMLAND, 1, "Used to represent the info for the trample setting.");
        this.item_setting_info_vine_growth = new TranslatedItemStack(ctx, "setting_info_vine_growth", Material.VINE, 1, "Used to represent the info for the vine growth setting.");
    }

    public Menu create(RegionGroup group, Player player) {
        int columns = 9;
        int rows = 3;
        Component title = this.lang_title.str_component(new Object[]{"\u00a75\u00a7l" + group.name()});
        Menu region_group_menu = new Menu(this.get_context(), Bukkit.createInventory(null, (int)27, (Component)title));
        region_group_menu.tag((Object)new RegionGroupMenuTag(group.id()));
        boolean is_owner = player.getUniqueId().equals(group.owner());
        if (is_owner) {
            region_group_menu.add(this.menu_item_rename(group));
            if (!((Regions)this.get_module()).get_or_create_default_region_group(player).id().equals(group.id())) {
                region_group_menu.add(this.menu_item_delete(group));
            }
        }
        region_group_menu.add(this.menu_item_create_role(group));
        region_group_menu.add(this.menu_item_list_roles(group));
        this.add_menu_item_setting(region_group_menu, group, 0, this.item_setting_info_animals, EnvironmentSetting.ANIMALS);
        this.add_menu_item_setting(region_group_menu, group, 1, this.item_setting_info_monsters, EnvironmentSetting.MONSTERS);
        this.add_menu_item_setting(region_group_menu, group, 3, this.item_setting_info_explosions, EnvironmentSetting.EXPLOSIONS);
        this.add_menu_item_setting(region_group_menu, group, 4, this.item_setting_info_fire, EnvironmentSetting.FIRE);
        this.add_menu_item_setting(region_group_menu, group, 5, this.item_setting_info_pvp, EnvironmentSetting.PVP);
        this.add_menu_item_setting(region_group_menu, group, 7, this.item_setting_info_trample, EnvironmentSetting.TRAMPLE);
        this.add_menu_item_setting(region_group_menu, group, 8, this.item_setting_info_vine_growth, EnvironmentSetting.VINE_GROWTH);
        region_group_menu.on_natural_close((Consumer1 & Serializable)player2 -> ((Regions)this.get_module()).menus.main_menu.create((Player)player2).open(player2));
        return region_group_menu;
    }

    private MenuWidget menu_item_rename(RegionGroup group) {
        return new MenuItem(0, this.item_rename.item(new Object[0]), (Function3 & Serializable)(player, menu, self) -> {
            menu.close(player);
            ((Regions)this.get_module()).menus.enter_region_group_name_menu.create((Player)player, group.name(), (Function2<Player, String, Menu.ClickResult>)(Function2 & Serializable)(player2, name) -> {
                group.name((String)name);
                this.mark_persistent_storage_dirty();
                ((Regions)this.get_module()).menus.region_group_menu.create(group, (Player)player2).open(player2);
                return Menu.ClickResult.SUCCESS;
            }).on_natural_close((Consumer1 & Serializable)player2 -> ((Regions)this.get_module()).menus.region_group_menu.create(group, (Player)player2).open(player2)).open(player);
            return Menu.ClickResult.SUCCESS;
        });
    }

    private MenuWidget menu_item_delete(RegionGroup group) {
        String orphan_checkbox = group.is_orphan((Regions)this.get_module()) ? "\u00a7a\u2713" : "\u00a7c\u2715";
        return new MenuItem(1, this.item_delete.item(new Object[]{orphan_checkbox}), (Function3 & Serializable)(player, menu, self) -> {
            if (!group.is_orphan((Regions)this.get_module())) {
                return Menu.ClickResult.ERROR;
            }
            menu.close(player);
            MenuFactory.confirm((Context)this.get_context(), (String)this.lang_delete_confirm_title.str(new Object[0]), (ItemStack)this.item_delete_confirm_accept.item(new Object[0]), (Function1 & Serializable)player2 -> {
                if (!player2.getUniqueId().equals(group.owner())) {
                    return Menu.ClickResult.ERROR;
                }
                if (((Regions)this.get_module()).get_or_create_default_region_group((Player)player2).id().equals(group.id())) {
                    return Menu.ClickResult.ERROR;
                }
                ((Regions)this.get_module()).remove_region_group(group);
                return Menu.ClickResult.SUCCESS;
            }, (ItemStack)this.item_delete_confirm_cancel.item(new Object[0]), (Consumer1 & Serializable)player2 -> menu.open(player2)).tag((Object)new RegionGroupMenuTag(group.id())).open(player);
            return Menu.ClickResult.SUCCESS;
        });
    }

    private MenuWidget menu_item_create_role(RegionGroup group) {
        return new MenuItem(7, this.item_create_role.item(new Object[0]), (Function3 & Serializable)(player, menu, self) -> {
            menu.close(player);
            ((Regions)this.get_module()).menus.enter_role_name_menu.create((Player)player, (Function2<Player, String, Menu.ClickResult>)(Function2 & Serializable)(player2, name) -> {
                Role role = new Role((String)name, Role.RoleType.NORMAL);
                group.add_role(role);
                this.mark_persistent_storage_dirty();
                ((Regions)this.get_module()).menus.role_menu.create(group, role, (Player)player).open(player);
                return Menu.ClickResult.SUCCESS;
            }).on_natural_close((Consumer1 & Serializable)player2 -> menu.open(player2)).open(player);
            return Menu.ClickResult.SUCCESS;
        });
    }

    private MenuWidget menu_item_list_roles(RegionGroup group) {
        return new MenuItem(8, this.item_list_roles.item(new Object[0]), (Function3 & Serializable)(player, menu, self) -> {
            menu.close(player);
            List all_roles = group.roles().stream().sorted((a, b) -> a.name().compareToIgnoreCase(b.name())).collect(Collectors.toList());
            Filter.StringFilter filter = new Filter.StringFilter((Function2 & Serializable)(r, str) -> r.name().toLowerCase().contains((CharSequence)str));
            MenuFactory.generic_selector((Context)this.get_context(), (Player)player, (String)this.lang_select_role_title.str(new Object[0]), (String)this.lang_filter_roles_title.str(new Object[0]), all_roles, (Function1 & Serializable)r -> this.item_select_role.item(new Object[]{r.color() + "\u00a7l" + r.name()}), (Filter)filter, (Function3 & Serializable)(player2, m, role) -> {
                m.close(player2);
                ((Regions)this.get_module()).menus.role_menu.create(group, (Role)role, (Player)player2).open(player2);
                return Menu.ClickResult.SUCCESS;
            }, (Consumer1 & Serializable)player2 -> menu.open(player2)).open(player);
            return Menu.ClickResult.SUCCESS;
        });
    }

    private void add_menu_item_setting(Menu region_group_menu, final RegionGroup group, int col, TranslatedItemStack<?> item_info, final EnvironmentSetting setting) {
        region_group_menu.add((MenuWidget)new MenuItem(9 + col, item_info.item(new Object[0]), (Function3 & Serializable)(player, menu, self) -> Menu.ClickResult.IGNORE));
        region_group_menu.add((MenuWidget)new MenuItem(18 + col, null, (Function3 & Serializable)(player, menu, self) -> {
            if (setting.has_override()) {
                return Menu.ClickResult.ERROR;
            }
            group.settings().put(setting, !group.get_setting(setting));
            this.mark_persistent_storage_dirty();
            menu.update();
            return Menu.ClickResult.SUCCESS;
        }){

            public void item(ItemStack item) {
                Consumer<List> maybe_add_forced_hint = lore -> {
                    if (setting.has_override()) {
                        lore.add(Component.empty());
                        lore.add(Component.text((String)"FORCED BY SERVER"));
                    }
                };
                if (group.get_setting(setting)) {
                    super.item(RegionGroupMenu.this.item_setting_toggle_on.item_transform_lore(maybe_add_forced_hint, new Object[0]));
                } else {
                    super.item(RegionGroupMenu.this.item_setting_toggle_off.item_transform_lore(maybe_add_forced_hint, new Object[0]));
                }
            }
        });
    }

    public void on_enable() {
    }

    public void on_disable() {
    }
}

