/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.regions.menu;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.core.config.TranslatedItemStack;
import org.oddlama.vane.core.functional.Consumer1;
import org.oddlama.vane.core.functional.Function1;
import org.oddlama.vane.core.functional.Function2;
import org.oddlama.vane.core.functional.Function3;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.menu.Filter;
import org.oddlama.vane.core.menu.Menu;
import org.oddlama.vane.core.menu.MenuFactory;
import org.oddlama.vane.core.menu.MenuItem;
import org.oddlama.vane.core.menu.MenuWidget;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.ModuleComponent;
import org.oddlama.vane.regions.Regions;
import org.oddlama.vane.regions.menu.RegionMenuTag;
import org.oddlama.vane.regions.region.Region;
import org.oddlama.vane.regions.region.RegionGroup;
import org.oddlama.vane.regions.region.RegionSelection;
import org.oddlama.vane.util.PlayerUtil;
import org.oddlama.vane.util.StorageUtil;

public class RegionMenu
extends ModuleComponent<Regions> {
    @LangMessage
    public TranslatedMessage lang_title;
    @LangMessage
    public TranslatedMessage lang_delete_confirm_title;
    @LangMessage
    public TranslatedMessage lang_select_region_group_title;
    @LangMessage
    public TranslatedMessage lang_filter_region_groups_title;
    public TranslatedItemStack<?> item_rename;
    public TranslatedItemStack<?> item_delete;
    public TranslatedItemStack<?> item_delete_confirm_accept;
    public TranslatedItemStack<?> item_delete_confirm_cancel;
    public TranslatedItemStack<?> item_assign_region_group;
    public TranslatedItemStack<?> item_select_region_group;

    public RegionMenu(Context<Regions> context) {
        super((Context)context.namespace("region"));
        Context ctx = this.get_context();
        this.item_rename = new TranslatedItemStack(ctx, "rename", Material.NAME_TAG, 1, "Used to rename the region.");
        this.item_delete = new TranslatedItemStack(ctx, "delete", StorageUtil.namespaced_key((String)"vane", (String)"decoration_tnt_1"), 1, "Used to delete this region.");
        this.item_delete_confirm_accept = new TranslatedItemStack(ctx, "delete_confirm_accept", StorageUtil.namespaced_key((String)"vane", (String)"decoration_tnt_1"), 1, "Used to confirm deleting the region.");
        this.item_delete_confirm_cancel = new TranslatedItemStack(ctx, "delete_confirm_cancel", Material.PRISMARINE_SHARD, 1, "Used to cancel deleting the region.");
        this.item_assign_region_group = new TranslatedItemStack(ctx, "assign_region_group", Material.GLOBE_BANNER_PATTERN, 1, "Used to assign a region group.");
        this.item_select_region_group = new TranslatedItemStack(ctx, "select_region_group", Material.GLOBE_BANNER_PATTERN, 1, "Used to represent a region group in the region group assignment list.");
    }

    public Menu create(Region region, Player player) {
        int columns = 9;
        Component title = this.lang_title.str_component(new Object[]{"\u00a75\u00a7l" + region.name()});
        Menu region_menu = new Menu(this.get_context(), Bukkit.createInventory(null, (int)9, (Component)title));
        region_menu.tag((Object)new RegionMenuTag(region.id()));
        if (((Regions)this.get_module()).may_administrate(player, region)) {
            region_menu.add(this.menu_item_rename(region));
            region_menu.add(this.menu_item_delete(region));
            region_menu.add(this.menu_item_assign_region_group(region));
        }
        region_menu.on_natural_close((Consumer1 & Serializable)player2 -> ((Regions)this.get_module()).menus.main_menu.create((Player)player2).open(player2));
        return region_menu;
    }

    private MenuWidget menu_item_rename(Region region) {
        return new MenuItem(0, this.item_rename.item(new Object[0]), (Function3 & Serializable)(player, menu, self) -> {
            menu.close(player);
            if (!((Regions)this.get_module()).may_administrate((Player)player, region)) {
                return Menu.ClickResult.ERROR;
            }
            ((Regions)this.get_module()).menus.enter_region_name_menu.create((Player)player, region.name(), (Function2<Player, String, Menu.ClickResult>)(Function2 & Serializable)(player2, name) -> {
                region.name((String)name);
                ((Regions)this.get_module()).update_marker(region);
                ((Regions)this.get_module()).menus.region_menu.create(region, (Player)player2).open(player2);
                return Menu.ClickResult.SUCCESS;
            }).on_natural_close((Consumer1 & Serializable)player2 -> ((Regions)this.get_module()).menus.region_menu.create(region, (Player)player2).open(player2)).open(player);
            return Menu.ClickResult.SUCCESS;
        });
    }

    private MenuWidget menu_item_delete(Region region) {
        return new MenuItem(1, this.item_delete.item(new Object[0]), (Function3 & Serializable)(player, menu, self) -> {
            menu.close(player);
            MenuFactory.confirm((Context)this.get_context(), (String)this.lang_delete_confirm_title.str(new Object[0]), (ItemStack)this.item_delete_confirm_accept.item(new Object[0]), (Function1 & Serializable)player2 -> {
                if (!((Regions)this.get_module()).may_administrate((Player)player2, region)) {
                    return Menu.ClickResult.ERROR;
                }
                ((Regions)this.get_module()).remove_region(region);
                RegionSelection temp_sel = new RegionSelection((Regions)this.get_module());
                temp_sel.primary = region.extent().min();
                temp_sel.secondary = region.extent().max();
                double price = temp_sel.price();
                if (((Regions)this.get_module()).config_economy_as_currency) {
                    EconomyResponse transaction = ((Regions)this.get_module()).economy.deposit((OfflinePlayer)player2, price);
                    if (!transaction.transactionSuccess()) {
                        ((Regions)this.get_module()).log.severe("Player " + String.valueOf(player2) + " deleted region '" + region.name() + "' (cost " + price + ") but the economy plugin failed to deposit:");
                        ((Regions)this.get_module()).log.severe("Error message: " + transaction.errorMessage);
                    }
                } else {
                    PlayerUtil.give_items((Player)player2, (ItemStack)new ItemStack(((Regions)this.get_module()).config_currency), (int)((int)price));
                }
                return Menu.ClickResult.SUCCESS;
            }, (ItemStack)this.item_delete_confirm_cancel.item(new Object[0]), (Consumer1 & Serializable)player2 -> menu.open(player2)).tag((Object)new RegionMenuTag(region.id())).open(player);
            return Menu.ClickResult.SUCCESS;
        });
    }

    private MenuWidget menu_item_assign_region_group(Region region) {
        return new MenuItem(2, this.item_assign_region_group.item(new Object[0]), (Function3 & Serializable)(player, menu, self) -> {
            menu.close(player);
            List all_region_groups = ((Regions)this.get_module()).all_region_groups().stream().filter(g -> ((Regions)this.get_module()).may_administrate((Player)player, (RegionGroup)g)).sorted((a, b) -> a.name().compareToIgnoreCase(b.name())).collect(Collectors.toList());
            Filter.StringFilter filter = new Filter.StringFilter((Function2 & Serializable)(r, str) -> r.name().toLowerCase().contains((CharSequence)str));
            MenuFactory.generic_selector((Context)this.get_context(), (Player)player, (String)this.lang_select_region_group_title.str(new Object[0]), (String)this.lang_filter_region_groups_title.str(new Object[0]), all_region_groups, (Function1 & Serializable)r -> this.item_select_region_group.item(new Object[]{"\u00a7a\u00a7l" + r.name()}), (Filter)filter, (Function3 & Serializable)(player2, m, group) -> {
                if (!((Regions)this.get_module()).may_administrate((Player)player2, region)) {
                    return Menu.ClickResult.ERROR;
                }
                m.close(player2);
                region.region_group_id(group.id());
                this.mark_persistent_storage_dirty();
                menu.open(player2);
                return Menu.ClickResult.SUCCESS;
            }, (Consumer1 & Serializable)player2 -> menu.open(player2)).open(player);
            return Menu.ClickResult.SUCCESS;
        });
    }

    public void on_enable() {
    }

    public void on_disable() {
    }
}

